/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.kura.templates.bluetooth;

import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.kura.templates.Utils;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class DeviceBluetoothFinderTemplate
implements IFileTemplate<InformationModel> {
    public String getFileName(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = context.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"BluetoothFinder.java");
        return _builder.toString();
    }

    public String getPath(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        String _javaPackageBasePath = Utils.getJavaPackageBasePath();
        _builder.append((Object)_javaPackageBasePath, "");
        return _builder.toString();
    }

    public String getContent(InformationModel element, InvocationContext context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        String _javaPackage = Utils.getJavaPackage();
        _builder.append((Object)_javaPackage, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import java.util.ArrayList;");
        _builder.newLine();
        _builder.append((Object)"import java.util.Date;");
        _builder.newLine();
        _builder.append((Object)"import java.util.List;");
        _builder.newLine();
        _builder.append((Object)"import java.util.Map;");
        _builder.newLine();
        _builder.append((Object)"import java.util.concurrent.Executors;");
        _builder.newLine();
        _builder.append((Object)"import java.util.concurrent.ScheduledExecutorService;");
        _builder.newLine();
        _builder.append((Object)"import java.util.concurrent.ScheduledFuture;");
        _builder.newLine();
        _builder.append((Object)"import java.util.concurrent.TimeUnit;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.kura.bluetooth.BluetoothAdapter;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.kura.bluetooth.BluetoothDevice;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.kura.bluetooth.BluetoothGattSecurityLevel;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.kura.bluetooth.BluetoothLeScanListener;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.kura.bluetooth.BluetoothService;");
        _builder.newLine();
        Map _configurationProperties = context.getConfigurationProperties();
        String _orDefault = _configurationProperties.getOrDefault("boschcloud", "false");
        boolean _equalsIgnoreCase = _orDefault.equalsIgnoreCase("false");
        if (_equalsIgnoreCase) {
            _builder.append((Object)"import org.eclipse.kura.cloud.CloudClient;");
            _builder.newLine();
            _builder.append((Object)"import org.eclipse.kura.cloud.CloudClientListener;");
            _builder.newLine();
            _builder.append((Object)"import org.eclipse.kura.cloud.CloudService;");
            _builder.newLine();
            _builder.append((Object)"import org.eclipse.kura.message.KuraPayload;");
            _builder.newLine();
            _builder.append((Object)"import org.eclipse.kura.KuraException;");
            _builder.newLine();
        }
        _builder.append((Object)"import org.eclipse.kura.configuration.ConfigurableComponent;");
        _builder.newLine();
        _builder.append((Object)"import org.osgi.service.component.ComponentContext;");
        _builder.newLine();
        _builder.append((Object)"import org.osgi.service.component.ComponentException;");
        _builder.newLine();
        _builder.append((Object)"import org.slf4j.Logger;");
        _builder.newLine();
        _builder.append((Object)"import org.slf4j.LoggerFactory;");
        _builder.newLine();
        _builder.newLine();
        Map _configurationProperties_1 = context.getConfigurationProperties();
        String _orDefault_1 = _configurationProperties_1.getOrDefault("boschcloud", "false");
        boolean _equalsIgnoreCase_1 = _orDefault_1.equalsIgnoreCase("true");
        if (_equalsIgnoreCase_1) {
            _builder.append((Object)"import ");
            String _javaPackage_1 = Utils.getJavaPackage();
            _builder.append((Object)_javaPackage_1, "");
            _builder.append((Object)".cloud.*;");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"import ");
            String _javaPackage_2 = Utils.getJavaPackage();
            _builder.append((Object)_javaPackage_2, "");
            _builder.append((Object)".cloud.bosch.BoschDataService;");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _name = element.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"BluetoothFinder implements ConfigurableComponent, BluetoothLeScanListener");
        Map _configurationProperties_2 = context.getConfigurationProperties();
        String _orDefault_2 = _configurationProperties_2.getOrDefault("boschcloud", "false");
        boolean _equalsIgnoreCase_2 = _orDefault_2.equalsIgnoreCase("false");
        if (_equalsIgnoreCase_2) {
            _builder.append((Object)", CloudClientListener");
        }
        _builder.append((Object)"  {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private static final Logger logger = LoggerFactory.getLogger(");
        String _name_1 = element.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append((Object)"BluetoothFinder.class);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private final String APP_ID = \"BLE_APP_V1\";");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private final String PROPERTY_SCAN = \"scan_enable\";");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private final String PROPERTY_SCANTIME = \"scan_time\";");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private final String PROPERTY_PERIOD = \"period\";");
        _builder.newLine();
        EList _properties = element.getProperties();
        for (FunctionblockProperty fbProperty : _properties) {
            _builder.append((Object)"\t");
            _builder.append((Object)"private final String PROPERTY_");
            String _name_2 = fbProperty.getName();
            String _upperCase = _name_2.toUpperCase();
            _builder.append((Object)_upperCase, "\t");
            _builder.append((Object)" = \"enable");
            String _name_3 = fbProperty.getName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_name_3);
            _builder.append((Object)_firstUpper, "\t");
            _builder.append((Object)"\";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        Map _configurationProperties_3 = context.getConfigurationProperties();
        String _orDefault_3 = _configurationProperties_3.getOrDefault("boschcloud", "false");
        boolean _equalsIgnoreCase_3 = _orDefault_3.equalsIgnoreCase("true");
        if (_equalsIgnoreCase_3) {
            _builder.append((Object)"\t");
            _builder.append((Object)"private final String PROPERTY_BOSCHCLOUD_ENDPOINT = \"boschcloud_endpoint\";");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private final String PROPERTY_BOSCHCLOUD_SOLUTIONID = \"boschcloud_solutionid\";");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private final String PROPERTY_INAME = \"iname\";");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        Map _configurationProperties_4 = context.getConfigurationProperties();
        String _orDefault_4 = _configurationProperties_4.getOrDefault("boschcloud", "false");
        boolean _equalsIgnoreCase_4 = _orDefault_4.equalsIgnoreCase("false");
        if (_equalsIgnoreCase_4) {
            _builder.append((Object)"\t");
            _builder.append((Object)"private CloudService cloudService;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private static CloudClient cloudClient;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private static String topic = \"data\";");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"private List<");
        String _name_4 = element.getName();
        _builder.append((Object)_name_4, "\t");
        _builder.append((Object)"Device> ");
        String _name_5 = element.getName();
        String _lowerCase = _name_5.toLowerCase();
        _builder.append((Object)_lowerCase, "\t");
        _builder.append((Object)"List;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"private BluetoothService bluetoothService;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private BluetoothAdapter bluetoothAdapter;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private ScheduledExecutorService worker;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private ScheduledFuture<?> handle;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private int period = 10;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private int scantime = 5;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private long startTime;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private boolean connected = false;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private String iname = \"hci0\";");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private boolean enableScan = false;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        EList _properties_1 = element.getProperties();
        for (FunctionblockProperty fbProperty_1 : _properties_1) {
            _builder.append((Object)"\t");
            _builder.append((Object)"private boolean enable");
            String _name_6 = fbProperty_1.getName();
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_6);
            _builder.append((Object)_firstUpper_1, "\t");
            _builder.append((Object)" = false;");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        Map _configurationProperties_5 = context.getConfigurationProperties();
        String _orDefault_5 = _configurationProperties_5.getOrDefault("boschcloud", "false");
        boolean _equalsIgnoreCase_5 = _orDefault_5.equalsIgnoreCase("true");
        if (_equalsIgnoreCase_5) {
            _builder.append((Object)"private IDataService dataService;");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void setBluetoothService(BluetoothService bluetoothService) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.bluetoothService = bluetoothService;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void unsetBluetoothService(BluetoothService bluetoothService) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.bluetoothService = null;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// --------------------------------------------------------------------");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"//");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// Activation APIs");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"//");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// --------------------------------------------------------------------");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"protected void activate(ComponentContext context, Map<String, Object> properties) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"logger.info(\"Activating ");
        String _name_7 = element.getName();
        _builder.append((Object)_name_7, "\t\t");
        _builder.append((Object)" App...\");");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"readProperties(properties);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.");
        String _name_8 = element.getName();
        String _lowerCase_1 = _name_8.toLowerCase();
        _builder.append((Object)_lowerCase_1, "\t\t");
        _builder.append((Object)"List = new ArrayList<");
        String _name_9 = element.getName();
        _builder.append((Object)_name_9, "\t\t");
        _builder.append((Object)"Device>();");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        Map _configurationProperties_6 = context.getConfigurationProperties();
        String _orDefault_6 = _configurationProperties_6.getOrDefault("boschcloud", "false");
        boolean _equalsIgnoreCase_6 = _orDefault_6.equalsIgnoreCase("false");
        if (_equalsIgnoreCase_6) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"try {");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"cloudClient = this.cloudService.newCloudClient(this.APP_ID);");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"cloudClient.addCloudClientListener(this);");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"} catch (KuraException e1) {");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"logger.error(\"Error starting component\", e1);");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"throw new ComponentException(e1);");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (this.enableScan) {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"this.worker = Executors.newSingleThreadScheduledExecutor();");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"// Get Bluetooth adapter and ensure it is enabled");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"this.bluetoothAdapter = this.bluetoothService.getBluetoothAdapter(this.iname);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"if (this.bluetoothAdapter != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"logger.info(\"Bluetooth adapter interface => \" + this.iname);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"logger.info(\"Bluetooth adapter address => \" + this.bluetoothAdapter.getAddress());");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"logger.info(\"Bluetooth adapter le enabled => \" + this.bluetoothAdapter.isLeReady());");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"if (!this.bluetoothAdapter.isEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"logger.info(\"Enabling bluetooth adapter...\");");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"this.bluetoothAdapter.enable();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"logger.info(\"Bluetooth adapter address => \" + this.bluetoothAdapter.getAddress());");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"this.startTime = 0;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"this.connected = false;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"this.handle = this.worker.scheduleAtFixedRate(new Runnable() {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"public void run() {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t\t");
        _builder.append((Object)"checkScan();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"}, 0, 1, TimeUnit.SECONDS);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"logger.warn(\"No Bluetooth adapter found ...\");");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"} catch (Exception e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"logger.error(\"Error starting component\", e);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"throw new ComponentException(e);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"protected void deactivate(ComponentContext context) {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"logger.debug(\"Deactivating ");
        String _name_10 = element.getName();
        _builder.append((Object)_name_10, "\t\t");
        _builder.append((Object)" App...\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (this.bluetoothAdapter != null && this.bluetoothAdapter.isScanning()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.debug(\"m_bluetoothAdapter.isScanning\");");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"this.bluetoothAdapter.killLeScan();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (");
        String _name_11 = element.getName();
        _builder.append((Object)_name_11, "\t\t");
        _builder.append((Object)"Device ");
        String _name_12 = element.getName();
        String _lowerCase_2 = _name_12.toLowerCase();
        _builder.append((Object)_lowerCase_2, "\t\t");
        _builder.append((Object)" : this.");
        String _name_13 = element.getName();
        String _lowerCase_3 = _name_13.toLowerCase();
        _builder.append((Object)_lowerCase_3, "\t\t");
        _builder.append((Object)"List) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (");
        String _name_14 = element.getName();
        String _lowerCase_4 = _name_14.toLowerCase();
        _builder.append((Object)_lowerCase_4, "\t\t\t");
        _builder.append((Object)" != null) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        String _name_15 = element.getName();
        String _lowerCase_5 = _name_15.toLowerCase();
        _builder.append((Object)_lowerCase_5, "\t\t\t\t");
        _builder.append((Object)".disconnect();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.");
        String _name_16 = element.getName();
        String _lowerCase_6 = _name_16.toLowerCase();
        _builder.append((Object)_lowerCase_6, "\t\t");
        _builder.append((Object)"List.clear();");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// cancel a current worker handle if one if active");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (this.handle != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"this.handle.cancel(true);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// shutting down the worker and cleaning up the properties");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (this.worker != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"this.worker.shutdown();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// cancel bluetoothAdapter");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.bluetoothAdapter = null;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"logger.debug(\"Deactivating ");
        String _name_17 = element.getName();
        _builder.append((Object)_name_17, "\t\t");
        _builder.append((Object)" App... Done.\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"protected void updated(Map<String, Object> properties) {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"readProperties(properties);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.debug(\"Deactivating ");
        String _name_18 = element.getName();
        _builder.append((Object)_name_18, "\t\t\t");
        _builder.append((Object)" App...\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (this.bluetoothAdapter != null && this.bluetoothAdapter.isScanning()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"logger.debug(\"m_bluetoothAdapter.isScanning\");");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"this.bluetoothAdapter.killLeScan();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"for (");
        String _name_19 = element.getName();
        _builder.append((Object)_name_19, "\t\t\t");
        _builder.append((Object)"Device ");
        String _name_20 = element.getName();
        String _lowerCase_7 = _name_20.toLowerCase();
        _builder.append((Object)_lowerCase_7, "\t\t\t");
        _builder.append((Object)" : this.");
        String _name_21 = element.getName();
        String _lowerCase_8 = _name_21.toLowerCase();
        _builder.append((Object)_lowerCase_8, "\t\t\t");
        _builder.append((Object)"List) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"if (");
        String _name_22 = element.getName();
        String _lowerCase_9 = _name_22.toLowerCase();
        _builder.append((Object)_lowerCase_9, "\t\t\t\t");
        _builder.append((Object)" != null) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t\t");
        String _name_23 = element.getName();
        String _lowerCase_10 = _name_23.toLowerCase();
        _builder.append((Object)_lowerCase_10, "\t\t\t\t\t");
        _builder.append((Object)".disconnect();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"this.");
        String _name_24 = element.getName();
        String _lowerCase_11 = _name_24.toLowerCase();
        _builder.append((Object)_lowerCase_11, "\t\t\t");
        _builder.append((Object)"List.clear();");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// cancel a current worker handle if one is active");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (this.handle != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"this.handle.cancel(true);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// shutting down the worker and cleaning up the properties");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (this.worker != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"this.worker.shutdown();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// cancel bluetoothAdapter");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"this.bluetoothAdapter = null;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (this.enableScan) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"// re-create the worker");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"this.worker = Executors.newSingleThreadScheduledExecutor();");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"// Get Bluetooth adapter and ensure it is enabled");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"this.bluetoothAdapter = this.bluetoothService.getBluetoothAdapter(this.iname);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"if (this.bluetoothAdapter != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"logger.info(\"Bluetooth adapter interface => \" + this.iname);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"logger.info(\"Bluetooth adapter address => \" + this.bluetoothAdapter.getAddress());");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"logger.info(\"Bluetooth adapter le enabled => \" + this.bluetoothAdapter.isLeReady());");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"if (!this.bluetoothAdapter.isEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"logger.info(\"Enabling bluetooth adapter...\");");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"this.bluetoothAdapter.enable();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"logger.info(\"Bluetooth adapter address => \" + this.bluetoothAdapter.getAddress());");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"this.startTime = 0;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"this.connected = false;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"this.handle = this.worker.scheduleAtFixedRate(new Runnable() {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"public void run() {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t\t");
        _builder.append((Object)"checkScan();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"}, 0, 1, TimeUnit.SECONDS);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"logger.warn(\"No Bluetooth adapter found ...\");");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (Exception e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.error(\"Error starting component\", e);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new ComponentException(e);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"logger.debug(\"Updating Bluetooth Service... Done.\");");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// --------------------------------------------------------------------");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"//");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// Main task executed every second");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"//");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// --------------------------------------------------------------------");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"void checkScan() {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// Scan for bluetooth devices");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (this.bluetoothAdapter.isScanning()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.info(\"m_bluetoothAdapter.isScanning\");");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (System.currentTimeMillis() - this.startTime >= this.scantime * 1000) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"this.bluetoothAdapter.killLeScan();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (System.currentTimeMillis() - this.startTime >= this.period * 1000) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"logger.info(\"startLeScan\");");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"this.bluetoothAdapter.startLeScan(this);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"this.startTime = System.currentTimeMillis();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// --------------------------------------------------------------------");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"//");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// Private Methods");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"//");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// --------------------------------------------------------------------");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private boolean search");
        String _name_25 = element.getName();
        _builder.append((Object)_name_25, "\t");
        _builder.append((Object)"(String address) {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (");
        String _name_26 = element.getName();
        _builder.append((Object)_name_26, "\t\t");
        _builder.append((Object)"Device ");
        String _name_27 = element.getName();
        String _lowerCase_12 = _name_27.toLowerCase();
        _builder.append((Object)_lowerCase_12, "\t\t");
        _builder.append((Object)" : this.");
        String _name_28 = element.getName();
        String _lowerCase_13 = _name_28.toLowerCase();
        _builder.append((Object)_lowerCase_13, "\t\t");
        _builder.append((Object)"List) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (");
        String _name_29 = element.getName();
        String _lowerCase_14 = _name_29.toLowerCase();
        _builder.append((Object)_lowerCase_14, "\t\t\t");
        _builder.append((Object)".getBluetoothDevice().getAdress().equals(address)) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"return true;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return false;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private void readProperties(Map<String, Object> properties) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (properties != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (properties.get(this.PROPERTY_SCAN) != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"this.enableScan = (Boolean) properties.get(this.PROPERTY_SCAN);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (properties.get(this.PROPERTY_SCANTIME) != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"this.scantime = (Integer) properties.get(this.PROPERTY_SCANTIME);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (properties.get(this.PROPERTY_PERIOD) != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"this.period = (Integer) properties.get(this.PROPERTY_PERIOD);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        EList _properties_2 = element.getProperties();
        for (FunctionblockProperty fbProperty_2 : _properties_2) {
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"if (properties.get(this.PROPERTY_");
            String _name_30 = fbProperty_2.getName();
            String _upperCase_1 = _name_30.toUpperCase();
            _builder.append((Object)_upperCase_1, "\t\t\t");
            _builder.append((Object)") != null) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"this.enable");
            String _name_31 = fbProperty_2.getName();
            String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_31);
            _builder.append((Object)_firstUpper_2, "\t\t\t\t");
            _builder.append((Object)" = (Boolean) properties.get(this.PROPERTY_");
            String _name_32 = fbProperty_2.getName();
            String _upperCase_2 = _name_32.toUpperCase();
            _builder.append((Object)_upperCase_2, "\t\t\t\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (properties.get(this.PROPERTY_INAME) != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"this.iname = (String) properties.get(this.PROPERTY_INAME);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        Map _configurationProperties_7 = context.getConfigurationProperties();
        String _orDefault_7 = _configurationProperties_7.getOrDefault("boschcloud", "false");
        boolean _equalsIgnoreCase_7 = _orDefault_7.equalsIgnoreCase("true");
        if (_equalsIgnoreCase_7) {
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"dataService = new BoschDataService((String) properties.get(PROPERTY_BOSCHCLOUD_SOLUTIONID),");
            _builder.newLine();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"(String) properties.get(PROPERTY_BOSCHCLOUD_ENDPOINT));");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// --------------------------------------------------------------------");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"//");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// BluetoothLeScanListener APIs");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"//");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// --------------------------------------------------------------------");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void onScanFailed(int errorCode) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"logger.error(\"Error during scan\");");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void onScanResults(List<BluetoothDevice> scanResults) {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// Scan for ");
        String _name_33 = element.getName();
        _builder.append((Object)_name_33, "\t\t");
        _builder.append((Object)" devices");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (BluetoothDevice bluetoothDevice : scanResults) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.info(\"Address \" + bluetoothDevice.getAdress() + \" Name \" + bluetoothDevice.getName());");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (bluetoothDevice.getName().contains(\"");
        String _name_34 = element.getName();
        _builder.append((Object)_name_34, "\t\t\t");
        _builder.append((Object)"\")) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"logger.info(\"");
        String _name_35 = element.getName();
        _builder.append((Object)_name_35, "\t\t\t\t");
        _builder.append((Object)" \" + bluetoothDevice.getAdress() + \" found.\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"if (!search");
        String _name_36 = element.getName();
        _builder.append((Object)_name_36, "\t\t\t\t");
        _builder.append((Object)"(bluetoothDevice.getAdress())) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t\t");
        String _name_37 = element.getName();
        _builder.append((Object)_name_37, "\t\t\t\t\t");
        _builder.append((Object)"Device ");
        String _name_38 = element.getName();
        String _lowerCase_15 = _name_38.toLowerCase();
        _builder.append((Object)_lowerCase_15, "\t\t\t\t\t");
        _builder.append((Object)" = new ");
        String _name_39 = element.getName();
        _builder.append((Object)_name_39, "\t\t\t\t\t");
        _builder.append((Object)"Device(bluetoothDevice);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"this.");
        String _name_40 = element.getName();
        String _lowerCase_16 = _name_40.toLowerCase();
        _builder.append((Object)_lowerCase_16, "\t\t\t\t\t");
        _builder.append((Object)"List.add(");
        String _name_41 = element.getName();
        String _lowerCase_17 = _name_41.toLowerCase();
        _builder.append((Object)_lowerCase_17, "\t\t\t\t\t");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"logger.info(\"Found device = \" + bluetoothDevice.getAdress());");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"logger.debug(\"Found \" + this.");
        String _name_42 = element.getName();
        String _lowerCase_18 = _name_42.toLowerCase();
        _builder.append((Object)_lowerCase_18, "\t\t");
        _builder.append((Object)"List.size() + \" ");
        String _name_43 = element.getName();
        _builder.append((Object)_name_43, "\t\t");
        _builder.append((Object)" devices\");");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// connect to ");
        String _name_44 = element.getName();
        _builder.append((Object)_name_44, "\t\t");
        _builder.append((Object)" device");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (");
        String _name_45 = element.getName();
        _builder.append((Object)_name_45, "\t\t");
        _builder.append((Object)"Device my");
        String _name_46 = element.getName();
        _builder.append((Object)_name_46, "\t\t");
        _builder.append((Object)" : this.");
        String _name_47 = element.getName();
        String _lowerCase_19 = _name_47.toLowerCase();
        _builder.append((Object)_lowerCase_19, "\t\t");
        _builder.append((Object)"List) {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (!my");
        String _name_48 = element.getName();
        _builder.append((Object)_name_48, "\t\t\t");
        _builder.append((Object)".isConnected()) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"logger.info(\"Connecting to ");
        String _name_49 = element.getName();
        _builder.append((Object)_name_49, "\t\t\t\t");
        _builder.append((Object)"...\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"this.connected = my");
        String _name_50 = element.getName();
        _builder.append((Object)_name_50, "\t\t\t\t");
        _builder.append((Object)".connect(this.iname);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"if (this.connected) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"logger.info(\"Set security level to low.\");");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"my");
        String _name_51 = element.getName();
        _builder.append((Object)_name_51, "\t\t\t\t\t");
        _builder.append((Object)".setSecurityLevel(BluetoothGattSecurityLevel.LOW);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"logger.info(\"Security Level : \" + my");
        String _name_52 = element.getName();
        _builder.append((Object)_name_52, "\t\t\t\t\t");
        _builder.append((Object)".getSecurityLevel().toString());");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"logger.info(\"");
        String _name_53 = element.getName();
        _builder.append((Object)_name_53, "\t\t\t\t");
        _builder.append((Object)" device already connected!\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"this.connected = true;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (this.connected) {");
        _builder.newLine();
        EList _properties_3 = element.getProperties();
        for (FunctionblockProperty fbProperty_3 : _properties_3) {
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"if (this.enable");
            String _name_54 = fbProperty_3.getName();
            String _firstUpper_3 = StringExtensions.toFirstUpper((String)_name_54);
            _builder.append((Object)_firstUpper_3, "\t\t\t\t");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"my");
            String _name_55 = element.getName();
            _builder.append((Object)_name_55, "\t\t\t\t\t");
            _builder.append((Object)".enable");
            String _name_56 = fbProperty_3.getName();
            String _firstUpper_4 = StringExtensions.toFirstUpper((String)_name_56);
            _builder.append((Object)_firstUpper_4, "\t\t\t\t\t");
            _builder.append((Object)"();");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"try {");
            _builder.newLine();
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"Thread.sleep(1000);");
            _builder.newLine();
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"} catch (InterruptedException e) {");
            _builder.newLine();
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"e.printStackTrace();");
            _builder.newLine();
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"\t");
            FunctionblockModel _type = fbProperty_3.getType();
            String _name_57 = _type.getName();
            _builder.append((Object)_name_57, "\t\t\t\t\t");
            _builder.append((Object)" ");
            FunctionblockModel _type_1 = fbProperty_3.getType();
            String _name_58 = _type_1.getName();
            String _lowerCase_20 = _name_58.toLowerCase();
            _builder.append((Object)_lowerCase_20, "\t\t\t\t\t");
            _builder.append((Object)" = my");
            String _name_59 = element.getName();
            _builder.append((Object)_name_59, "\t\t\t\t\t");
            _builder.append((Object)".read");
            String _name_60 = fbProperty_3.getName();
            String _firstUpper_5 = StringExtensions.toFirstUpper((String)_name_60);
            _builder.append((Object)_firstUpper_5, "\t\t\t\t\t");
            _builder.append((Object)"();");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t\t");
            _builder.newLine();
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"// send ");
            FunctionblockModel _type_2 = fbProperty_3.getType();
            String _name_61 = _type_2.getName();
            String _lowerCase_21 = _name_61.toLowerCase();
            _builder.append((Object)_lowerCase_21, "\t\t\t\t\t");
            _builder.append((Object)" to iot cloud backend");
            _builder.newLineIfNotEmpty();
            Map _configurationProperties_8 = context.getConfigurationProperties();
            String _orDefault_8 = _configurationProperties_8.getOrDefault("boschcloud", "false");
            boolean _equalsIgnoreCase_8 = _orDefault_8.equalsIgnoreCase("false");
            if (_equalsIgnoreCase_8) {
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"KuraPayload payload = new KuraPayload();");
                _builder.newLine();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"payload.setTimestamp(new Date());");
                _builder.newLine();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"payload.addMetric(\"");
                FunctionblockModel _type_3 = fbProperty_3.getType();
                String _name_62 = _type_3.getName();
                String _lowerCase_22 = _name_62.toLowerCase();
                _builder.append((Object)_lowerCase_22, "\t\t\t\t\t");
                _builder.append((Object)"\", ");
                FunctionblockModel _type_4 = fbProperty_3.getType();
                String _name_63 = _type_4.getName();
                String _lowerCase_23 = _name_63.toLowerCase();
                _builder.append((Object)_lowerCase_23, "\t\t\t\t\t");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t\t\t\t");
            _builder.newLine();
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"try {");
            _builder.newLine();
            Map _configurationProperties_9 = context.getConfigurationProperties();
            String _orDefault_9 = _configurationProperties_9.getOrDefault("boschcloud", "false");
            boolean _equalsIgnoreCase_9 = _orDefault_9.equalsIgnoreCase("true");
            if (_equalsIgnoreCase_9) {
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"dataService.publish");
                String _name_64 = fbProperty_3.getName();
                String _firstUpper_6 = StringExtensions.toFirstUpper((String)_name_64);
                _builder.append((Object)_firstUpper_6, "\t\t\t\t\t\t");
                _builder.append((Object)"(my");
                String _name_65 = element.getName();
                _builder.append((Object)_name_65, "\t\t\t\t\t\t");
                _builder.append((Object)".getResourceId(), ");
                FunctionblockModel _type_5 = fbProperty_3.getType();
                String _name_66 = _type_5.getName();
                String _lowerCase_24 = _name_66.toLowerCase();
                _builder.append((Object)_lowerCase_24, "\t\t\t\t\t\t");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"if (!payload.metricNames().isEmpty()) {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"cloudClient.publish(topic + \"/\" + my");
                String _name_67 = element.getName();
                _builder.append((Object)_name_67, "\t\t\t\t\t\t\t");
                _builder.append((Object)".getResourceId(), payload, 0, false);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
            }
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"\t\t");
            _builder.newLine();
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"} catch (Exception e) {");
            _builder.newLine();
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"logger.error(\"Problem sending data to cloud\", e);");
            _builder.newLine();
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"logger.info(\"Cannot connect to ");
        String _name_68 = element.getName();
        _builder.append((Object)_name_68, "\t\t\t\t");
        _builder.append((Object)" device \" + my");
        String _name_69 = element.getName();
        _builder.append((Object)_name_69, "\t\t\t\t");
        _builder.append((Object)".getBluetoothDevice().getAdress() + \".\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        Map _configurationProperties_10 = context.getConfigurationProperties();
        String _orDefault_10 = _configurationProperties_10.getOrDefault("boschcloud", "false");
        boolean _equalsIgnoreCase_10 = _orDefault_10.equalsIgnoreCase("false");
        if (_equalsIgnoreCase_10) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public void setCloudService(CloudService cloudService) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"this.cloudService = cloudService;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public void unsetCloudService(CloudService cloudService) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"this.cloudService = null;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"// --------------------------------------------------------------------");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"//");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"// CloudClientListener APIs");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"//");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"// --------------------------------------------------------------------");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"@Override");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public void onControlMessageArrived(String deviceId, String appTopic, KuraPayload msg, int qos, boolean retain) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"@Override");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public void onMessageArrived(String deviceId, String appTopic, KuraPayload msg, int qos, boolean retain) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"@Override");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public void onConnectionLost() {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"@Override");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public void onConnectionEstablished() {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"@Override");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public void onMessageConfirmed(int messageId, String appTopic) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"@Override");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public void onMessagePublished(int messageId, String appTopic) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        return _builder.toString();
    }
}

