/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.examples.lwm2m.templates;

import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.codegen.api.ITemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.api.mapping.IMapped;
import org.eclipse.vorto.codegen.examples.lwm2m.templates.LWM2MConstants;
import org.eclipse.vorto.codegen.examples.lwm2m.utils.TypeMapper;
import org.eclipse.vorto.core.api.model.datatype.PrimitivePropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyType;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.Operation;
import org.eclipse.vorto.core.api.model.functionblock.Status;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class FunctionBlockLeshanTemplate
extends LWM2MConstants
implements ITemplate<FunctionblockModel> {
    public String getContent(FunctionblockModel model, InvocationContext context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package examples.leshan.client;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.leshan.client.resource.BaseInstanceEnabler;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.leshan.core.response.ExecuteResponse;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.leshan.core.response.ReadResponse;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _name = model.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" extends BaseInstanceEnabler {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        FunctionBlock _functionblock = model.getFunctionblock();
        Status _status = _functionblock.getStatus();
        EList _properties = _status.getProperties();
        for (Property statusProperty : _properties) {
            _builder.append((Object)"    ");
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)" ");
            _builder.append((Object)"* ");
            String _description = statusProperty.getDescription();
            _builder.append((Object)_description, "     ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"private ");
            PropertyType _type = statusProperty.getType();
            PrimitiveType _type_1 = ((PrimitivePropertyType)_type).getType();
            String _mapSimpleDatatype = TypeMapper.mapSimpleDatatype(_type_1);
            _builder.append((Object)_mapSimpleDatatype, "    ");
            _builder.append((Object)" ");
            String _name_1 = statusProperty.getName();
            _builder.append((Object)_name_1, "    ");
            _builder.append((Object)" = ");
            PropertyType _type_2 = statusProperty.getType();
            PrimitiveType _type_3 = ((PrimitivePropertyType)_type_2).getType();
            String _initialValue = TypeMapper.getInitialValue(_type_3);
            _builder.append((Object)_initialValue, "    ");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.newLine();
        }
        _builder.append((Object)"        ");
        _builder.newLine();
        FunctionBlock _functionblock_1 = model.getFunctionblock();
        Status _status_1 = _functionblock_1.getStatus();
        EList _properties_1 = _status_1.getProperties();
        for (Property statusProperty_1 : _properties_1) {
            _builder.append((Object)"    ");
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)" ");
            _builder.append((Object)"* Getter for ");
            String _name_2 = statusProperty_1.getName();
            _builder.append((Object)_name_2, "     ");
            _builder.append((Object)".");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"public ");
            PropertyType _type_4 = statusProperty_1.getType();
            PrimitiveType _type_5 = ((PrimitivePropertyType)_type_4).getType();
            String _mapSimpleDatatype_1 = TypeMapper.mapSimpleDatatype(_type_5);
            _builder.append((Object)_mapSimpleDatatype_1, "    ");
            _builder.append((Object)" get");
            String _name_3 = statusProperty_1.getName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_name_3);
            _builder.append((Object)_firstUpper, "    ");
            _builder.append((Object)"() {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"return this.");
            String _name_4 = statusProperty_1.getName();
            _builder.append((Object)_name_4, "        ");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.newLine();
        }
        _builder.newLine();
        FunctionBlock _functionblock_2 = model.getFunctionblock();
        Status _status_2 = _functionblock_2.getStatus();
        EList _properties_2 = _status_2.getProperties();
        for (Property statusProperty_2 : _properties_2) {
            _builder.append((Object)"    ");
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)" ");
            _builder.append((Object)"* Setter for ");
            String _name_5 = statusProperty_2.getName();
            _builder.append((Object)_name_5, "     ");
            _builder.append((Object)".");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"public void set");
            String _name_6 = statusProperty_2.getName();
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_6);
            _builder.append((Object)_firstUpper_1, "    ");
            _builder.append((Object)"(");
            PropertyType _type_6 = statusProperty_2.getType();
            PrimitiveType _type_7 = ((PrimitivePropertyType)_type_6).getType();
            String _mapSimpleDatatype_2 = TypeMapper.mapSimpleDatatype(_type_7);
            _builder.append((Object)_mapSimpleDatatype_2, "    ");
            _builder.append((Object)" ");
            String _name_7 = statusProperty_2.getName();
            _builder.append((Object)_name_7, "    ");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"this.");
            String _name_8 = statusProperty_2.getName();
            _builder.append((Object)_name_8, "        ");
            _builder.append((Object)" = ");
            String _name_9 = statusProperty_2.getName();
            _builder.append((Object)_name_9, "        ");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* Gets the current value of one of this LWM2M object instance's resources.");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public ReadResponse read(int resourceid) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"switch (resourceid) {");
        _builder.newLine();
        FunctionBlock _functionblock_3 = model.getFunctionblock();
        Status _status_3 = _functionblock_3.getStatus();
        EList _properties_3 = _status_3.getProperties();
        for (Property statusProperty_3 : _properties_3) {
            _builder.append((Object)"        ");
            IMapped mappedElement = context.getMappedElement(statusProperty_3, "Resources");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"        ");
            String obj_id = mappedElement.getAttributeValue("ID", null);
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"        ");
            _builder.append((Object)"case ");
            _builder.append((Object)obj_id, "        ");
            _builder.append((Object)":");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"        ");
            _builder.append((Object)"    ");
            _builder.append((Object)"return ReadResponse.success(resourceid, get");
            String _name_10 = statusProperty_3.getName();
            String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_10);
            _builder.append((Object)_firstUpper_2, "            ");
            _builder.append((Object)"());");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"        ");
        _builder.append((Object)"default:");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"return super.read(resourceid);");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* Executes the operation represented by one of this LWM2M object instance's resources.");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public ExecuteResponse execute(int resourceid, String params) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"switch (resourceid) {");
        _builder.newLine();
        FunctionBlock _functionblock_4 = model.getFunctionblock();
        EList _operations = _functionblock_4.getOperations();
        for (Operation operation : _operations) {
            _builder.append((Object)"        ");
            IMapped mappedElement_1 = context.getMappedElement(operation, "Resources");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"        ");
            String obj_id_1 = mappedElement_1.getAttributeValue("ID", null);
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"        ");
            _builder.append((Object)"case ");
            _builder.append((Object)obj_id_1, "        ");
            _builder.append((Object)":");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"        ");
            _builder.append((Object)"    ");
            _builder.append((Object)"// TODO: Implement execution code here");
            _builder.newLine();
            _builder.append((Object)"        ");
            _builder.append((Object)"    ");
            _builder.append((Object)"// ...");
            _builder.newLine();
            _builder.append((Object)"        ");
            _builder.append((Object)"    ");
            _builder.append((Object)"return ExecuteResponse.success();");
            _builder.newLine();
        }
        _builder.append((Object)"        ");
        _builder.append((Object)"default:");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"return ExecuteResponse.success();");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        return _builder.toString();
    }
}

