/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.examples.aws.templates.shadow;

import org.eclipse.vorto.codegen.api.GeneratorTaskFromFileTemplate;
import org.eclipse.vorto.codegen.api.ICodeGeneratorTask;
import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.IGeneratedWriter;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.api.mapping.IMapped;
import org.eclipse.vorto.codegen.examples.aws.templates.shadow.GetThingShadowLambdaTemplate;
import org.eclipse.vorto.codegen.examples.aws.templates.shadow.UpdateThingShadowLambdaTemplate;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.functionblock.Operation;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;

public class ThingShadowForOperationsTask
implements ICodeGeneratorTask<InformationModel> {
    private static final String STEREOTYPE_AWS_THINGSHADOW = "thingshadow";

    public void generate(InformationModel model, InvocationContext context, IGeneratedWriter writer) {
        for (FunctionblockProperty fbProperty : model.getProperties()) {
            for (Operation operation : fbProperty.getType().getFunctionblock().getOperations()) {
                GeneratorTaskFromFileTemplate generator;
                IMapped mappedElement = context.getMappedElement(operation, STEREOTYPE_AWS_THINGSHADOW);
                if (this.isUpdateableOperation((IMapped<Operation>)mappedElement)) {
                    generator = new GeneratorTaskFromFileTemplate((IFileTemplate)new UpdateThingShadowLambdaTemplate((IMapped<Operation>)mappedElement));
                    generator.generate((Object)operation, context, writer);
                    continue;
                }
                if (operation.getParams().isEmpty() || operation.getName().startsWith("get")) continue;
                generator = new GeneratorTaskFromFileTemplate((IFileTemplate)new UpdateThingShadowLambdaTemplate((IMapped<Operation>)mappedElement));
                generator.generate((Object)operation, context, writer);
            }
            if (fbProperty.getType().getFunctionblock().getStatus() == null) continue;
            for (Property statusProperty : fbProperty.getType().getFunctionblock().getStatus().getProperties()) {
                GeneratorTaskFromFileTemplate generator = new GeneratorTaskFromFileTemplate((IFileTemplate)new GetThingShadowLambdaTemplate());
                generator.generate((Object)statusProperty, context, writer);
            }
        }
    }

    private boolean isUpdateableOperation(IMapped<Operation> mapped) {
        return Boolean.getBoolean(mapped.getAttributeValue("updatable", "false"));
    }
}

