/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.core.ui.model;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.vorto.core.api.model.mapping.MappingModel;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.core.api.model.model.ModelType;
import org.eclipse.vorto.core.ui.model.AbstractModelElement;
import org.eclipse.vorto.core.ui.model.IModelProject;
import org.eclipse.vorto.core.ui.parser.IModelParser;
import org.eclipse.vorto.core.ui.parser.ParseModelResult;

public class MappingModelElement
extends AbstractModelElement {
    private IFile modelFile;
    private MappingModel model;
    private Collection<Resource.Diagnostic> diagnostics;
    private ModelType[] possibleReferenceTypes = new ModelType[]{ModelType.Datatype};
    private IModelParser modelParser = null;

    public MappingModelElement(IModelProject modelProject, IFile modelFile, IModelParser modelParser) {
        super(modelProject);
        this.modelFile = modelFile;
        this.modelParser = modelParser;
        ParseModelResult<MappingModel> parseResult = modelParser.parseModelWithError(modelFile, MappingModel.class);
        this.model = parseResult.getModel();
        this.diagnostics = parseResult.getErrors();
    }

    @Override
    public IFile getModelFile() {
        return this.modelFile;
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public Collection<Resource.Diagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    @Override
    protected String getImageURLAsString() {
        return "platform:/plugin/org.eclipse.vorto.core.ui/icons/mapping.png";
    }

    @Override
    protected String getErrorImageURLAsString() {
        return "platform:/plugin/org.eclipse.vorto.core.ui/icons/mapping.png";
    }

    @Override
    protected ModelType[] getPossibleReferenceTypes() {
        return this.possibleReferenceTypes;
    }

    @Override
    public void reload() {
        ParseModelResult<MappingModel> parseResult = this.modelParser.parseModelWithError(this.modelFile, MappingModel.class);
        this.model = parseResult.getModel();
        this.diagnostics = parseResult.getErrors();
    }
}

