/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.ui.tasks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.vorto.codegen.api.ICodeGeneratorTask;
import org.eclipse.vorto.codegen.ui.tasks.IEclipseProjectConfiguration;
import org.eclipse.vorto.core.ui.MessageDisplayFactory;

public class ClasspathConfiguration
implements IEclipseProjectConfiguration {
    private static final String JAVA_PATH = JavaRuntime.JRE_CONTAINER;
    private static final String PLUGIN_PATH = "org.eclipse.pde.core.requiredPlugins";
    private static final String DEFAULT_OUTPUT_LOCATION = "target";
    public static final IClasspathEntry PLUGIN = ClasspathConfiguration.createClasspathEntry("org.eclipse.pde.core.requiredPlugins");
    public static final IClasspathEntry JAVA_JRE = ClasspathConfiguration.getVmClasspathEntry();
    private String[] sourceFolders = new String[0];
    private String outputLocation = "target";
    private List<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();

    private static IClasspathEntry createClasspathEntry(String path) {
        return JavaCore.newContainerEntry((IPath)new Path(path));
    }

    public IEclipseProjectConfiguration addEntry(IClasspathEntry entry) {
        this.entries.add(entry);
        return this;
    }

    public void setSourceFolders(String[] sourceFolders) {
        this.sourceFolders = sourceFolders;
    }

    public void setOutputLocation(String outputLocation) {
        this.outputLocation = outputLocation;
    }

    @Override
    public IEclipseProjectConfiguration configure(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            javaProject.setRawClasspath(this.getClasspathEntries(javaProject), (IProgressMonitor)new NullProgressMonitor());
            javaProject.setOutputLocation(project.getFolder(this.outputLocation).getFullPath(), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException e1) {
            MessageDisplayFactory.getMessageDisplay().displayError(e1.getMessage());
        }
        return this;
    }

    private IClasspathEntry[] getClasspathEntries(IJavaProject project) {
        ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
        int i = 0;
        while (i < this.sourceFolders.length) {
            newEntries.add(JavaCore.newSourceEntry((IPath)project.getProject().getFolder(this.sourceFolders[i]).getFullPath()));
            ++i;
        }
        newEntries.addAll(this.entries);
        return newEntries.toArray(new IClasspathEntry[newEntries.size()]);
    }

    private static IClasspathEntry getVmClasspathEntry() {
        Path containerPath = new Path(JAVA_PATH);
        IVMInstall vmInstall = JavaRuntime.getDefaultVMInstall();
        IPath vmPath = containerPath.append(vmInstall.getVMInstallType().getId()).append(vmInstall.getName());
        return JavaCore.newContainerEntry((IPath)vmPath);
    }

    @Override
    public <Context> List<ICodeGeneratorTask<Context>> getGeneratorTasks() {
        return Collections.emptyList();
    }
}

