/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.perspective.dnd.dropaction;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.vorto.core.api.model.model.ModelId;
import org.eclipse.vorto.core.api.repository.IModelRepository;
import org.eclipse.vorto.core.api.repository.ModelRepositoryFactory;
import org.eclipse.vorto.core.api.repository.ModelResource;
import org.eclipse.vorto.core.api.repository.RepositoryException;
import org.eclipse.vorto.core.ui.MessageDisplayFactory;
import org.eclipse.vorto.core.ui.exception.ExceptionHandlerFactory;
import org.eclipse.vorto.core.ui.model.IModelElement;
import org.eclipse.vorto.core.ui.model.IModelProject;
import org.eclipse.vorto.perspective.dnd.IDropAction;

public class AddSharedReferenceDropAction
implements IDropAction<IModelElement, ModelResource> {
    private Class<?> droppedObjectClass = null;
    private IModelRepository modelRepo = ModelRepositoryFactory.getModelRepository();

    public AddSharedReferenceDropAction(Class<?> droppedObjectClass) {
        this.droppedObjectClass = droppedObjectClass;
    }

    @Override
    public IModelElement performDrop(IModelElement receivingModelElement, ModelResource modelElementToBeDropped) {
        if (this.droppedObjectClass.isInstance(modelElementToBeDropped) && !receivingModelElement.equals(modelElementToBeDropped)) {
            ModelResource modelToAddAsReference = this.downloadAndSaveModel(receivingModelElement.getProject(), modelElementToBeDropped.getId());
            receivingModelElement.addModelReference(modelToAddAsReference.getId());
            receivingModelElement.save();
            return receivingModelElement;
        }
        return null;
    }

    private ModelResource downloadAndSaveModel(IModelProject project, ModelId modelId) {
        ModelResource model = null;
        try {
            model = this.modelRepo.getModel(modelId);
            if (model != null) {
                for (ModelId reference : model.getReferences()) {
                    this.downloadAndSaveModel(project, reference);
                }
                MessageDisplayFactory.getMessageDisplay().display("Downloading " + modelId.toString());
                byte[] modelContent = this.modelRepo.downloadContent(model.getId());
                project.addModelElement(model.getId(), (InputStream)new ByteArrayInputStream(modelContent));
            } else {
                MessageDisplayFactory.getMessageDisplay().displayError("Model " + modelId.toString() + " not found in repository.");
            }
        }
        catch (RepositoryException e) {
            ExceptionHandlerFactory.getHandler().handle((Throwable)e);
        }
        return model;
    }
}

