/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.perspective.view;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class MultipleSelectionProvider
implements ISelectionProvider {
    private ISelectionProvider provider;
    private List<ISelectionChangedListener> selectionListeners;
    private ISelection sel = StructuredSelection.EMPTY;

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.selectionListeners == null) {
            this.selectionListeners = new ArrayList<ISelectionChangedListener>(1);
        }
        this.selectionListeners.add(listener);
        if (this.provider != null) {
            this.provider.addSelectionChangedListener(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.selectionListeners != null) {
            this.selectionListeners.remove(listener);
            if (this.provider != null) {
                this.provider.removeSelectionChangedListener(listener);
            }
        }
    }

    public ISelection getSelection() {
        return this.provider != null ? this.provider.getSelection() : this.sel;
    }

    public void setSelection(ISelection selection) {
        if (this.provider != null) {
            this.provider.setSelection(selection);
        } else {
            this.sel = selection;
            if (this.selectionListeners != null) {
                SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
                Iterator<ISelectionChangedListener> it = this.selectionListeners.iterator();
                while (it.hasNext()) {
                    it.next().selectionChanged(event);
                }
            }
        }
    }

    public void setSelectionProvider(ISelectionProvider provider) {
        if (this.provider != provider) {
            ISelection currentSelection = null;
            if (this.selectionListeners != null) {
                if (this.provider != null) {
                    for (ISelectionChangedListener listener : this.selectionListeners) {
                        this.provider.removeSelectionChangedListener(listener);
                    }
                }
                if (provider != null) {
                    for (ISelectionChangedListener listener : this.selectionListeners) {
                        provider.addSelectionChangedListener(listener);
                    }
                    currentSelection = provider.getSelection();
                } else {
                    currentSelection = this.sel;
                }
            }
            this.provider = provider;
            if (currentSelection != null) {
                this.setSelection(currentSelection);
            }
        }
    }

    public ISelectionProvider getSelectionProvider() {
        return this.provider;
    }
}

