/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.perspective.view;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.vorto.core.api.model.model.ModelType;
import org.eclipse.vorto.core.ui.model.IModelProject;
import org.eclipse.vorto.core.ui.model.ModelParserFactory;
import org.eclipse.vorto.core.ui.model.VortoModelProject;
import org.eclipse.vorto.perspective.listener.ErrorDiagnosticListener;
import org.eclipse.vorto.perspective.listener.RemoveModelListener;
import org.eclipse.vorto.perspective.listener.RemoveModelProjectListener;
import org.eclipse.vorto.perspective.util.ImageUtil;
import org.eclipse.vorto.perspective.util.NullModelProject;
import org.eclipse.vorto.perspective.view.DatatypeTreeViewer;
import org.eclipse.vorto.perspective.view.FunctionblockTreeViewer;
import org.eclipse.vorto.perspective.view.ILocalModelWorkspace;
import org.eclipse.vorto.perspective.view.InfomodelTreeViewer;
import org.eclipse.vorto.perspective.view.MultipleSelectionProvider;
import org.eclipse.vorto.wizard.vorto.VortoProjectWizard;
import org.eclipse.vorto.wizard.vorto.VortoProjectWizardPage;

public class ProjectSelectionViewPart
extends ViewPart
implements ILocalModelWorkspace,
ILocalModelWorkspace.IModelProjectBrowser {
    public static final String PROJECT_SELECT_VIEW_ID = "org.eclipse.vorto.perspective.view.ProjectSelectionViewPart";
    protected ComboViewer projectSelectionViewer;
    protected MultipleSelectionProvider multipleSelectionProvider;
    private IModelProject selectedProject = null;
    protected DatatypeTreeViewer datatypeTreeViewer;
    protected FunctionblockTreeViewer functionBlockTreeViewer;
    protected InfomodelTreeViewer infoModelTreeViewer;
    private IResourceChangeListener removeModelListener = null;
    private IResourceChangeListener removeProjectListener = null;
    private IResourceChangeListener errorDiagnosticsListener = null;

    public void createPartControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        this.projectSelectionViewer = this.createProjectSelectionViewer(container, "Select Vorto Project");
        this.projectSelectionViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IModelProject) {
                    IModelProject project = (IModelProject)element;
                    return project.getProject().getName();
                }
                return super.getText(element);
            }
        });
        this.projectSelectionViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Collection<IModelProject> modelProjects = this.getModelProjects();
        this.projectSelectionViewer.setInput(modelProjects);
        this.projectSelectionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection iSelection = (IStructuredSelection)event.getSelection();
                    IModelProject project = (IModelProject)iSelection.getFirstElement();
                    ProjectSelectionViewPart.this.selectedProject = project;
                    ProjectSelectionViewPart.this.populate(ProjectSelectionViewPart.this.selectedProject);
                }
            }
        });
        this.hookListeners();
        Composite modelPanel = this.createViewerComposite(container, (Control)this.projectSelectionViewer.getCombo());
        this.datatypeTreeViewer = new DatatypeTreeViewer(modelPanel, this);
        this.functionBlockTreeViewer = new FunctionblockTreeViewer(modelPanel, this);
        this.infoModelTreeViewer = new InfomodelTreeViewer(modelPanel, this);
        this.multipleSelectionProvider = new MultipleSelectionProvider();
        this.getSite().setSelectionProvider((ISelectionProvider)this.multipleSelectionProvider);
        if (!modelProjects.isEmpty()) {
            this.setSelectedProject(modelProjects.iterator().next());
        }
    }

    protected void hookListeners() {
        this.addWorkspaceChangeEventListenr();
    }

    protected void addWorkspaceChangeEventListenr() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.removeProjectListener = new RemoveModelProjectListener(this);
        this.errorDiagnosticsListener = new ErrorDiagnosticListener(this.newRefreshCurrentProjectRunnable());
        this.removeModelListener = new RemoveModelListener(this.newRefreshCurrentProjectRunnable());
        workspace.addResourceChangeListener(this.removeProjectListener, 4);
        workspace.addResourceChangeListener(this.errorDiagnosticsListener, 1);
        workspace.addResourceChangeListener(this.removeModelListener, 1);
    }

    private Runnable newRefreshCurrentProjectRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                ProjectSelectionViewPart.this.setSelectedProject(ProjectSelectionViewPart.this.selectedProject);
            }
        };
    }

    private void setSelectedProject(IModelProject project) {
        this.projectSelectionViewer.setSelection((ISelection)new StructuredSelection((Object)project), true);
    }

    public void populate(IModelProject modelProject) {
        this.datatypeTreeViewer.populate(modelProject.getModelElementsByType(ModelType.Datatype));
        this.functionBlockTreeViewer.populate(modelProject.getModelElementsByType(ModelType.Functionblock));
        this.infoModelTreeViewer.populate(modelProject.getModelElementsByType(ModelType.InformationModel));
    }

    @Override
    public void refresh() {
        for (IModelProject project : this.getModelProjects()) {
            this.populate(project);
        }
    }

    @Override
    public void refreshCurrent() {
        this.setSelectedProject(this.selectedProject);
    }

    private ComboViewer createProjectSelectionViewer(final Composite container, String labelStr) {
        Button newProjectButton = new Button(container, 0);
        newProjectButton.setImage(ImageUtil.getImage("add_obj.gif"));
        newProjectButton.setToolTipText("Add a new Vorto Project");
        newProjectButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 13: {
                        WizardDialog wizardDialog = new WizardDialog(container.getShell(), (IWizard)new VortoProjectWizard());
                        if (wizardDialog.open() != 0) break;
                        ProjectSelectionViewPart.this.projectSelectionViewer.setInput(ProjectSelectionViewPart.this.getModelProjects());
                        VortoProjectWizardPage page = (VortoProjectWizardPage)wizardDialog.getCurrentPage();
                        IModelProject project = ProjectSelectionViewPart.this.getModelProjectFromName(page.getProjName());
                        ProjectSelectionViewPart.this.selectedProject = project;
                        ProjectSelectionViewPart.this.projectSelectionViewer.setSelection((ISelection)new StructuredSelection((Object)project), true);
                    }
                }
            }
        });
        FormData buttonFormdata = new FormData();
        buttonFormdata.top = new FormAttachment(0, 0);
        buttonFormdata.right = new FormAttachment(100, 0);
        newProjectButton.setLayoutData((Object)buttonFormdata);
        Button deleteButton = new Button(container, 0);
        deleteButton.setImage(ImageUtil.getImage("delete.gif"));
        deleteButton.setToolTipText("Delete the selected Vorto Project");
        deleteButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 13: {
                        if (ProjectSelectionViewPart.this.selectedProject == null || Display.getDefault().isDisposed()) break;
                        Display.getDefault().syncExec(ProjectSelectionViewPart.this.newDeleteProjectRunnable(ProjectSelectionViewPart.this.selectedProject));
                    }
                }
            }
        });
        FormData deleteButtonFormdata = new FormData();
        deleteButtonFormdata.top = new FormAttachment(0, 0);
        deleteButtonFormdata.right = new FormAttachment((Control)newProjectButton, -10);
        deleteButton.setLayoutData((Object)deleteButtonFormdata);
        ComboViewer comboViewer = new ComboViewer(container, 8);
        Combo combo = comboViewer.getCombo();
        FormData viewerFormData = new FormData();
        viewerFormData.top = new FormAttachment((Control)newProjectButton, 10);
        viewerFormData.left = new FormAttachment(0, 0);
        viewerFormData.right = new FormAttachment(100, 0);
        combo.setLayoutData((Object)viewerFormData);
        Label label = new Label(container, 0);
        label.setText(labelStr);
        FormData labelFormData = new FormData();
        labelFormData.bottom = new FormAttachment((Control)comboViewer.getCombo(), -10);
        labelFormData.left = new FormAttachment(0, 0);
        label.setLayoutData((Object)labelFormData);
        return comboViewer;
    }

    private Runnable newDeleteProjectRunnable(final IModelProject modelProject) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)ProjectSelectionViewPart.this.getShell(), (String)"Delete Project Confirmation", (String)("Are you sure you want to delete the Vorto project '" + modelProject.getProject().getName() + "' from the Workspace?"), (String)"Delete project contents on disk (Cannot be undone)", (boolean)false, null, null);
                    if (dialog.getReturnCode() == 0) {
                        boolean deleteContents = dialog.getToggleState();
                        WorkspaceJob job = ProjectSelectionViewPart.this.newDeleteProjectJob(modelProject, deleteContents);
                        job.setRule((ISchedulingRule)modelProject.getProject());
                        job.schedule();
                    }
                }
                catch (Exception ex1) {
                    throw new RuntimeException(ex1);
                }
            }
        };
    }

    private WorkspaceJob newDeleteProjectJob(final IModelProject modelProject, final boolean deleteContents) {
        return new WorkspaceJob("Delete Vorto Project"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                modelProject.getProject().delete(deleteContents, true, monitor);
                return Status.OK_STATUS;
            }
        };
    }

    private IModelProject getModelProjectFromName(String projectName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        return new VortoModelProject(project, ModelParserFactory.getInstance().getModelParser());
    }

    private Composite createViewerComposite(Composite container, Control previousControl) {
        Composite viewerComposite = new Composite(container, 0);
        FormData formData = new FormData();
        formData.top = new FormAttachment(previousControl, 10);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        viewerComposite.setLayoutData((Object)formData);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 512;
        fillLayout.spacing = 5;
        viewerComposite.setLayout((Layout)fillLayout);
        return viewerComposite;
    }

    public void setFocus() {
    }

    @Override
    public void removeProject(IModelProject modelProject) {
        Collection<IModelProject> projects = this.getModelProjects();
        projects.remove(modelProject);
        if (!Display.getDefault().isDisposed()) {
            Display.getDefault().syncExec(this.newUpdateControlsAfterRemoveRunnable(this.projectSelectionViewer, projects));
        }
    }

    private Runnable newUpdateControlsAfterRemoveRunnable(final ComboViewer projectSelectionViewer, final Collection<IModelProject> projects) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    projectSelectionViewer.setInput((Object)projects);
                    if (!projects.isEmpty()) {
                        ProjectSelectionViewPart.this.setSelectedProject((IModelProject)projects.iterator().next());
                    } else {
                        ProjectSelectionViewPart.this.populate(new NullModelProject());
                        ProjectSelectionViewPart.this.selectedProject = null;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public void dispose() {
        super.dispose();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener(this.removeProjectListener);
        workspace.removeResourceChangeListener(this.errorDiagnosticsListener);
        workspace.removeResourceChangeListener(this.removeModelListener);
    }

    @Override
    public IModelProject getSelectedProject() {
        return this.selectedProject;
    }

    @Override
    public Collection<IModelProject> getModelProjects() {
        ArrayList<IModelProject> vortoModelProjects = new ArrayList<IModelProject>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject projectInWorkspace = iProjectArray[n2];
            if (projectInWorkspace.isOpen() && VortoModelProject.isVortoModelProject((IProject)projectInWorkspace)) {
                vortoModelProjects.add((IModelProject)new VortoModelProject(projectInWorkspace, ModelParserFactory.getInstance().getModelParser()));
            }
            ++n2;
        }
        return vortoModelProjects;
    }

    @Override
    public ILocalModelWorkspace.IModelProjectBrowser getProjectBrowser() {
        return this;
    }

    @Override
    public Shell getShell() {
        return this.projectSelectionViewer.getControl().getShell();
    }

    @Override
    public void setFocus(TreeViewer treeViewer) {
        this.multipleSelectionProvider.setSelectionProvider((ISelectionProvider)treeViewer);
    }
}

