/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.nosql.eclipselink.core.context.persistence;

import java.io.Serializable;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.CacheType;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.Caching;

public class CachingEntity
extends AbstractModel
implements Cloneable,
Serializable {
    private String name;
    private Caching parent;
    public static final String CACHE_TYPE_PROPERTY = "cacheType";
    public static final String CACHE_SIZE_PROPERTY = "cacheSize";
    public static final String SHARED_CACHE_PROPERTY = "sharedCache";
    private CacheType cacheType;
    private Integer cacheSize;
    private Boolean cacheIsShared;
    private static final long serialVersionUID = 1L;
    public static final Transformer<CachingEntity, String> NAME_TRANSFORMER = new NameTransformer();

    public CachingEntity(Caching parent, String name) {
        this(parent);
        this.initialize(name);
    }

    private CachingEntity(Caching parent) {
        this.parent = parent;
    }

    private void initialize(String name) {
        if (StringTools.isBlank((String)name)) {
            throw new IllegalArgumentException();
        }
        this.name = name;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CachingEntity)) {
            return false;
        }
        CachingEntity other = (CachingEntity)o;
        return (this.cacheType == null ? other.cacheType == null : this.cacheType.equals((Object)other.cacheType)) && (this.cacheIsShared == null ? other.cacheIsShared == null : this.cacheIsShared.equals(other.cacheIsShared)) && (this.cacheSize == null ? other.cacheSize == null : this.cacheSize.equals(other.cacheSize));
    }

    public int hashCode() {
        return this.cacheType == null ? 0 : this.cacheType.hashCode();
    }

    public CachingEntity clone() {
        try {
            return (CachingEntity)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean isEmpty() {
        return this.cacheType == null && this.cacheSize == null && this.cacheIsShared == null;
    }

    public boolean entityNameIsValid() {
        return !StringTools.isBlank((String)this.name);
    }

    public Caching getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public CacheType getCacheType() {
        return this.cacheType;
    }

    public void setCacheType(CacheType cacheType) {
        CacheType old = this.cacheType;
        this.cacheType = cacheType;
        this.firePropertyChanged(CACHE_TYPE_PROPERTY, (Object)old, (Object)cacheType);
    }

    public Integer getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(Integer cacheSize) {
        Integer old = this.cacheSize;
        this.cacheSize = cacheSize;
        this.firePropertyChanged(CACHE_SIZE_PROPERTY, old, cacheSize);
    }

    public Boolean cacheIsShared() {
        return this.cacheIsShared;
    }

    public void setSharedCache(Boolean isShared) {
        Boolean old = this.cacheIsShared;
        this.cacheIsShared = isShared;
        this.firePropertyChanged(SHARED_CACHE_PROPERTY, old, isShared);
    }

    public void toString(StringBuilder sb) {
        sb.append("name: ");
        sb.append(this.name);
        sb.append(", cacheType: ");
        sb.append((Object)this.cacheType);
        sb.append(", cacheSize: ");
        sb.append(this.cacheSize);
        sb.append(", cacheIsShared: ");
        sb.append(this.cacheIsShared);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NameTransformer
    extends TransformerAdapter<CachingEntity, String> {
        public String transform(CachingEntity entity) {
            return entity.getName();
        }
    }
}

