/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.nosql.eclipselink.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.common.ui.internal.util.SWTUtil;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.ui.JptJpaUiImages;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.entity.data.model.DynamicEntityDataModelProvider;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.plugin.JptNoSQLEclipseLinkUiPlugin;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.wizards.DynamicEntityClassWizardPage;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.wizards.DynamicEntityFieldsWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizard;

public class EclipseLinkDynamicEntityWizard
extends DataModelWizard
implements INewWizard {
    private String initialProjectName;
    private DynamicEntityClassWizardPage page1;
    private DynamicEntityFieldsWizardPage page2;

    public EclipseLinkDynamicEntityWizard(IDataModel model) {
        super(model);
        this.setWindowTitle(EclipseLinkUiMessages.EclipseLinkDynamicEntityWizard_title);
        this.setDefaultPageImageDescriptor(JptJpaUiImages.ENTITY_BANNER);
    }

    public EclipseLinkDynamicEntityWizard() {
        this(null);
    }

    protected void doAddPages() {
        this.page1 = new DynamicEntityClassWizardPage(this.getDataModel(), "pageOne");
        this.page1.setProjectName(this.initialProjectName);
        this.addPage((IWizardPage)this.page1);
        this.page2 = new DynamicEntityFieldsWizardPage(this.getDataModel(), "pageTwo");
        this.addPage((IWizardPage)this.page2);
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() == this.page1 ? false : this.page2.getErrorMessage() == null;
    }

    protected IDataModelProvider getDefaultProvider() {
        return new DynamicEntityDataModelProvider();
    }

    protected void postPerformFinish() throws InvocationTargetException {
        try {
            IProject project = (IProject)this.getDataModel().getProperty("NewJavaClassDataModel.PROJECT");
            JpaProject jpaProject = (JpaProject)project.getAdapter(JpaProject.class);
            if (jpaProject == null) {
                return;
            }
            String xmlRuntimePath = this.getDataModel().getStringProperty("IEntityDataModelProperties.XML_NAME").trim();
            JptXmlResource xmlResource = jpaProject.getMappingFileXmlResource((IPath)new Path(xmlRuntimePath));
            this.openEditor(xmlResource);
        }
        catch (Exception cantOpen) {
            JptNoSQLEclipseLinkUiPlugin.instance().logError(cantOpen);
        }
    }

    protected void openEditor(final JptXmlResource xmlResource) {
        SWTUtil.asyncExec((Runnable)new Runnable(){

            public void run() {
                IFile file = xmlResource.getFile();
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void init(IWorkbench workbench, IStructuredSelection iSelection) {
        this.initialProjectName = this.getProjectName(iSelection);
        this.getDataModel();
    }

    protected IProject extractProject(IStructuredSelection iSelection) {
        Object selectedObj = iSelection.getFirstElement();
        if (selectedObj == null) {
            return null;
        }
        IResource resource = (IResource)PlatformTools.getAdapter((Object)selectedObj, IResource.class);
        if (resource != null) {
            return resource.getProject();
        }
        IJavaElement javaElement = (IJavaElement)PlatformTools.getAdapter((Object)selectedObj, IJavaElement.class);
        if (javaElement != null) {
            return javaElement.getJavaProject().getProject();
        }
        JpaContextNode node = (JpaContextNode)PlatformTools.getAdapter((Object)selectedObj, JpaContextNode.class);
        if (node != null) {
            return node.getJpaProject().getProject();
        }
        return null;
    }

    protected String getProjectName(IStructuredSelection iSelection) {
        IProject iProject = this.extractProject(iSelection);
        return iProject == null ? EclipseLinkUiMessages.DynamicEntityClassWizardPage_emptyString : iProject.getName();
    }
}

