/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.db;

import java.text.Collator;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.dali.db.Column;
import org.eclipse.dali.db.NullDatabase;
import org.eclipse.dali.db.RDBDatabaseWrapper;
import org.eclipse.dali.db.Schema;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.internal.utility.StringTools;
import org.eclipse.dali.internal.utility.iterators.TransformationIterator;

public abstract class Database
implements Comparable {
    private boolean caseSensitive = false;

    static Database createDatabase(org.eclipse.wst.rdb.internal.models.sql.schema.Database rdbDatabase) {
        return rdbDatabase == null ? NullDatabase.instance() : new RDBDatabaseWrapper(rdbDatabase);
    }

    Database() {
    }

    public abstract String getName();

    public abstract boolean isConnected();

    Table table(org.eclipse.wst.rdb.internal.models.sql.tables.Table rdbTable) {
        return this.schema(rdbTable.getSchema()).table(rdbTable);
    }

    Column column(org.eclipse.wst.rdb.internal.models.sql.tables.Column rdbColumn) {
        return this.table(rdbColumn.getTable()).column(rdbColumn);
    }

    public int compareTo(Object o) {
        return Collator.getInstance().compare(this.getName(), ((Database)o).getName());
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    abstract Set getSchemata();

    public Iterator schemata() {
        return this.getSchemata().iterator();
    }

    public int schemataSize() {
        return this.getSchemata().size();
    }

    public boolean schemataContains(Column column) {
        return this.getSchemata().contains(column);
    }

    public Iterator schemaNames() {
        return new TransformationIterator(this.schemata()){

            protected Object transform(Object next) {
                return ((Schema)next).getName();
            }
        };
    }

    public boolean containsSchemaNamed(String name) {
        return this.schemaNamed(name) != null;
    }

    public Schema schemaNamed(String name) {
        return this.isCaseSensitive() ? this.schemaNamedInternal(name) : this.schemaNamedIgnoreCase(name);
    }

    private Schema schemaNamedInternal(String name) {
        Iterator stream = this.schemata();
        while (stream.hasNext()) {
            Schema schema = (Schema)stream.next();
            if (!schema.getName().equals(name)) continue;
            return schema;
        }
        return null;
    }

    private Schema schemaNamedIgnoreCase(String name) {
        Iterator stream = this.schemata();
        while (stream.hasNext()) {
            Schema schema = (Schema)stream.next();
            if (!StringTools.stringsAreEqualIgnoreCase((String)schema.getName(), (String)name)) continue;
            return schema;
        }
        return null;
    }

    Schema schema(org.eclipse.wst.rdb.internal.models.sql.schema.Schema rdbSchema) {
        Iterator stream = this.schemata();
        while (stream.hasNext()) {
            Schema schema = (Schema)stream.next();
            if (!schema.wraps(rdbSchema)) continue;
            return schema;
        }
        throw new IllegalArgumentException("invalid rdb schema: " + rdbSchema);
    }
}

