/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.sql.SQLException;
import org.eclipse.dali.db.Connection;
import org.eclipse.dali.db.ConnectionListener;
import org.eclipse.dali.db.Database;
import org.eclipse.dali.db.Schema;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.orm.AttributeOverride;
import org.eclipse.dali.orm.EmbeddedMapping;
import org.eclipse.dali.orm.provider.AttributeOverrideItemProvider;
import org.eclipse.dali.orm.provider.EmbeddedMappingItemProvider;
import org.eclipse.dali.orm.provider.OrmItemProviderAdapterFactory;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.views.ColumnComposite;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class EmbeddedAttributeOverridesComposite
extends Composite
implements IPersistenceComposite {
    private ListViewer listViewer;
    private EmbeddedMapping embedded;
    private INotifyChangedListener embeddedListener;
    private AttributeOverride attributeOverride;
    private INotifyChangedListener attributeOverrideItemListener;
    private ConnectionListener connectionListener;
    private EmbeddedMappingItemProvider embeddedItemProvider;
    private AttributeOverrideItemProvider attributeOverrideItemProvider;
    protected ColumnComposite columnComposite;
    private EditingDomain editingDomain;
    private OrmItemProviderAdapterFactory adapterFactory;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public EmbeddedAttributeOverridesComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.adapterFactory = adapterFactory;
        this.embeddedItemProvider = (EmbeddedMappingItemProvider)adapterFactory.createEmbeddedMappingAdapter();
        this.attributeOverrideItemProvider = (AttributeOverrideItemProvider)adapterFactory.createAttributeOverrideAdapter();
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        Group attributeOverridesGroup = new Group((Composite)this, 16);
        attributeOverridesGroup.setText(DaliUiMessages.EmbeddedAttributeOverridesComposite_attributeOverrides);
        attributeOverridesGroup.setLayout((Layout)new GridLayout(2, true));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        attributeOverridesGroup.setLayoutData((Object)gridData);
        this.listViewer = this.buildAttributeOverridesListViewer((Composite)attributeOverridesGroup);
        gridData = new GridData();
        gridData.verticalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.listViewer.getList().setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.listViewer.getList(), "org.eclipse.dali.ui.mapping_embeddedAttributeOverrides");
        this.columnComposite = new ColumnComposite((Composite)attributeOverridesGroup, this.editingDomain, this.adapterFactory, "org.eclipse.dali.ui.mapping_embeddedAttributeOverridesColumn");
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.columnComposite.setLayoutData(gridData);
    }

    private ListViewer buildAttributeOverridesListViewer(Composite parent) {
        ListViewer listViewer = new ListViewer(parent, 2052);
        listViewer.setLabelProvider((IBaseLabelProvider)this.buildAttributeOverridesLabelProvider());
        listViewer.setContentProvider(this.buildAttributeOverridesContentProvider());
        listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (((StructuredSelection)event.getSelection()).isEmpty()) {
                    EmbeddedAttributeOverridesComposite.this.columnComposite.populate(null);
                    if (EmbeddedAttributeOverridesComposite.this.attributeOverride != null) {
                        EmbeddedAttributeOverridesComposite.this.attributeOverride.eAdapters().remove((Object)EmbeddedAttributeOverridesComposite.this.attributeOverrideItemProvider);
                        EmbeddedAttributeOverridesComposite.this.attributeOverride = null;
                    }
                } else {
                    EmbeddedAttributeOverridesComposite.this.attributeOverride = (AttributeOverride)((StructuredSelection)event.getSelection()).getFirstElement();
                    EmbeddedAttributeOverridesComposite.this.columnComposite.populate((EObject)EmbeddedAttributeOverridesComposite.this.attributeOverride.getColumn());
                    EmbeddedAttributeOverridesComposite.this.attributeOverride.eAdapters().add((Object)EmbeddedAttributeOverridesComposite.this.attributeOverrideItemProvider);
                }
            }
        });
        return listViewer;
    }

    private ILabelProvider buildAttributeOverridesLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                return ((AttributeOverride)element).getName();
            }
        };
    }

    private IContentProvider buildAttributeOverridesContentProvider() {
        return new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((EmbeddedMapping)inputElement).getAttributeOverrides().toArray();
            }
        };
    }

    public void populate(EObject embedded) {
        if (this.embedded != null) {
            this.embeddedItemProvider.removeListener(this.getEmbeddedListener());
            this.embedded.eAdapters().remove((Object)this.embeddedItemProvider);
            this.attributeOverrideItemProvider.removeListener(this.getAttributeOverrideItemListener());
        }
        this.embedded = (EmbeddedMapping)embedded;
        if (this.embedded == null) {
            this.columnComposite.populate(null);
            return;
        }
        this.embeddedItemProvider.addListener(this.getEmbeddedListener());
        this.attributeOverrideItemProvider.addListener(this.getAttributeOverrideItemListener());
        this.embedded.eAdapters().add((Object)this.embeddedItemProvider);
        if (this.listViewer.getInput() != embedded) {
            this.listViewer.setInput((Object)embedded);
        }
        if (!this.embedded.getAttributeOverrides().isEmpty()) {
            if (this.listViewer.getSelection().isEmpty()) {
                this.listViewer.setSelection((ISelection)new StructuredSelection(this.embedded.getAttributeOverrides().get(0)));
            } else {
                this.columnComposite.populate((EObject)((AttributeOverride)((StructuredSelection)this.listViewer.getSelection()).getFirstElement()).getColumn());
            }
        }
    }

    private void populateColumnCombo() {
        this.addConnectionListener();
        if (this.attributeOverride == null) {
            this.columnComposite.populate(null);
        } else {
            this.columnComposite.populate((EObject)this.attributeOverride.getColumn());
        }
    }

    private INotifyChangedListener getEmbeddedListener() {
        if (this.embeddedListener == null) {
            this.embeddedListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.dali.orm.EmbeddedMapping");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    switch (notification.getFeatureID((Class)clazz)) {
                        case 1: {
                            Display.getDefault().syncExec(new Runnable(this){
                                final /* synthetic */ 4 this$1;
                                {
                                    this.this$1 = var1_1;
                                }

                                public void run() {
                                    EmbeddedAttributeOverridesComposite.access$3(4.access$0(this.this$1)).refresh();
                                }
                            });
                            if (notification.getEventType() != 3) break;
                            Object newValue = notification.getNewValue();
                            Display.getDefault().syncExec(new Runnable(this, newValue){
                                final /* synthetic */ 4 this$1;
                                private final /* synthetic */ Object val$newValue;
                                {
                                    this.this$1 = var1_1;
                                    this.val$newValue = object;
                                }

                                public void run() {
                                    EmbeddedAttributeOverridesComposite.access$3(4.access$0(this.this$1)).setSelection((ISelection)new StructuredSelection(this.val$newValue));
                                }
                            });
                            break;
                        }
                    }
                }

                static /* synthetic */ EmbeddedAttributeOverridesComposite access$0(4 var0) {
                    return var0.EmbeddedAttributeOverridesComposite.this;
                }
            };
        }
        return this.embeddedListener;
    }

    private INotifyChangedListener getAttributeOverrideItemListener() {
        if (this.attributeOverrideItemListener == null) {
            this.attributeOverrideItemListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.dali.orm.AttributeOverride");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    switch (notification.getFeatureID((Class)clazz)) {
                        case 2: {
                            AttributeOverride attributeOverride = (AttributeOverride)notification.getNotifier();
                            Display.getDefault().syncExec(new Runnable(this, attributeOverride){
                                final /* synthetic */ 7 this$1;
                                private final /* synthetic */ AttributeOverride val$attributeOverride;
                                {
                                    this.this$1 = var1_1;
                                    this.val$attributeOverride = attributeOverride;
                                }

                                public void run() {
                                    EmbeddedAttributeOverridesComposite.access$3(7.access$0(this.this$1)).refresh((Object)this.val$attributeOverride);
                                }
                            });
                            break;
                        }
                    }
                }

                static /* synthetic */ EmbeddedAttributeOverridesComposite access$0(7 var0) {
                    return var0.EmbeddedAttributeOverridesComposite.this;
                }
            };
        }
        return this.attributeOverrideItemListener;
    }

    public void dispose() {
        super.dispose();
        this.removeConnectionListener();
    }

    private void addConnectionListener() {
        if (this.connectionListener == null) {
            Connection connection = this.attributeOverride.getPersistenceProject().getConnection();
            this.connectionListener = this.buildConnectionListener(connection);
            connection.addConnectionListener(this.connectionListener);
        }
    }

    private void removeConnectionListener() {
        if (this.connectionListener != null) {
            this.connectionListener.dispose();
            this.attributeOverride.getPersistenceProject().getConnection().removeConnectionListener(this.connectionListener);
            this.connectionListener = null;
        }
    }

    private ConnectionListener buildConnectionListener(final Connection connectionInfo) {
        return new ConnectionListener(){

            public void connectionInfoRenamed(String previousName, Connection connection) {
            }

            public void connected(Connection connection) {
                if (connectionInfo.equals(connection)) {
                    EmbeddedAttributeOverridesComposite.this.populateColumnCombo();
                }
            }

            public void disconnected(Connection connection) {
                if (connectionInfo.equals(connection)) {
                    EmbeddedAttributeOverridesComposite.this.populateColumnCombo();
                }
            }

            public void sharedConnectionAdded(Connection connection) {
            }

            public void sharedConnectionRemove(Connection connection) {
            }

            public void schemaChanged(Schema schema) {
                EmbeddedAttributeOverridesComposite.this.populateColumnCombo();
            }

            public void tableChanged(Table table) {
                if (EmbeddedAttributeOverridesComposite.this.attributeOverride != null && table.getName().equalsIgnoreCase(EmbeddedAttributeOverridesComposite.this.attributeOverride.getColumn().getTableName())) {
                    EmbeddedAttributeOverridesComposite.this.populateColumnCombo();
                }
            }

            public void databaseAdded(Connection connection, Database database) {
                if (connectionInfo.equals(connection)) {
                    EmbeddedAttributeOverridesComposite.this.populateColumnCombo();
                }
            }

            public void databaseRemove(Connection connection, Database database) {
                if (connectionInfo.equals(connection)) {
                    EmbeddedAttributeOverridesComposite.this.populateColumnCombo();
                }
            }

            public void onSQLException(Connection connection, SQLException exception) {
            }

            public void dispose() {
            }
        };
    }

    static /* synthetic */ ListViewer access$3(EmbeddedAttributeOverridesComposite embeddedAttributeOverridesComposite) {
        return embeddedAttributeOverridesComposite.listViewer;
    }
}

