/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui;

import java.sql.SQLException;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dali.db.Connection;
import org.eclipse.dali.db.ConnectionListener;
import org.eclipse.dali.db.Database;
import org.eclipse.dali.db.PersistenceDbPlugin;
import org.eclipse.dali.db.Schema;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.db.ui.NewConnectionWizard;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.internal.utility.StringTools;
import org.eclipse.dali.orm.PersistenceProject;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class PersistenceProjectPropertiesPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private Group group;
    private Label connectionLabel;
    private Combo connectionCombo;
    private Label schemaLabel;
    private Combo schemaCombo;
    private Label schemaInfo;
    private Link connectionLink;
    private Link openConnectionLink;
    private Connection connection;
    private ConnectionListener connectionListener;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.dali.ui.properties_javaPersistence");
        this.group = new Group(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.group.setLayout((Layout)layout);
        this.group.setLayoutData((Object)new GridData(768));
        this.group.setText(DaliUiMessages.PersistenceProjectPropertiesPage_database);
        this.connectionLabel = this.createLabel((Composite)this.group, 1, DaliUiMessages.PersistenceProjectPropertiesPage_databaseConnection);
        this.connectionCombo = this.createCombo((Composite)this.group);
        this.connectionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                PersistenceProjectPropertiesPage.this.handleConnectionChange();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.connectionCombo, "org.eclipse.dali.ui.properties_javaPersistenceConnection");
        this.schemaLabel = this.createLabel((Composite)this.group, 1, DaliUiMessages.PersistenceProjectPropertiesPage_schema);
        this.schemaCombo = this.createCombo((Composite)this.group);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.schemaCombo, "org.eclipse.dali.ui.properties_javaPersistenceSchema");
        this.schemaInfo = this.createLabel((Composite)this.group, 2, DaliUiMessages.PersistenceProjectPropertiesPage_schemaInfo);
        this.connectionLink = new Link((Composite)this.group, 0);
        GridData data = new GridData(3, 2, false, false);
        data.horizontalSpan = 2;
        this.connectionLink.setLayoutData((Object)data);
        this.connectionLink.setText(DaliUiMessages.PersistenceProjectPropertiesPage_connectionLink);
        this.connectionLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PersistenceProjectPropertiesPage.this.openNewConnectionWizard();
            }
        });
        this.openConnectionLink = new Link((Composite)this.group, 0);
        data = new GridData(3, 2, false, false);
        data.horizontalSpan = 2;
        this.openConnectionLink.setLayoutData((Object)data);
        this.openConnectionLink.setEnabled(false);
        this.openConnectionLink.setText(DaliUiMessages.PersistenceProjectPropertiesPage_openConnectionLink);
        this.openConnectionLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PersistenceProjectPropertiesPage.this.openConnectionNamed(PersistenceProjectPropertiesPage.this.connectionCombo.getText());
            }
        });
        this.populateConnectionCombo();
        this.populateSchemaCombo();
        return composite;
    }

    private Connection openConnectionNamed(String connectionName) {
        if (this.connection != null) {
            this.removeConnectionListener();
        }
        this.connection = PersistenceDbPlugin.getDefault().getConnectionRepository().openConnectionNamed(connectionName);
        if (this.connection != null) {
            this.populateSchemaCombo();
            this.connectionListener = this.buildConnectionListener(this.connection);
            this.connection.addConnectionListener(this.connectionListener);
        }
        return this.connection;
    }

    private Label createLabel(Composite container, int span, String text) {
        Label label = new Label(container, 0);
        label.setText(text);
        GridData gd = new GridData();
        gd.horizontalIndent = 30;
        gd.horizontalSpan = span;
        label.setLayoutData((Object)gd);
        return label;
    }

    private Combo createCombo(Composite container) {
        Combo combo = new Combo(container, 2060);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        combo.setLayoutData((Object)gd);
        return combo;
    }

    private void populateConnectionCombo() {
        this.connectionCombo.removeAll();
        Iterator stream = CollectionTools.sort((Iterator)PersistenceDbPlugin.getDefault().getConnectionRepository().connectionNames());
        while (stream.hasNext()) {
            this.connectionCombo.add((String)stream.next());
        }
        String connectionName = this.getPersistenceProject().getConnectionName();
        if (!StringTools.stringIsEmpty((String)connectionName)) {
            this.connectionCombo.select(this.connectionCombo.indexOf(connectionName));
            this.openConnectionLink.setEnabled(true);
        }
    }

    private void handleConnectionChange() {
        this.openConnectionLink.setEnabled(true);
        this.populateSchemaCombo();
    }

    private void populateSchemaCombo() {
        this.schemaCombo.removeAll();
        Connection connection = PersistenceDbPlugin.getDefault().getConnectionRepository().connectionNamed(this.connectionCombo.getText());
        Iterator stream = CollectionTools.sort((Iterator)connection.getDatabase().schemaNames());
        while (stream.hasNext()) {
            this.schemaCombo.add((String)stream.next());
        }
        String currentSchemaName = this.getPersistenceProject().getSchemaName();
        if (!StringTools.stringIsEmpty((String)currentSchemaName) && !CollectionTools.contains((Object[])this.schemaCombo.getItems(), (Object)currentSchemaName)) {
            this.schemaCombo.add(currentSchemaName, 0);
        }
        if (!StringTools.stringIsEmpty((String)currentSchemaName)) {
            this.schemaCombo.select(this.schemaCombo.indexOf(currentSchemaName));
        } else {
            this.schemaCombo.select(0);
        }
    }

    private void openNewConnectionWizard() {
        NewConnectionWizard wizard = new NewConnectionWizard(true);
        wizard.setExistingConnectionNames(CollectionTools.list((Iterator)PersistenceDbPlugin.getDefault().getConnectionRepository().connectionNames()));
        wizard.init(PlatformUI.getWorkbench(), null);
        wizard.setNeedsProgressMonitor(true);
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
        Connection connection = wizard.getConnectionWrapper();
        if (connection != null) {
            this.populateConnectionCombo();
            this.handleConnectionChange();
        }
    }

    private PersistenceProject getPersistenceProject() {
        IProject project = (IProject)this.getElement();
        try {
            return (PersistenceProject)project.getNature("org.eclipse.dali.core.persistenceNature");
        }
        catch (CoreException ce) {
            throw new RuntimeException(ce);
        }
    }

    protected void performApply() {
        this.performOk();
    }

    public boolean performOk() {
        this.getPersistenceProject().setConnectionName(this.connectionCombo.getText());
        this.getPersistenceProject().setSchemaName(this.schemaCombo.getText());
        return true;
    }

    public void dispose() {
        super.dispose();
        this.removeConnectionListener();
    }

    private void removeConnectionListener() {
        if (this.connectionListener != null) {
            if (this.connection != null) {
                this.connection.removeConnectionListener(this.connectionListener);
            }
            this.connectionListener = null;
        }
    }

    private ConnectionListener buildConnectionListener(final Connection connectionInfo) {
        return new ConnectionListener(){

            public void connectionInfoRenamed(String previousName, Connection connection) {
            }

            public void connected(Connection connection) {
            }

            public void disconnected(Connection connection) {
            }

            public void sharedConnectionAdded(Connection connection) {
            }

            public void sharedConnectionRemove(Connection connection) {
            }

            public void schemaChanged(Schema schema) {
            }

            public void tableChanged(Table table) {
            }

            public void databaseAdded(Connection connection, Database database) {
                if (connectionInfo.equals(connection)) {
                    PersistenceProjectPropertiesPage.this.populateSchemaCombo();
                }
            }

            public void databaseRemove(Connection connection, Database database) {
                if (connectionInfo.equals(connection)) {
                    PersistenceProjectPropertiesPage.this.removeConnectionListener();
                }
            }

            public void onSQLException(Connection connection, SQLException exception) {
                connectionInfo.equals(connection);
            }

            public void dispose() {
                if (connectionInfo.equals(PersistenceProjectPropertiesPage.this.connection)) {
                    PersistenceProjectPropertiesPage.this.removeConnectionListener();
                }
            }
        };
    }
}

