/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import java.util.List;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.orm.AssociationOverride;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.adapters.IAssociationOverrideModelAdapter;
import org.eclipse.dali.orm.adapters.IColumnModelAdapter;
import org.eclipse.dali.orm.adapters.IJoinColumnModelAdapter;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;

public class JavaAssociationOverrideModelAdapter
implements IAssociationOverrideModelAdapter {
    public static final String ASSOCIATION_OVERRIDE_ANNOTATION = "AssociationOverride";
    public static final String ASSOCIATION_OVERRIDES_ANNOTATION = "AssociationOverrides";
    private AssociationOverride associationOverride;
    private Member member;

    JavaAssociationOverrideModelAdapter(Member member) {
        this.member = member;
    }

    private Entity getEntity() {
        return (Entity)this.associationOverride.getParent();
    }

    public IJoinColumnModelAdapter createJoinColumnModelAdapter() {
        return null;
    }

    private IColumnModelAdapter.ColumnOwner buildColumnOwner() {
        return new IColumnModelAdapter.ColumnOwner(){

            public Table getTableNamed(String tableName) {
                return this.getTypeMapping().getResolvedDBTable(tableName);
            }

            public TypeMapping getTypeMapping() {
                return JavaAssociationOverrideModelAdapter.this.getEntity();
            }

            public ITextRange getTextRange() {
                return JavaAssociationOverrideModelAdapter.this.associationOverride.getTextRange();
            }
        };
    }

    public void setAssociationOverride(AssociationOverride associationOverride) {
        this.associationOverride = associationOverride;
    }

    void updatePersModel(CompilationUnit astRoot) {
    }

    void postUpdatePersModel(CompilationUnit astRoot) {
    }

    public ITextRange getTextRange() {
        BodyDeclaration bodyDeclaration = this.member.bodyDeclaration();
        Annotation annotation = this.getAttributeOverrideAnnotation(bodyDeclaration);
        if (annotation == null) {
            return null;
        }
        return ASTTools.textRange((ASTNode)annotation);
    }

    Annotation getAttributeOverrideAnnotation(BodyDeclaration bodyDeclaration) {
        Expression nameStringLiteral;
        MemberValuePair nameValuePair;
        MemberValuePair valueValuePair;
        Annotation attributeOverrideAnnotation = ASTTools.annotation(bodyDeclaration, ASSOCIATION_OVERRIDE_ANNOTATION);
        if (attributeOverrideAnnotation != null) {
            String annotationName = ASTTools.annotationElementStringValue(bodyDeclaration, ASSOCIATION_OVERRIDE_ANNOTATION, "name");
            if (annotationName != null && annotationName.equals(this.associationOverride.getName())) {
                return attributeOverrideAnnotation;
            }
            return null;
        }
        Expression valueExpression = null;
        Annotation attributeOverridesAnnotation = ASTTools.annotation(bodyDeclaration, ASSOCIATION_OVERRIDES_ANNOTATION);
        if (attributeOverridesAnnotation != null && attributeOverridesAnnotation.isSingleMemberAnnotation()) {
            valueExpression = ((SingleMemberAnnotation)attributeOverridesAnnotation).getValue();
        } else if (attributeOverridesAnnotation != null && attributeOverridesAnnotation.isNormalAnnotation() && (valueValuePair = ASTTools.memberValuePair((NormalAnnotation)attributeOverridesAnnotation, "value")) != null) {
            valueExpression = valueValuePair.getValue();
        }
        if (valueExpression == null) {
            return null;
        }
        if (valueExpression.getNodeType() == 4) {
            List expressions = ((ArrayInitializer)valueExpression).expressions();
            int i = 0;
            while (i < expressions.size()) {
                Expression nameStringLiteral2;
                Expression expression = (Expression)expressions.get(i);
                if (expression.getNodeType() == 77 && ((NormalAnnotation)expression).getTypeName().getFullyQualifiedName().equals(ASSOCIATION_OVERRIDE_ANNOTATION) && (nameStringLiteral2 = ASTTools.memberValuePair((NormalAnnotation)expression, "name").getValue()).getNodeType() == 45) {
                    String attributeOverrideName = this.associationOverride.getName();
                    if (((StringLiteral)nameStringLiteral2).getLiteralValue().equals(attributeOverrideName)) {
                        return (NormalAnnotation)expression;
                    }
                }
                ++i;
            }
        } else if (valueExpression.getNodeType() == 77 && valueExpression.getNodeType() == 77 && ((NormalAnnotation)valueExpression).getTypeName().getFullyQualifiedName().equals(ASSOCIATION_OVERRIDE_ANNOTATION) && (nameValuePair = ASTTools.memberValuePair((NormalAnnotation)valueExpression, "name")) != null && (nameStringLiteral = nameValuePair.getValue()).getNodeType() == 45) {
            String attributeOverrideName = this.associationOverride.getName();
            if (((StringLiteral)nameStringLiteral).getLiteralValue().equals(attributeOverrideName)) {
                return (NormalAnnotation)valueExpression;
            }
        }
        return null;
    }
}

