/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.internal.utility.ClassTools;
import org.eclipse.dali.orm.GeneratedValue;
import org.eclipse.dali.orm.GenerationType;
import org.eclipse.dali.orm.adapters.IGeneratedValueModelAdapter;
import org.eclipse.dali.orm.adapters.java.AbstractAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.EnumAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.dali.orm.adapters.java.StringAnnotationElementAdapter;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaGeneratedValueModelAdapter
implements IGeneratedValueModelAdapter {
    private GeneratedValue generatedValue;
    private Member member;
    private EnumAnnotationElementAdapter strategyAdapter;
    private StringAnnotationElementAdapter specifiedGeneratorNameAdapter;
    public static final String ANNOTATION_NAME = "GeneratedValue";
    public static final String STRATEGY_ELEMENT = "strategy";
    static final String GENERATION_TYPE_AUTO_NAME = "AUTO";
    static final String GENERATION_TYPE_IDENTITY_NAME = "IDENTITY";
    static final String GENERATION_TYPE_SEQUENCE_NAME = "SEQUENCE";
    static final String GENERATION_TYPE_TABLE_NAME = "TABLE";
    public static final String GENERATOR_NAME_ELEMENT = "generator";
    public static final String GENERATION_TYPE;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.orm.GenerationType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GENERATION_TYPE = ClassTools.shortNameFor((Class)clazz);
    }

    public JavaGeneratedValueModelAdapter(Member member) {
        this.member = member;
        this.strategyAdapter = new EnumAnnotationElementAdapter(this.buildStrategyInfo());
        this.specifiedGeneratorNameAdapter = new StringAnnotationElementAdapter(this.buildSpecifiedGeneratorNameInfo());
    }

    public void setGeneratedValue(GeneratedValue generatedValue) {
        this.generatedValue = generatedValue;
    }

    private EnumAnnotationElementAdapter.EnumAnnotationElementInfo buildStrategyInfo() {
        return new EnumAnnotationElementAdapter.EnumAnnotationElementInfo(){

            public void setPersValue(String javaString) {
                GenerationType genType = this.generationTypeFor(javaString);
                if (genType != JavaGeneratedValueModelAdapter.this.getGeneratedValue().getStrategy()) {
                    JavaGeneratedValueModelAdapter.this.getGeneratedValue().setStrategy(genType);
                }
            }

            GenerationType generationTypeFor(String javaString) {
                if (javaString == null) {
                    return GenerationType.DEFAULT_LITERAL;
                }
                if (javaString.equals(JavaGeneratedValueModelAdapter.GENERATION_TYPE_AUTO_NAME)) {
                    return GenerationType.AUTO_LITERAL;
                }
                if (javaString.equals(JavaGeneratedValueModelAdapter.GENERATION_TYPE_IDENTITY_NAME)) {
                    return GenerationType.IDENTITY_LITERAL;
                }
                if (javaString.equals(JavaGeneratedValueModelAdapter.GENERATION_TYPE_SEQUENCE_NAME)) {
                    return GenerationType.SEQUENCE_LITERAL;
                }
                if (javaString.equals(JavaGeneratedValueModelAdapter.GENERATION_TYPE_TABLE_NAME)) {
                    return GenerationType.TABLE_LITERAL;
                }
                return GenerationType.DEFAULT_LITERAL;
            }

            public String persValue() {
                return this.persValueFor(JavaGeneratedValueModelAdapter.this.getGeneratedValue().getStrategy());
            }

            String persValueFor(GenerationType generationType) {
                if (generationType == GenerationType.AUTO_LITERAL) {
                    return JavaGeneratedValueModelAdapter.GENERATION_TYPE_AUTO_NAME;
                }
                if (generationType == GenerationType.IDENTITY_LITERAL) {
                    return JavaGeneratedValueModelAdapter.GENERATION_TYPE_IDENTITY_NAME;
                }
                if (generationType == GenerationType.SEQUENCE_LITERAL) {
                    return JavaGeneratedValueModelAdapter.GENERATION_TYPE_SEQUENCE_NAME;
                }
                if (generationType == GenerationType.TABLE_LITERAL) {
                    return JavaGeneratedValueModelAdapter.GENERATION_TYPE_TABLE_NAME;
                }
                if (generationType == GenerationType.DEFAULT_LITERAL) {
                    return null;
                }
                throw new IllegalStateException("Unrecognized GenerationType: " + (Object)((Object)generationType));
            }

            public String enumClassName() {
                return GENERATION_TYPE;
            }

            public String annotationElementName() {
                return JavaGeneratedValueModelAdapter.STRATEGY_ELEMENT;
            }

            public String annotationName() {
                return JavaGeneratedValueModelAdapter.ANNOTATION_NAME;
            }

            public Member member() {
                return JavaGeneratedValueModelAdapter.this.member;
            }

            public String defaultValue() {
                return null;
            }

            public boolean removeAnnotationIfEmpty() {
                return false;
            }
        };
    }

    private AbstractAnnotationElementAdapter.AnnotationElementInfo buildSpecifiedGeneratorNameInfo() {
        return new AbstractAnnotationElementAdapter.AnnotationElementInfo(){

            public void setPersValue(String newValue) {
                JavaGeneratedValueModelAdapter.this.getGeneratedValue().setSpecifiedGeneratorName(newValue);
            }

            public String persValue() {
                return JavaGeneratedValueModelAdapter.this.getGeneratedValue().getSpecifiedGeneratorName();
            }

            public String annotationElementName() {
                return JavaGeneratedValueModelAdapter.GENERATOR_NAME_ELEMENT;
            }

            public String annotationName() {
                return JavaGeneratedValueModelAdapter.ANNOTATION_NAME;
            }

            public Member member() {
                return JavaGeneratedValueModelAdapter.this.member;
            }

            public String defaultValue() {
                return null;
            }

            public boolean removeAnnotationIfEmpty() {
                return false;
            }
        };
    }

    void updatePersModel(CompilationUnit astRoot) {
        this.updatePersStrategy(astRoot);
        this.updatePersSpecifiedGeneratorName(astRoot);
    }

    private void updatePersStrategy(CompilationUnit astRoot) {
        this.strategyAdapter.updatePersElement(astRoot);
    }

    public void specifiedGeneratorNameChanged() {
        this.updateJavaSpecifiedGeneratorName();
    }

    private void updateJavaSpecifiedGeneratorName() {
        this.specifiedGeneratorNameAdapter.updateJavaElement();
    }

    private void updatePersSpecifiedGeneratorName(CompilationUnit astRoot) {
        this.specifiedGeneratorNameAdapter.updatePersElement(astRoot);
    }

    public void strategyChanged() {
        this.updateJavaGenerationType();
    }

    private void updateJavaGenerationType() {
        this.strategyAdapter.updateJavaElement();
    }

    public ITextRange getTextRange() {
        return null;
    }

    private GeneratedValue getGeneratedValue() {
        return this.generatedValue;
    }
}

