/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.generic;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jsr220Orm.xml.EntityManagerDocument;
import org.eclipse.jsr220orm.core.nature.OrmNature;
import org.eclipse.jsr220orm.core.nature.PersistenceProperties;
import org.eclipse.jsr220orm.generic.GenericPlugin;
import org.eclipse.jsr220orm.generic.Utils;

public class ParBuilder
extends IncrementalProjectBuilder {
    public static final String ID = "org.eclipse.jsr220orm.generic.par.file.builder";
    protected static final String PERSISTENCE_XML_NAMESPACE = "http://jsr220orm.eclipse.org/xml";

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        OrmNature nature = (OrmNature)project.getNature("org.eclipse.jsr220orm.core.nature");
        if (nature != null) {
            PersistenceProperties persistenceProperties = nature.getPersistenceProperties();
            Properties props = persistenceProperties.getProperties();
            String name = props.getProperty("ejb3.persistence.xml.file");
            if (name == null) {
                name = "persistence.xml";
            }
            IFile file = project.getFile(name);
            String parFileName = persistenceProperties.getParFileName();
            IFile parIFile = project.getFile(parFileName);
            if (file.exists()) {
                try {
                    File parDir;
                    IPath parPath = parIFile.getRawLocation();
                    File parFile = new File(parPath.toOSString());
                    if (!parFile.exists() && !(parDir = parFile.getParentFile()).exists()) {
                        parDir.mkdirs();
                    }
                    JarOutputStream jos = new JarOutputStream(new FileOutputStream(parFile));
                    file.getContents(false);
                    this.addFile(jos, file, (IPath)new Path("META-INF/persistence.xml"), parFile);
                    jos.flush();
                    jos.close();
                    parIFile.refreshLocal(1, monitor);
                }
                catch (CoreException e) {
                    throw e;
                }
                catch (Exception e) {
                    Status status = new Status(4, GenericPlugin.getPluginId(), 0, "Problem building .par file", (Throwable)e);
                    throw new CoreException((IStatus)status);
                }
            }
        }
        return null;
    }

    protected void addFile(JarOutputStream jos, IFile resource, IPath path, File correspondingFile) throws IOException, CoreException {
        JarEntry newEntry = new JarEntry(path.toString().replace(File.separatorChar, '/'));
        byte[] readBuffer = new byte[4096];
        newEntry.setMethod(0);
        this.calculateCrcAndSize(newEntry, resource, readBuffer);
        long lastModified = correspondingFile != null && correspondingFile.exists() ? correspondingFile.lastModified() : System.currentTimeMillis();
        newEntry.setTime(lastModified);
        InputStream contentStream = resource.getContents(false);
        try {
            int count;
            jos.putNextEntry(newEntry);
            while ((count = contentStream.read(readBuffer, 0, readBuffer.length)) != -1) {
                jos.write(readBuffer, 0, count);
            }
        }
        finally {
            if (contentStream != null) {
                contentStream.close();
            }
        }
    }

    private void calculateCrcAndSize(JarEntry jarEntry, IFile resource, byte[] readBuffer) throws IOException, CoreException {
        InputStream contentStream = resource.getContents(false);
        int size = 0;
        CRC32 checksumCalculator = new CRC32();
        try {
            int count;
            while ((count = contentStream.read(readBuffer, 0, readBuffer.length)) != -1) {
                checksumCalculator.update(readBuffer, 0, count);
                size += count;
            }
        }
        finally {
            if (contentStream != null) {
                contentStream.close();
            }
        }
        jarEntry.setSize(size);
        jarEntry.setCrc(checksumCalculator.getValue());
    }

    protected EntityManagerDocument.EntityManager loadPersistenceXml(IProject project, String name) throws CoreException, XmlException, IOException {
        IFile file;
        if (name == null) {
            name = "persistence.xml";
        }
        if ((file = project.getProject().getFile(name)).exists()) {
            EntityManagerDocument doc;
            InputStream ins = file.getContents();
            try {
                doc = EntityManagerDocument.Factory.parse((InputStream)ins, (XmlOptions)this.getXmlOptions(PERSISTENCE_XML_NAMESPACE));
            }
            finally {
                Utils.close(ins);
            }
            return doc.getEntityManager();
        }
        return null;
    }

    public XmlOptions getXmlOptions(String defaultNamespace) {
        XmlOptions ops = new XmlOptions();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("", defaultNamespace);
        ops.setLoadSubstituteNamespaces(map);
        return ops;
    }
}

