/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.generic;

import com.sun.org.apache.xerces.internal.impl.XMLEntityManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddableSuperclass;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jsr220Orm.xml.EntityManagerDocument;
import org.eclipse.jsr220orm.core.OrmPlugin;
import org.eclipse.jsr220orm.core.nature.PersistenceProperties;
import org.eclipse.jsr220orm.generic.GenericEntityModelManager;
import org.eclipse.jsr220orm.generic.GenericPlugin;
import org.eclipse.jsr220orm.generic.Utils;
import org.eclipse.jsr220orm.generic.io.EntityIO;
import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.metadata.EntityModel;
import org.eclipse.jsr220orm.metadata.TypeMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceXmlManager
implements IResourceChangeListener {
    protected final GenericEntityModelManager mm;
    protected final EntityModel model;
    protected EntityManagerDocument doc;
    protected EntityManagerDocument.EntityManager emElement;
    protected IFile xmlFile;
    protected boolean ignoreEvents;
    protected static final char[] JAVAX_PERSISTENCE_CHARS = "javax.persistence.".toCharArray();
    protected static final char[] ENTITY_CHARS = XMLEntityManager.Entity.class.getSimpleName().toCharArray();
    protected static final char[] EMBEDDABLE_CHARS = Embeddable.class.getSimpleName().toCharArray();
    protected static final char[] EMBEDDABLE_SUPERCLASS_CHARS = EmbeddableSuperclass.class.getSimpleName().toCharArray();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public PersistenceXmlManager(GenericEntityModelManager manager) {
        this.mm = manager;
        this.model = manager.getEntityModel();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public boolean updateModelFromPersistenceXml() throws Exception {
        return this.updateModelFromPersistenceXml(1);
    }

    public boolean updateModelFromPersistenceXml(int entityType) throws Exception {
        boolean changed = false;
        boolean updateModel = false;
        HashSet<String> classes = new HashSet<String>();
        classes.addAll((Collection)Arrays.asList(this.emElement.getClass1Array()));
        List<String> all = this.findEntitiesInProject();
        for (String name : all) {
            if (classes.contains(name)) continue;
            this.emElement.addClass1(name);
            classes.add(name);
            changed = true;
        }
        ArrayList classList = new ArrayList(classes);
        Collections.sort(classList);
        EList typeList = this.model.getTypeList();
        for (String className : classList) {
            IType type;
            EntityMetaData emd;
            TypeMetaData tmd = this.model.findTypeByClassName(className);
            if (tmd != null && !(tmd instanceof EntityMetaData) || (emd = (EntityMetaData)tmd) != null || (type = this.mm.getProject().findType(className)) == null) continue;
            emd = this.mm.getFactory().createEntityMetaData();
            emd.setEntityModel(this.model);
            emd.setClassName(className);
            emd.setEntityType(entityType);
            typeList.add(emd);
            updateModel = true;
            new EntityIO(this.mm, emd, type);
        }
        Iterator i = typeList.iterator();
        while (i.hasNext()) {
            TypeMetaData tmd = (TypeMetaData)i.next();
            if (!(tmd instanceof EntityMetaData) || classes.contains(tmd.getClassName())) continue;
            i.remove();
            updateModel = true;
            EntityIO entityIO = (EntityIO)tmd.adapt(EntityIO.class);
            if (entityIO == null) continue;
            entityIO.dispose();
        }
        if (updateModel) {
            ArrayList<EntityIO> a = new ArrayList<EntityIO>();
            for (Object o : typeList) {
                EntityIO entityIO;
                if (!(o instanceof EntityMetaData) || (entityIO = EntityIO.get((EntityMetaData)o)) == null) continue;
                a.add(entityIO);
            }
            this.mm.updateModelFromMetaData(a);
        }
        return changed;
    }

    protected void loadPersistenceXml() throws Exception {
        this.doc = Utils.loadPersistenceXml(this.mm.getProject().getProject());
        this.emElement = this.doc.getEntityManager();
    }

    public void savePersistenceXml() throws Exception {
        try {
            this.ignoreEvents = true;
            Utils.savePersistenceXml(this.mm.getProject().getProject(), this.doc);
        }
        finally {
            this.ignoreEvents = false;
        }
    }

    public List<String> findEntitiesInProject() {
        ArrayList<String> ans = new ArrayList<String>();
        try {
            this.findEntitiesInProject((IJavaElement)this.mm.getProject(), ans);
        }
        catch (JavaModelException e) {
            OrmPlugin.log((Throwable)e);
        }
        Collections.sort(ans);
        return ans;
    }

    protected void findEntitiesInProject(IJavaElement root, List<String> ans) throws JavaModelException {
        block6: {
            block5: {
                if (root instanceof IClassFile || root instanceof JarPackageFragmentRoot) {
                    return;
                }
                if (!(root instanceof ICompilationUnit)) break block5;
                ICompilationUnit cu = (ICompilationUnit)root;
                IType[] types = cu.getTypes();
                int i = 0;
                while (i < types.length) {
                    IType t = types[i];
                    if (t.isBinary()) {
                        return;
                    }
                    if (t.isClass() && Flags.isPublic((int)t.getFlags()) && this.getEntityType(t) != 0) {
                        ans.add(t.getFullyQualifiedName());
                    }
                    ++i;
                }
                break block6;
            }
            if (!(root instanceof IParent)) break block6;
            IJavaElement[] children = ((IParent)root).getChildren();
            int i = 0;
            while (i < children.length) {
                this.findEntitiesInProject(children[i], ans);
                ++i;
            }
        }
    }

    protected int getEntityType(IType t) throws JavaModelException {
        int first = t.getSourceRange().getOffset();
        int last = t.getNameRange().getOffset();
        IOpenable openable = t.getOpenable();
        IBuffer buffer = openable.getBuffer();
        if (buffer == null) {
            return 0;
        }
        int state = 0;
        char[] ann = new char[64];
        int annLength = 0;
        int i = first;
        block15: while (i < last) {
            char c = buffer.getChar(i++);
            switch (state) {
                case 0: {
                    switch (c) {
                        case '/': {
                            state = 47;
                            break;
                        }
                        case '@': {
                            state = 64;
                            annLength = 0;
                        }
                    }
                    continue block15;
                }
                case 47: {
                    switch (c) {
                        case '/': {
                            state = -2;
                            break;
                        }
                        case '*': {
                            state = -3;
                        }
                    }
                    continue block15;
                }
                case -2: {
                    if (c != '\n') break;
                    state = 0;
                    break;
                }
                case -3: {
                    if (c != '*' || i >= last || buffer.getChar(i) != '/') continue block15;
                    state = 0;
                    ++i;
                    break;
                }
                case 64: {
                    int offset;
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '.') {
                        if (annLength == ann.length) {
                            state = 0;
                            break;
                        }
                        ann[annLength++] = c;
                        break;
                    }
                    if (PersistenceXmlManager.equal(ann, 0, annLength, JAVAX_PERSISTENCE_CHARS)) {
                        offset = JAVAX_PERSISTENCE_CHARS.length;
                        annLength -= offset;
                    } else {
                        offset = 0;
                    }
                    if (PersistenceXmlManager.equal(ann, offset, annLength, ENTITY_CHARS)) {
                        return 1;
                    }
                    if (PersistenceXmlManager.equal(ann, offset, annLength, EMBEDDABLE_CHARS)) {
                        return 2;
                    }
                    if (!PersistenceXmlManager.equal(ann, offset, annLength, EMBEDDABLE_SUPERCLASS_CHARS)) break;
                    return 3;
                }
            }
        }
        return 0;
    }

    protected static boolean equal(char[] a, int offset, int len, char[] b) {
        int n = b.length;
        if (len < n) {
            return false;
        }
        int i = 0;
        while (i < n) {
            if (a[offset++] == b[i++]) continue;
            return false;
        }
        return true;
    }

    public void makePersistent(Collection<String> names, int entityType) throws Exception {
        for (String fullName : names) {
            this.emElement.addClass1(fullName);
        }
        this.savePersistenceXml();
        this.updateModelFromPersistenceXml(entityType);
    }

    public void makeNotPersistent(Collection<EntityMetaData> col) throws Exception {
        for (EntityMetaData emd : col) {
            String className = emd.getClassName();
            String[] all = this.emElement.getClass1Array();
            int i = all.length - 1;
            while (i >= 0) {
                if (all[i].equals(className)) {
                    this.emElement.removeClass1(i);
                }
                --i;
            }
        }
        this.savePersistenceXml();
        this.updateModelFromPersistenceXml();
    }

    public void resourceChanged(IResourceChangeEvent changeEvent) {
        if (this.ignoreEvents) {
            return;
        }
        IResourceDelta delta = changeEvent.getDelta();
        if (this.xmlFile == null) {
            IProject project = this.mm.getProject().getProject();
            try {
                PersistenceProperties props = new PersistenceProperties(project);
                String name = props.getPersistenceFileName();
                if (name != null) {
                    this.xmlFile = project.getFile(name);
                }
            }
            catch (Exception exception) {}
            if (this.xmlFile == null) {
                return;
            }
        }
        if (delta.findMember(this.xmlFile.getFullPath()) != null) {
            GenericPlugin.getStandardDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        if (PersistenceXmlManager.this.mm.getEntityModel() == PersistenceXmlManager.this.model && PersistenceXmlManager.this.model != null) {
                            PersistenceXmlManager.this.loadPersistenceXml();
                            PersistenceXmlManager.this.updateModelFromPersistenceXml();
                        }
                    }
                    catch (Exception x) {
                        GenericPlugin.logException(x);
                    }
                }
            });
        }
    }
}

