/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.generic.io;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.eclipse.jsr220Orm.generic.xml.AnnotationsDocument;
import org.eclipse.jsr220orm.core.OrmPlugin;
import org.eclipse.jsr220orm.core.util.JdbcUtils;
import org.eclipse.jsr220orm.generic.Utils;
import org.eclipse.jsr220orm.generic.io.AnnotationEx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationRegistry {
    protected Map<String, AnnInfo> nameInfoMap = new HashMap<String, AnnInfo>();
    protected Map<Class, AnnInfo> classInfoMap = new HashMap<Class, AnnInfo>();
    protected Set<Class> enumSet = new HashSet<Class>();
    protected Map<String, Object> namedValueMap = new HashMap<String, Object>();
    protected static final String ANNOTATION_REGISTRY_XML_NAMESPACE = "http://jsr220orm.eclipse.org/generic/xml";
    static /* synthetic */ Class class$0;

    public AnnotationRegistry() {
        this.registerJavaSqlTypes();
    }

    public void load(String namespace) throws IOException, XmlException {
        InputStream ins = Utils.openBundleResource(namespace, "annotations.xml");
        try {
            AnnotationsDocument doc = AnnotationsDocument.Factory.parse((InputStream)ins, (XmlOptions)Utils.getXmlOptions(ANNOTATION_REGISTRY_XML_NAMESPACE));
            int c = 0;
            AnnotationsDocument.Annotations.Ann[] annArray = doc.getAnnotations().getAnnArray();
            int n = 0;
            int n2 = annArray.length;
            while (n < n2) {
                AnnotationsDocument.Annotations.Ann ann = annArray[n];
                String name = ann.getName();
                try {
                    Class<?> cls = Class.forName(name);
                    AnnInfo info = this.add(cls);
                    info.index = c++;
                    info.marker = ann.getMarker();
                    AnnotationsDocument.Annotations.Ann.Value[] values = ann.getValueArray();
                    if (values.length == 0) {
                        info.valueIndexMap = Collections.EMPTY_MAP;
                    } else {
                        info.valueIndexMap = new HashMap<String, Integer>();
                        int i = 0;
                        while (i < values.length) {
                            info.valueIndexMap.put(values[i].getName(), i);
                            ++i;
                        }
                    }
                }
                catch (Exception e) {
                    OrmPlugin.log((String)(String.valueOf(name) + ": " + e), (Throwable)e);
                }
                ++n;
            }
        }
        finally {
            Utils.close(ins);
        }
    }

    protected AnnInfo add(Class cls) {
        AnnInfo info = new AnnInfo();
        info.annotationType = cls;
        info.defaultValueMap = new HashMap();
        String fullName = cls.getName();
        String shortName = cls.getSimpleName();
        this.nameInfoMap.put(shortName, info);
        this.nameInfoMap.put(fullName, info);
        this.classInfoMap.put(info.annotationType, info);
        this.registerEnumsAndDefaults(info);
        return info;
    }

    protected void registerEnumsAndDefaults(AnnInfo info) {
        Method[] a = info.annotationType.getDeclaredMethods();
        int i = a.length - 1;
        while (i >= 0) {
            Object defaultValue;
            Method m = a[i];
            Class<?> rt = m.getReturnType();
            if (rt.isArray()) {
                rt = rt.getComponentType();
            }
            if (rt.isEnum() && !this.enumSet.contains(rt)) {
                this.enumSet.add(rt);
                String fullName = rt.getName();
                String shortName = rt.getSimpleName();
                ?[] values = rt.getEnumConstants();
                int j = values.length - 1;
                while (j >= 0) {
                    Enum e = (Enum)values[j];
                    this.namedValueMap.put(String.valueOf(shortName) + "." + e.name(), e);
                    this.namedValueMap.put(String.valueOf(fullName) + "." + e.name(), e);
                    --j;
                }
            }
            if ((defaultValue = m.getDefaultValue()) != null) {
                info.defaultValueMap.put(m.getName(), defaultValue);
            }
            --i;
        }
        info.singleValue = a.length == 1 && a[0].getName().equals("value");
    }

    protected void registerJavaSqlTypes() {
        Map map = JdbcUtils.getJdbcNameIntMap();
        for (Map.Entry e : map.entrySet()) {
            this.namedValueMap.put((String)e.getKey(), e.getValue());
        }
    }

    protected AnnInfo getInfo(String name) {
        return this.nameInfoMap.get(name);
    }

    protected AnnInfo getInfo(Class annotationType) {
        return this.classInfoMap.get(annotationType);
    }

    public Class getClass(String name) {
        AnnInfo i = this.getInfo(name);
        return i == null ? null : i.annotationType;
    }

    public Object getNamedValue(String name) {
        return this.namedValueMap.get(name);
    }

    public <T extends Annotation> T getDefaultProxy(Class<T> annotationType) {
        AnnInfo i = this.getInfo(annotationType);
        if (i.defaultProxy == null) {
            i.defaultProxy = Proxy.newProxyInstance(annotationType.getClassLoader(), new Class[]{annotationType}, (InvocationHandler)new DefaultHandler("Defaults:" + annotationType.getName()));
        }
        return (T)((Annotation)i.defaultProxy);
    }

    public <T extends Annotation> T getDefaultProxyEx(Class<T> annotationType) {
        return (T)((Annotation)Proxy.newProxyInstance(annotationType.getClassLoader(), new Class[]{annotationType, AnnotationEx.class}, (InvocationHandler)new DefaultHandlerEx(annotationType)));
    }

    public int getOrderingIndex(String annotationTypeName) {
        AnnInfo i = this.getInfo(annotationTypeName);
        return i == null ? 10000 : i.index;
    }

    public Map<String, Integer> getOrderingMap(Class annotationType) {
        AnnInfo i = this.getInfo(annotationType);
        return i == null ? Collections.EMPTY_MAP : i.valueIndexMap;
    }

    public boolean isMarker(Class annotationType) {
        AnnInfo i = this.getInfo(annotationType);
        return i != null && i.marker;
    }

    public boolean isSingleValue(Class annotationType) {
        AnnInfo i = this.getInfo(annotationType);
        return i != null && i.singleValue;
    }

    public Object getDefault(Class annotationType, String name) {
        return this.getInfo((Class)annotationType).defaultValueMap.get(name);
    }

    protected static class AnnInfo {
        public Class annotationType;
        public boolean marker;
        public boolean singleValue;
        public Object defaultProxy;
        public Map defaultValueMap = new HashMap();
        public int index;
        public Map<String, Integer> valueIndexMap;

        protected AnnInfo() {
        }
    }

    private static class DefaultHandler
    implements InvocationHandler {
        final String name;

        DefaultHandler(String name) {
            this.name = name;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("toString".equals(method.getName())) {
                return this.name;
            }
            return method.getDefaultValue();
        }
    }

    protected static class DefaultHandlerEx
    implements InvocationHandler {
        protected final Class annotationType;
        protected Map defaultMap;

        public DefaultHandlerEx(Class annotationType) {
            this.annotationType = annotationType;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (args != null && args.length == 1 && "get".equals(methodName)) {
                methodName = (String)args[0];
                method = this.annotationType.getDeclaredMethod(methodName, null);
                args = null;
            }
            if (args == null) {
                if ("toString".equals(methodName)) {
                    return "DefaultsEx:" + this.annotationType.getName() + "@" + Integer.toHexString(System.identityHashCode(this));
                }
                if (this.defaultMap != null && this.defaultMap.containsKey(methodName)) {
                    return this.defaultMap.get(methodName);
                }
            } else if (args.length == 2 && "setDefault".equals(methodName)) {
                if (this.defaultMap == null) {
                    this.defaultMap = new HashMap();
                }
                this.defaultMap.put(args[0], args[1]);
                return null;
            }
            return method.getDefaultValue();
        }
    }
}

