/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.generic.io;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.eclipse.jsr220orm.core.internal.options.IntOption;
import org.eclipse.jsr220orm.generic.GenericEntityModelManager;
import org.eclipse.jsr220orm.generic.Utils;
import org.eclipse.jsr220orm.generic.io.AnnotationEx;
import org.eclipse.jsr220orm.generic.io.AttributeIO;
import org.eclipse.jsr220orm.generic.io.EntityIO;
import org.eclipse.jsr220orm.generic.reflect.RAnnotatedElement;
import org.eclipse.jsr220orm.generic.reflect.RClass;
import org.eclipse.jsr220orm.metadata.AttributeMetaData;
import org.eclipse.jsr220orm.metadata.BasicAttribute;
import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.metadata.MetadataPackage;
import org.eclipse.jsr220orm.metadata.OrmColumn;
import org.eclipse.jsr220orm.metadata.SimpleTypeMetaData;
import org.eclipse.jsr220orm.metadata.TypeMetaData;

public class BasicAttributeIO
extends AttributeIO {
    protected BasicAttribute amd;
    public static final IntOption MAPPING_BASIC = new IntOption(1, "Basic", "Single column in table for entity", Utils.getImage("Simple16"));
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public BasicAttributeIO(EntityIO entityIO) {
        super(entityIO);
    }

    public AttributeMetaData getAttributeMetaData() {
        return this.amd;
    }

    public void getPossibleMappings(List ans) {
        ans.add(MAPPING_BASIC);
        ans.add(MAPPING_NOT_PERSISTENT);
    }

    public IntOption getMapping() {
        if (this.amd == null || this.amd.isNonPersistent()) {
            return MAPPING_NOT_PERSISTENT;
        }
        return MAPPING_BASIC;
    }

    public void setMapping(IntOption mapping) {
        this.setPersistent(MAPPING_BASIC.equals((Object)mapping));
    }

    public boolean updateModelFromMetaData(RClass cls, RAnnotatedElement attribute, boolean metaDataChanged) {
        this.amd = (BasicAttribute)this.initAttributeMetaData((AttributeMetaData)this.amd, attribute, MetadataPackage.eINSTANCE.getBasicAttribute());
        if (this.amd.isNonPersistent()) {
            return true;
        }
        GenericEntityModelManager mm = this.entityIO.getModelManager();
        EntityMetaData emd = this.entityIO.getEntityMetaData();
        if (this.amd.getJavaType() == null) {
            this.updateModelCleanup();
            this.addNullJavaTypeProblem(attribute);
            return true;
        }
        OrmColumn dc = this.getDefaultColumn();
        Basic basic = (Basic)this.getBasicAnnotation(attribute, dc);
        this.setFetchType((AttributeMetaData)this.amd, basic.fetch());
        this.amd.setOptional(basic.optional());
        OrmColumn ormCol = this.entityIO.ensureOrmColumn(this.amd.getColumn());
        Column column = (Column)this.getColumnAnnotation(attribute, dc);
        ormCol.setJdbcType(column.jdbcType());
        ormCol.setInsertable(column.insertable());
        if (mm.getVendorDef().isNumericType(ormCol.getJdbcType())) {
            ormCol.setLength(column.precision());
        } else {
            ormCol.setLength(column.length());
        }
        ormCol.setScale(column.scale());
        ormCol.setName(column.name());
        ormCol.setNullable(column.nullable());
        ormCol.setUpdatable(column.updatable());
        ormCol.setTable(emd.getTable());
        String cd = column.columnDefinition();
        if (cd.length() == 0) {
            ormCol.setColumnDefinitionSpecified(false);
            cd = mm.getColumnDefinition(ormCol);
        } else {
            ormCol.setColumnDefinitionSpecified(true);
        }
        ormCol.setColumnDefinition(cd);
        ormCol.setOriginalColumnDefinition(cd);
        mm.updateDatabaseType(ormCol);
        ormCol.setComment(this.getComment((AttributeMetaData)this.amd));
        if (this.amd.getColumn() != ormCol) {
            this.amd.setColumn(ormCol);
        }
        int relativePositionInTable = this.getRelativePosition(attribute);
        Version version = attribute.getAnnotation(Version.class);
        Id id = attribute.getAnnotation(Id.class);
        if (emd.isBaseEntity() || emd.isEmbeddableSuperclass()) {
            if (id != null) {
                boolean hasValues;
                boolean bl = hasValues = ((AnnotationEx)id).getValueCount() > 0;
                if (hasValues) {
                    if (this.entityIO.getIdGeneratorAttribute() != null) {
                        String msg = "Only one Id attribute is allowed to have generate and generator values";
                        this.entityIO.addProblem(msg, ((AnnotationEx)id).getLocation(null));
                    } else {
                        this.entityIO.setIdGeneratorAttribute(this.amd);
                        emd.setIdGeneratorType(this.getGeneratorTypeCode(id.generate()));
                        emd.setIdGeneratorName(id.generator());
                    }
                }
                this.updateModelSetPrimaryKey(true);
                if (version != null) {
                    this.entityIO.addProblem("A primary key (Id) attribute may not also be a Version attribute", ((AnnotationEx)version).getLocation(null));
                    version = null;
                }
                relativePositionInTable += mm.getColumnPositionPrimaryKey();
            } else {
                this.updateModelSetPrimaryKey(false);
            }
            if (version != null) {
                if (!this.amd.isVersion()) {
                    emd.getVersionList().add((Object)this.amd);
                }
                relativePositionInTable += mm.getColumnPositionVersion();
            } else if (this.amd.isVersion()) {
                emd.getVersionList().remove((Object)this.amd);
            }
        } else {
            String msg;
            if (id != null) {
                msg = emd.isEntity() ? "Subclasses may not have Id attributes" : String.valueOf(this.getTypeName(emd)) + " may not have Id attributes";
                this.entityIO.addProblem(msg, (Annotation)id);
            }
            if (version != null) {
                msg = emd.isEntity() ? "Subclasses may not have Version attributes" : String.valueOf(this.getTypeName(emd)) + " may not have Version attributes";
                this.entityIO.addProblem(msg, (Annotation)version);
            }
            this.updateModelSetPrimaryKey(false);
            if (this.amd.isVersion()) {
                emd.getVersionList().remove((Object)this.amd);
            }
        }
        ormCol.setRelativePositionInTable(relativePositionInTable);
        return true;
    }

    protected void updateModelCleanup() {
        OrmColumn c = this.amd.getColumn();
        if (c != null) {
            c.delete();
            this.amd.setColumn(null);
        }
        EntityMetaData emd = this.entityIO.getEntityMetaData();
        if (this.amd.isPrimaryKey()) {
            emd.getPrimaryKeyList().remove((Object)this.amd);
        }
        if (this.amd.isVersion()) {
            emd.getVersionList().remove((Object)this.amd);
        }
    }

    protected void updateModelSetPrimaryKey(boolean on) {
        EntityMetaData emd = this.entityIO.getEntityMetaData();
        OrmColumn ormCol = this.amd.getColumn();
        if (on) {
            if (!this.amd.isPrimaryKey()) {
                emd.getPrimaryKeyList().add((Object)this.amd);
            }
            if (!ormCol.isPrimaryKey()) {
                ormCol.getTable().getPrimaryKeyList().add((Object)ormCol);
            }
            ormCol.setIdentity(this.getModelManager().isUsingIdentityColumns(emd));
        } else {
            if (this.amd.isPrimaryKey()) {
                emd.getPrimaryKeyList().remove((Object)this.amd);
            }
            if (ormCol != null) {
                if (ormCol.isPrimaryKey()) {
                    emd.getTable().getPrimaryKeyList().remove((Object)ormCol);
                }
                if (ormCol.isIdentity()) {
                    ormCol.setIdentity(false);
                }
            }
        }
    }

    protected int getGeneratorTypeCode(GeneratorType t) {
        switch (t) {
            case NONE: {
                return 1;
            }
            case AUTO: {
                return 5;
            }
            case IDENTITY: {
                return 4;
            }
            case SEQUENCE: {
                return 3;
            }
            case TABLE: {
                return 2;
            }
        }
        return 1;
    }

    protected GeneratorType getGeneratorType(int code) {
        switch (code) {
            case 1: {
                return GeneratorType.NONE;
            }
            case 5: {
                return GeneratorType.AUTO;
            }
            case 4: {
                return GeneratorType.IDENTITY;
            }
            case 3: {
                return GeneratorType.SEQUENCE;
            }
            case 2: {
                return GeneratorType.TABLE;
            }
        }
        return GeneratorType.NONE;
    }

    protected OrmColumn getDefaultColumn() {
        TypeMetaData tmd = this.amd.getJavaType();
        if (tmd instanceof SimpleTypeMetaData) {
            return ((SimpleTypeMetaData)tmd).getColumn();
        }
        return null;
    }

    protected AnnotationEx getBasicAnnotation(RAnnotatedElement attribute, OrmColumn dc) {
        AnnotationEx basic = (AnnotationEx)attribute.getAnnotation(Basic.class, true);
        if (dc != null) {
            basic.setDefault("optional", dc.isNullable());
        }
        return basic;
    }

    protected AnnotationEx getColumnAnnotation(RAnnotatedElement attribute, OrmColumn dc) {
        AnnotationEx column = (AnnotationEx)attribute.getAnnotation(Column.class, true);
        column.setDefault("name", this.entityIO.getModelManager().getDefaultColumnName(this.amd));
        column.setDefault("nullable", this.amd.isOptional());
        if (dc != null) {
            column.setDefault("jdbcType", dc.getJdbcType());
            column.setDefault("length", dc.getLength());
            column.setDefault("precision", dc.getLength());
            column.setDefault("scale", dc.getScale());
        }
        return column;
    }

    public void updateMetaDataFromModel(RClass cls, RAnnotatedElement attribute) {
        GenericEntityModelManager mm = this.getModelManager();
        if (this.amd.isNonPersistent()) {
            Utils.removeAnnotation(attribute, Basic.class);
            Utils.removeAnnotation(attribute, Column.class);
            Utils.removeAnnotation(attribute, Version.class);
            Utils.removeAnnotation(attribute, Id.class);
            this.ensureTransient(attribute);
            return;
        }
        Utils.removeAnnotation(attribute, Transient.class);
        if (this.amd.getJavaType() == null) {
            return;
        }
        OrmColumn dc = this.getDefaultColumn();
        AnnotationEx basic = this.getBasicAnnotation(attribute, dc);
        Utils.setIfNotNull(basic, "fetch", this.getFetchType((AttributeMetaData)this.amd));
        basic.set("optional", this.amd.isOptional());
        basic.setMarker(mm.isUseMarkerAnnotations());
        OrmColumn oc = this.amd.getColumn();
        if (oc == null) {
            return;
        }
        AnnotationEx column = this.getColumnAnnotation(attribute, dc);
        column.set("jdbcType", oc.getJdbcType());
        column.set("insertable", oc.isInsertable());
        if (mm.getVendorDef().isNumericType(oc.getJdbcType())) {
            column.set("precision", oc.getLength());
            column.set("length", null);
        } else {
            column.set("length", oc.getLength());
            column.set("precision", null);
        }
        column.set("name", oc.getName(), true);
        oc.setName(((Column)column).name());
        column.set("nullable", oc.isNullable());
        column.set("scale", oc.getScale());
        column.set("updatable", oc.isUpdatable());
        boolean colDefChanged = !oc.getColumnDefinition().equals(oc.getOriginalColumnDefinition());
        String stdColDef = mm.getColumnDefinition(oc);
        if (colDefChanged) {
            column.setDefault("columnDefinition", stdColDef);
            column.set("columnDefinition", oc.getColumnDefinition(), true);
        }
        if (!column.hasValue("columnDefinition")) {
            oc.setColumnDefinition(stdColDef);
        }
        oc.setOriginalColumnDefinition(oc.getColumnDefinition());
        boolean primaryKey = this.amd.isPrimaryKey();
        AnnotationEx id = (AnnotationEx)attribute.getAnnotation(Id.class, primaryKey);
        if (primaryKey) {
            EntityMetaData emd = this.entityIO.getEntityMetaData();
            BasicAttribute ida = this.entityIO.getIdGeneratorAttribute();
            if (ida == null || ida == this.amd) {
                id.set("generate", this.getGeneratorType(emd.getIdGeneratorType()));
                id.set("generator", emd.getIdGeneratorName());
                if (ida == null) {
                    this.entityIO.setIdGeneratorAttribute(this.amd);
                }
            } else {
                id.set("generate", null);
                id.set("generator", null);
            }
            id.setMarker(true);
        } else if (id != null) {
            id.delete();
        }
        boolean isVersion = this.amd.isVersion();
        AnnotationEx version = (AnnotationEx)attribute.getAnnotation(Version.class, isVersion);
        if (isVersion) {
            version.setMarker(true);
        } else if (version != null) {
            version.delete();
        }
        mm.updateDatabaseType(oc);
    }
}

