/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.generic.io.ast;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;

public class ImportListHelper {
    protected final CompilationUnit root;
    protected final Set<String> importedNames = new HashSet<String>();

    public ImportListHelper(CompilationUnit root) {
        this.root = root;
        for (ImportDeclaration imp : root.imports()) {
            String name = imp.getName().getFullyQualifiedName();
            this.importedNames.add(name);
        }
    }

    public CompilationUnit getRoot() {
        return this.root;
    }

    public void ensureImport(String className) {
        if (this.importedNames.contains(className)) {
            return;
        }
        AST ast = this.root.getAST();
        ImportDeclaration newImp = ast.newImportDeclaration();
        newImp.setName(ast.newName(className));
        this.root.imports().add(newImp);
    }
}

