/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.ui.internal.mapping;

import java.util.ArrayList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jsr220orm.metadata.AttributeMetaData;
import org.eclipse.jsr220orm.metadata.BasicAttribute;
import org.eclipse.jsr220orm.metadata.CollectionAttribute;
import org.eclipse.jsr220orm.metadata.EmbeddedAttribute;
import org.eclipse.jsr220orm.metadata.ReferenceAttribute;
import org.eclipse.jsr220orm.metadata.provider.MetadataItemProviderAdapterFactory;
import org.eclipse.jsr220orm.ui.internal.mapping.composite.AttributeComposite;
import org.eclipse.jsr220orm.ui.internal.mapping.composite.AttributeMappingGroup;
import org.eclipse.jsr220orm.ui.internal.mapping.composite.BasicAttributeComposite;
import org.eclipse.jsr220orm.ui.internal.mapping.composite.CollectionAttributeComposite;
import org.eclipse.jsr220orm.ui.internal.mapping.composite.EmbeddedAttributeComposite;
import org.eclipse.jsr220orm.ui.internal.mapping.composite.ReferenceAttributeComposite;
import org.eclipse.jsr220orm.ui.internal.views.provider.OutlineLabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.PageBook;

public class AttributeBook {
    private Form mainForm;
    private Form blankPage;
    private Section section;
    private AttributeMetaData attributeMetaData;
    private AttributeMappingGroup mappingGroup = new AttributeMappingGroup(this);
    private PageBook attributeBook;
    private FormToolkit toolkit;
    private ComposedAdapterFactory adapterFactory;
    private OutlineLabelProvider labelProvider;
    private AttributeComposite defaultPage;
    private BasicAttributeComposite basicAttributeComposite;
    private ReferenceAttributeComposite referenceAttributeComposite;
    private CollectionAttributeComposite collectionAttributeComposite;
    private EmbeddedAttributeComposite embeddedAttributeComposite;

    public AttributeBook() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new MetadataItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        this.adapterFactory = new ComposedAdapterFactory(factories);
        this.labelProvider = new OutlineLabelProvider(this.adapterFactory);
    }

    public void createPartControl(Composite parent, FormToolkit toolkit) {
        this.toolkit = toolkit;
        this.mainForm = toolkit.createForm(parent);
        this.mainForm.setLayoutData((Object)new GridData(1808));
        this.mainForm.getBody().setLayout((Layout)new GridLayout());
        this.section = toolkit.createSection(this.mainForm.getBody(), 256);
        this.section.setLayoutData((Object)new GridData(1808));
        Form form = toolkit.createForm((Composite)this.section);
        form.setLayoutData((Object)new GridData(1808));
        this.section.setClient((Control)form);
        GridLayout thisLayout = new GridLayout();
        form.getBody().setLayout((Layout)thisLayout);
        this.mappingGroup.createControl(form.getBody(), toolkit);
        GridData mappingGroupLData = new GridData();
        mappingGroupLData.grabExcessHorizontalSpace = true;
        mappingGroupLData.horizontalAlignment = 4;
        this.mappingGroup.getComposite().setLayoutData((Object)mappingGroupLData);
        this.attributeBook = new PageBook(form.getBody(), 0);
        this.attributeBook.setLayoutData((Object)new GridData(1808));
        form.getBody().layout();
    }

    public AttributeMetaData getAttributeMetaData() {
        return this.attributeMetaData;
    }

    public void setAttributeMetaData(AttributeMetaData attributeMetaData) {
        this.attributeMetaData = attributeMetaData;
        this.section.setText(this.labelProvider.getText(attributeMetaData));
        this.mappingGroup.setMetaDataElement(attributeMetaData);
        this.attributeBook.showPage(this.getAttributeTab(attributeMetaData));
        this.section.layout();
    }

    protected Control getAttributeTab(AttributeMetaData attributeMetaData) {
        if (attributeMetaData.isNonPersistent()) {
            return this.getBlankPage();
        }
        if (attributeMetaData instanceof BasicAttribute) {
            return this.getBasicAttributeComposite(attributeMetaData);
        }
        if (attributeMetaData instanceof ReferenceAttribute) {
            return this.getReferenceAttributeComposite(attributeMetaData);
        }
        if (attributeMetaData instanceof CollectionAttribute) {
            return this.getCollectionAttributeComposite(attributeMetaData);
        }
        if (attributeMetaData instanceof EmbeddedAttribute) {
            return this.getEmbeddedAttributeComposite(attributeMetaData);
        }
        return this.getDefaultPage(attributeMetaData);
    }

    private Control getBlankPage() {
        if (this.blankPage == null) {
            this.blankPage = this.toolkit.createForm((Composite)this.attributeBook);
        }
        return this.blankPage;
    }

    private Control getBasicAttributeComposite(AttributeMetaData attributeMetaData) {
        if (this.basicAttributeComposite == null) {
            this.basicAttributeComposite = new BasicAttributeComposite();
            this.basicAttributeComposite.createComposite((Composite)this.attributeBook, this.toolkit, (AdapterFactory)this.adapterFactory);
        }
        this.basicAttributeComposite.setAttributeMetaData(attributeMetaData);
        return this.basicAttributeComposite.getComposite();
    }

    private Control getReferenceAttributeComposite(AttributeMetaData attributeMetaData) {
        if (this.referenceAttributeComposite == null) {
            this.referenceAttributeComposite = new ReferenceAttributeComposite();
            this.referenceAttributeComposite.createComposite((Composite)this.attributeBook, this.toolkit, (AdapterFactory)this.adapterFactory);
        }
        this.referenceAttributeComposite.setAttributeMetaData(attributeMetaData);
        return this.referenceAttributeComposite.getComposite();
    }

    private Control getCollectionAttributeComposite(AttributeMetaData attributeMetaData) {
        if (this.collectionAttributeComposite == null) {
            this.collectionAttributeComposite = new CollectionAttributeComposite();
            this.collectionAttributeComposite.createComposite((Composite)this.attributeBook, this.toolkit, this.adapterFactory);
        }
        this.collectionAttributeComposite.setAttributeMetaData(attributeMetaData);
        return this.collectionAttributeComposite.getComposite();
    }

    private Control getEmbeddedAttributeComposite(AttributeMetaData attributeMetaData) {
        if (this.embeddedAttributeComposite == null) {
            this.embeddedAttributeComposite = new EmbeddedAttributeComposite();
            this.embeddedAttributeComposite.createComposite((Composite)this.attributeBook, this.toolkit, (AdapterFactory)this.adapterFactory);
        }
        this.embeddedAttributeComposite.setAttributeMetaData(attributeMetaData);
        return this.embeddedAttributeComposite.getComposite();
    }

    protected Control getDefaultPage(AttributeMetaData attributeMetaData) {
        if (this.defaultPage == null) {
            this.defaultPage = this.createDefaultPage();
        }
        this.defaultPage.setAttributeMetaData(attributeMetaData);
        return this.defaultPage.getComposite();
    }

    protected AttributeComposite createDefaultPage() {
        AttributeComposite attributeComposite = new AttributeComposite();
        attributeComposite.createComposite((Composite)this.attributeBook, this.toolkit, (AdapterFactory)this.adapterFactory);
        return attributeComposite;
    }

    public Control getControl() {
        return this.mainForm;
    }
}

