/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.ui.internal.mapping;

import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.ui.internal.mapping.composite.EntityComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.PageBook;

public class EntityBook {
    private EntityMetaData entityMetaData;
    private Form mainForm;
    private PageBook entityBook;
    private EntityComposite defaultPage;
    private FormToolkit toolkit;
    private Section section;

    public void createPartControl(Composite parent, FormToolkit toolkit) {
        this.toolkit = toolkit;
        this.mainForm = toolkit.createForm(parent);
        this.mainForm.getBody().setLayout((Layout)new GridLayout());
        this.section = toolkit.createSection(this.mainForm.getBody(), 256);
        this.section.setText("Entity properties");
        this.section.setLayoutData((Object)new GridData(1808));
        ScrolledForm scrolledForm = new ScrolledForm((Composite)this.section, 512);
        scrolledForm.setExpandHorizontal(true);
        scrolledForm.setExpandVertical(true);
        scrolledForm.setMinWidth(0);
        toolkit.adapt((Composite)scrolledForm);
        Composite composite = scrolledForm.getBody();
        this.section.setClient((Control)scrolledForm);
        composite.setLayout((Layout)new GridLayout());
        this.entityBook = new PageBook(composite, 0);
        this.entityBook.setLayoutData((Object)new GridData(1808));
        this.mainForm.getBody().layout();
    }

    public Composite getComposite() {
        return this.mainForm;
    }

    public EntityMetaData getEntityMetaData() {
        return this.entityMetaData;
    }

    public void setEntityMetaData(EntityMetaData entityMetaData) {
        this.entityMetaData = entityMetaData;
        this.entityBook.showPage(this.getEntityTab(entityMetaData));
        this.section.setText(entityMetaData.getClassName());
        this.section.layout();
        this.mainForm.layout();
    }

    private String getTile(EntityMetaData entityMetaData) {
        String schemaName = entityMetaData.getSchemaName();
        return schemaName != null ? schemaName : entityMetaData.getClassName();
    }

    protected Control getEntityTab(EntityMetaData entityMetaData) {
        return this.getDefualtPage(entityMetaData);
    }

    protected Control getDefualtPage(EntityMetaData entityMetaData) {
        if (this.defaultPage == null) {
            this.defaultPage = this.createDefaultPage();
        }
        this.defaultPage.setEntityMetaData(entityMetaData);
        return this.defaultPage.getComposite();
    }

    protected EntityComposite createDefaultPage() {
        EntityComposite entityComposite = new EntityComposite();
        entityComposite.createComposite((Composite)this.entityBook, this.toolkit);
        return entityComposite;
    }
}

