/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.core.internal.ddl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.jsr220orm.core.IEntityModelManager;
import org.eclipse.jsr220orm.core.internal.ddl.TableComparator;
import org.eclipse.jsr220orm.core.util.RdbUtils;
import org.eclipse.jsr220orm.metadata.EntityModel;
import org.eclipse.jsr220orm.metadata.OrmColumn;
import org.eclipse.jsr220orm.metadata.OrmTable;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLSchemaFactory;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;
import org.eclipse.wst.rdb.internal.models.sql.schema.impl.SQLSchemaFactoryImpl;
import org.eclipse.wst.rdb.internal.models.sql.tables.BaseTable;
import org.eclipse.wst.rdb.internal.models.sql.tables.Column;
import org.eclipse.wst.rdb.internal.models.sql.tables.SQLTablesFactory;
import org.eclipse.wst.rdb.internal.models.sql.tables.SQLTablesPackage;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;

public class DdlGenerator {
    private EntityModel model;
    private Database database;
    private Schema defaultSchema;
    private TableComparator tableComparator = new TableComparator();
    private DatabaseDefinition dbDef;
    private HashMap schemaMap = new HashMap();
    private HashMap tableMap = new HashMap();
    private IEntityModelManager modelManager;

    public DdlGenerator(EntityModel model, Database database, Schema defaultSchema) {
        this.model = model;
        this.database = database;
        this.defaultSchema = defaultSchema;
        this.dbDef = RdbUtils.getDatabaseDefinitionRegistry().getDefinition(database);
    }

    public DdlGenerator(IEntityModelManager modelManager, DatabaseDefinition dbDef) {
        this.modelManager = modelManager;
        this.model = modelManager.getEntityModel();
        this.dbDef = dbDef;
        this.database = SQLSchemaFactoryImpl.eINSTANCE.createDatabase();
        this.database.setVendor(dbDef.getProduct());
        this.database.setVersion(dbDef.getVersion());
        this.defaultSchema = SQLSchemaFactoryImpl.eINSTANCE.createSchema();
        this.database.getSchemas().add((Object)this.defaultSchema);
    }

    public List getCreateDDL() {
        this.loadFromModel();
        ArrayList tables = new ArrayList(this.tableMap.values());
        Collections.sort(tables, this.tableComparator);
        return tables;
    }

    private List getMigrateDDL() {
        this.loadFromDatabase();
        return this.getCreateDDL();
    }

    private void loadFromModel() {
        Set sqlObjects;
        if (this.modelManager != null && (sqlObjects = this.modelManager.getExtraSqlObjects()) != null) {
            for (Object sqlObj : sqlObjects) {
                if (!(sqlObj instanceof OrmTable)) continue;
                this.addOrmTable((OrmTable)sqlObj);
            }
        }
        if (this.model == null) {
            return;
        }
        sqlObjects = this.model.getTopLevelSqlObjects();
        for (Object sqlObj : sqlObjects) {
            if (!(sqlObj instanceof OrmTable)) continue;
            this.addOrmTable((OrmTable)sqlObj);
        }
    }

    private void addOrmTable(OrmTable ormTable) {
        String tableName;
        Table table;
        ormTable.getCatalog();
        String schemaName = ormTable.getSchema();
        Schema schema = schemaName == null || schemaName.trim().length() == 0 ? this.defaultSchema : (Schema)this.schemaMap.get(schemaName);
        if (schema == null) {
            schema = SQLSchemaFactory.eINSTANCE.createSchema();
            schema.setName(schemaName);
            this.schemaMap.put(schemaName, schema);
            this.database.getSchemas().add((Object)schema);
        }
        if ((table = (Table)this.tableMap.get(tableName = ormTable.getName())) == null) {
            table = (Table)this.dbDef.getDataModelElementFactory().create(SQLTablesPackage.eINSTANCE.getPersistentTable());
            table.setName(tableName);
            this.tableMap.put(tableName, table);
            table.setSchema(schema);
        }
        for (OrmColumn ormCol : ormTable.getColumnList()) {
            Column rdbCol = this.getRdbColumn(table, ormCol);
            RdbUtils.copyToRdb(ormCol, rdbCol, this.dbDef);
        }
        RdbUtils.copyToRdb(ormTable, (BaseTable)table, this.dbDef);
    }

    private Column getRdbColumn(Table table, OrmColumn ormCol) {
        for (Column rdbCol : table.getColumns()) {
            if (!rdbCol.getName().equals(ormCol.getName())) continue;
            return rdbCol;
        }
        Column rdbCol = SQLTablesFactory.eINSTANCE.createColumn();
        table.getColumns().add((Object)rdbCol);
        return rdbCol;
    }

    private void loadFromDatabase() {
    }
}

