/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.core.nature;

import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jsr220orm.core.IEntityModelManager;
import org.eclipse.jsr220orm.core.OrmPlugin;
import org.eclipse.jsr220orm.core.internal.adaptors.RdbConnectionInfoFactory;
import org.eclipse.jsr220orm.core.internal.adaptors.RdbSchemaFactory;
import org.eclipse.jsr220orm.core.internal.options.OptionsDescriptor;
import org.eclipse.jsr220orm.core.internal.product.OrmProduct;
import org.eclipse.jsr220orm.core.internal.product.OrmProductRegistry;
import org.eclipse.jsr220orm.core.internal.product.OrmProject;
import org.eclipse.jsr220orm.core.nature.OrmNatureEvent;
import org.eclipse.jsr220orm.core.nature.OrmNatureListener;
import org.eclipse.jsr220orm.core.nature.OrmNatureUtils;
import org.eclipse.jsr220orm.core.nature.PersistenceProperties;
import org.eclipse.jsr220orm.core.options.IOptionsDescriptor;
import org.eclipse.jsr220orm.core.util.RdbUtils;
import org.eclipse.jsr220orm.metadata.EntityModel;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.shared.UserIdentification;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinitionRegistry;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogProvider;
import org.eclipse.wst.rdb.internal.core.util.DatabaseProviderHelper;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;
import org.osgi.framework.Bundle;

public class OrmNature
extends PlatformObject
implements IProjectNature,
IAdaptable,
IResourceChangeListener {
    public static final String ID = "org.eclipse.jsr220orm.core.nature";
    private static final QualifiedName PERSISTENCE_PRODUCT_ID = new QualifiedName("OrmPersistence", "product_id");
    private PersistenceProperties persistenceProperties;
    private OrmProject activeProject;
    private IProject project;
    private List natureListeners = new ArrayList(5);
    private boolean internalSave;
    private Job reLoadActiveProjectJob = new Job("reLoadActiveProject"){

        protected IStatus run(IProgressMonitor monitor) {
            try {
                if (OrmNature.this.project.isOpen() && OrmNature.this.activeProject != null) {
                    OrmNature.this.persistenceProperties.reload(OrmNature.this.project);
                    OrmNature.this.loadActiveProject();
                }
            }
            catch (Exception x) {
                OrmPlugin.log(x);
                return new Status(4, "org.eclipse.jsr220orm.core", 0, "Problem refreshing persistence.", (Throwable)x);
            }
            return new Status(0, "org.eclipse.jsr220orm.core", 0, "", null);
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public OrmNature() {
        this.reLoadActiveProjectJob.setPriority(30);
    }

    public void configure() throws CoreException {
    }

    public void deconfigure() throws CoreException {
        this.closeProject();
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
        try {
            this.persistenceProperties = new PersistenceProperties(project);
            this.persistenceProperties.reload(project);
        }
        catch (Exception e) {
            OrmPlugin.log("Error reading .persistence file.", "Error reading .persistence file form project: " + project.getName(), e, 4);
        }
        try {
            this.loadActiveProject();
        }
        catch (CoreException e) {
            OrmPlugin.log("Error activating persistence nature", "An unexpected error occured activeting the persistence nature form project: " + project.getName(), e.getStatus());
        }
        catch (Throwable e) {
            OrmPlugin.log("An unexpected error occured activeting the persistence nature form project: " + project.getName(), e);
        }
    }

    void loadActiveProject() throws CoreException {
        this.closeProject();
        this.activeProject = this.createOrmProject(this.persistenceProperties.getPersistenceProduct());
        if (this.activeProject != null) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 3);
            this.project.setSessionProperty(PERSISTENCE_PRODUCT_ID, (Object)this.activeProject.getProduct().getId());
            this.activeProject.getModel().registerAdapterFactory((IAdapterFactory)new RdbConnectionInfoFactory(this));
            this.activeProject.getModel().registerAdapterFactory((IAdapterFactory)new RdbSchemaFactory(this));
        } else {
            this.project.setSessionProperty(PERSISTENCE_PRODUCT_ID, null);
        }
        this.fireProjectActivated(this.activeProject);
    }

    public OrmProject getActiveOrmProject() {
        return this.activeProject;
    }

    public PersistenceProperties getPersistenceProperties() {
        return this.persistenceProperties;
    }

    public void savePersistenceProperties() throws IOException, CoreException {
        this.persistenceProperties.save();
    }

    public OrmProject createOrmProject(String productKey) throws CoreException {
        IEntityModelManager entityModelManager;
        Class clazz;
        OrmProject ormProject;
        if (productKey == null) {
            return null;
        }
        OrmProduct ormProduct = OrmProductRegistry.INSTANCE.getOrmProductById(productKey);
        if (ormProduct == null) {
            return null;
        }
        this.persistenceProperties.getProperties().putAll((Map<?, ?>)ormProduct.getProperties());
        this.activeProject = ormProject = new OrmProject();
        ormProject.setIProject(this.project);
        ormProject.setProduct(ormProduct);
        try {
            Bundle bundle = Platform.getBundle((String)ormProduct.getNamespace());
            clazz = bundle.loadClass(ormProduct.getEntityModelManager());
        }
        catch (ClassNotFoundException e) {
            String message = ormProduct + " has it's 'entityModelManager' property set to '" + ormProduct.getEntityModelManager() + "' but this class could not be found.";
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jsr220orm.core", 0, message, (Throwable)e));
        }
        if (!IEntityModelManager.class.isAssignableFrom(clazz)) {
            String message = ormProduct + " has it's 'entityModelManager' property set to '" + ormProduct.getEntityModelManager() + "' but this class this class does " + "not implement org.eclipse.jsr220orm.core.IEntityModelManager.";
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jsr220orm.core", 0, message, (Throwable)new Exception("Invalid IEntityModelFactory.")));
        }
        try {
            entityModelManager = (IEntityModelManager)clazz.newInstance();
        }
        catch (Throwable e) {
            String message = ormProduct + " has it's 'entityModelManager' property set to '" + ormProduct.getEntityModelManager() + "' but this class could not be instantiated.";
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jsr220orm.core", 0, message, e));
        }
        DatabaseDefinition databaseDefinition = null;
        try {
            databaseDefinition = this.getDatabaseDefinition();
            entityModelManager.setDatabaseDefinition(databaseDefinition);
        }
        catch (Throwable e) {
            OrmPlugin.log("Could not load database definition for " + this.getDatabaseName(), e);
        }
        try {
            ormProject.setModelManager(entityModelManager);
            entityModelManager.init(this.project, this, databaseDefinition);
        }
        catch (Throwable e) {
            entityModelManager.dispose();
            String message = String.valueOf(ormProduct.getEntityModelManager()) + "for product: " + ormProduct + " could not be initialized:";
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jsr220orm.core", 0, message, e));
        }
        try {
            EntityModel entityModel = entityModelManager.getEntityModel();
            entityModel.registerAdapterFactory(new IAdapterFactory(){
                OptionsDescriptor descriptor = new OptionsDescriptor();

                public Class[] getAdapterList() {
                    return new Class[]{IOptionsDescriptor.class, IProject.class, IEntityModelManager.class};
                }

                public Object getAdapter(Object adaptableObject, Class adapterType) {
                    if (IProject.class.equals((Object)adapterType)) {
                        return OrmNature.this.project;
                    }
                    if (IOptionsDescriptor.class.equals((Object)adapterType)) {
                        return this.descriptor;
                    }
                    if (IEntityModelManager.class.equals((Object)adapterType)) {
                        return entityModelManager;
                    }
                    return null;
                }
            });
            ormProject.setModel(entityModel);
        }
        catch (Throwable e) {
            entityModelManager.dispose();
            String message = ormProduct + " could not create a entity mapping for project '" + this.project.getName() + "'.";
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jsr220orm.core", 0, message, e));
        }
        return ormProject;
    }

    public void addOrmNatureListener(OrmNatureListener listener) {
        this.natureListeners.add(listener);
    }

    public void removeOrmNatureListener(OrmNatureListener listener) {
        this.natureListeners.remove(listener);
    }

    void closeProject() throws CoreException {
        OrmProject oldProject = this.activeProject;
        this.activeProject = null;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        if (this.project.isOpen() && !ResourcesPlugin.getWorkspace().isTreeLocked()) {
            this.project.setSessionProperty(PERSISTENCE_PRODUCT_ID, null);
        }
        if (oldProject == null) {
            return;
        }
        oldProject.dispose();
        this.fireProjectDeactivated(oldProject);
    }

    public ConnectionInfo getActiveConnectionInfo() {
        String rdbConnName = this.persistenceProperties.getConnectionName();
        if (rdbConnName != null) {
            ConnectionInfo[] rdbConnections = RdbUtils.getRdbConnections();
            int x = rdbConnections.length - 1;
            while (x >= 0) {
                if (rdbConnName.equals(rdbConnections[x].getName())) {
                    return rdbConnections[x];
                }
                --x;
            }
        }
        return null;
    }

    public String getDatabaseName() {
        String database = this.persistenceProperties.getDatabaseName();
        DatabaseDefinitionRegistry ddr = RdbUtils.getDatabaseDefinitionRegistry();
        if (database == null || !ddr.getVersions(database).hasNext()) {
            Iterator products = ddr.getProducts();
            String product = null;
            String[] defaults = new String[]{"MySql", "Oracle", "Derby", "SQL Server", "Sybase"};
            int index = defaults.length;
            while (products.hasNext()) {
                String prodName = (String)products.next();
                if (prodName == null || prodName.trim().length() == 0) continue;
                int x = 0;
                while (x < index) {
                    if (prodName.equals(defaults[x])) {
                        index = x;
                        product = prodName;
                    }
                    ++x;
                }
            }
            if (product == null) {
                product = (String)ddr.getProducts().next();
            }
            return product;
        }
        return database;
    }

    public String getDatabaseVersion() {
        String database = this.getDatabaseName();
        String version = this.persistenceProperties.getDatabaseVersion();
        DatabaseDefinitionRegistry ddr = RdbUtils.getDatabaseDefinitionRegistry();
        Iterator versions = ddr.getVersions(database);
        String newVersion = version;
        while (versions.hasNext()) {
            String tempVersion = (String)versions.next();
            if (tempVersion == null || tempVersion.trim().length() == 0) continue;
            if (tempVersion.equals(version)) {
                return version;
            }
            newVersion = tempVersion;
        }
        return newVersion;
    }

    public DatabaseDefinition getDatabaseDefinition() {
        String product = this.getDatabaseName();
        String version = this.getDatabaseVersion();
        DatabaseDefinitionRegistry ddr = RdbUtils.getDatabaseDefinitionRegistry();
        return ddr.getDefinition(product, version);
    }

    public Database getActiveDatabase() throws Exception {
        String us = this.persistenceProperties.getConnectionUserName();
        String pa = this.persistenceProperties.getConnectionPassword();
        ConnectionInfo activeConnectionInfo = this.getActiveConnectionInfo();
        if (activeConnectionInfo == null) {
            return null;
        }
        return OrmNature.getCatalogDatabase(this, activeConnectionInfo, us, pa);
    }

    public Schema getActiveSchema() {
        String schemaName = this.persistenceProperties.getSchemaName();
        if (schemaName != null) {
            String us = this.persistenceProperties.getConnectionUserName();
            String pa = this.persistenceProperties.getConnectionPassword();
            List schemas = OrmNature.getSchemas(this, this.getActiveConnectionInfo(), us, pa);
            if (schemas != null) {
                for (Schema schema : schemas) {
                    if (!schemaName.equals(schema.getName())) continue;
                    return schema;
                }
            }
        }
        return null;
    }

    public static List getSchemas(OrmNature nature, ConnectionInfo info, String user, String pass) {
        if (info == null) {
            return Collections.EMPTY_LIST;
        }
        try {
            Database catalogDatabase = OrmNature.getCatalogDatabase(nature, info, user, pass);
            if (catalogDatabase != null) {
                return catalogDatabase.getSchemas();
            }
        }
        catch (Exception e) {
            OrmPlugin.log(null, "Could not connect to rdb connection: " + info.getName(), e, 2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Database getCatalogDatabase(OrmNature nature, ConnectionInfo info, String userName, String password) throws Exception {
        Database sharedDatabase = info.getSharedDatabase();
        if (sharedDatabase != null) {
            return sharedDatabase;
        }
        Connection connection = info.getSharedConnection();
        if (connection == null) {
            ConnectionInfo connectionInfo = info;
            synchronized (connectionInfo) {
                if (userName != null) {
                    info.setUserName(userName);
                }
                if (password != null) {
                    info.setPassword(password);
                }
                if (OrmNature.isPromptNeeded(info)) {
                    OrmNature.promptIDPW(info, "Please enter your login info to reconnect to " + info.getDatabaseName() + ".");
                    if (nature != null && !OrmNature.isPromptNeeded(info)) {
                        PersistenceProperties persistenceProperties = nature.getPersistenceProperties();
                        persistenceProperties.setConnectionUserName(info.getUserName());
                        persistenceProperties.setConnectionPassword(info.getPassword());
                        try {
                            nature.internalSave = true;
                            persistenceProperties.save();
                        }
                        finally {
                            nature.internalSave = false;
                        }
                    }
                }
                connection = info.connect();
                info.setSharedConnection(connection);
                info.saveConnectionInfo();
            }
        }
        new DatabaseProviderHelper().setDatabase(connection, info, info.getDatabaseName());
        sharedDatabase = info.getSharedDatabase();
        if (sharedDatabase == null) {
            ICatalogProvider catalogProvider = info.getDatabaseDefinition().getDatabaseCatalogProvider();
            sharedDatabase = catalogProvider.getCatalogDatabase(connection);
            sharedDatabase.setName(info.getName());
            if (sharedDatabase != null) {
                info.removeSharedDatabase();
                info.setSharedDatabase(sharedDatabase);
            }
        }
        return sharedDatabase;
    }

    private static boolean isPromptNeeded(ConnectionInfo connInfo) {
        String username = null;
        String password = null;
        if (connInfo != null) {
            username = connInfo.getUserName();
            password = connInfo.getPassword();
        }
        return username == null || username.trim().length() == 0 || password == null || password.trim().length() == 0;
    }

    private static synchronized boolean promptIDPW(ConnectionInfo connInfo, String promptMessage) {
        boolean ok = false;
        if (connInfo != null) {
            String username = connInfo.getUserName();
            if (username == null || username.length() == 0) {
                username = System.getProperty("user.name");
            }
            UserIdentification idDialog = new UserIdentification(username, promptMessage);
            idDialog.setBlockOnOpen(true);
            if (idDialog.open() == 0) {
                username = idDialog.getUserNameInformation();
                String password = idDialog.getPasswordInformation();
                connInfo.setUserName(username == null ? "" : username);
                connInfo.setPassword(password == null ? "" : password);
                ok = true;
                try {
                    connInfo.saveConnectionInfo();
                }
                catch (Exception exception) {
                    ok = false;
                }
            }
        }
        return ok;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        boolean propsChanged;
        boolean closing;
        if (this.internalSave) {
            return;
        }
        boolean bl = closing = event.getType() == 2;
        if (closing) {
            boolean isProject = this.project.equals((Object)event.getResource());
            if (isProject) {
                try {
                    this.closeProject();
                }
                catch (CoreException e) {
                    OrmPlugin.log(e);
                }
            }
            return;
        }
        IResourceDelta delta = event.getDelta();
        boolean bl2 = propsChanged = delta.findMember(this.project.getFile(".persistence").getFullPath()) != null;
        if (propsChanged && this.reLoadActiveProjectJob.getState() == 0) {
            this.reLoadActiveProjectJob.schedule(50L);
        }
    }

    public void fireNatureRemoved() {
        OrmNatureListener[] listeners = new OrmNatureListener[this.natureListeners.size()];
        this.natureListeners.toArray(listeners);
        OrmNatureEvent ormNatureEvent = new OrmNatureEvent(this, null);
        int x = listeners.length - 1;
        while (x >= 0) {
            listeners[x].ormNatureRemoved(ormNatureEvent);
            --x;
        }
        OrmNatureUtils.fireNatureRemoved(this);
    }

    public void fireProjectActivated(OrmProject activeProject) {
        OrmNatureListener[] listeners = new OrmNatureListener[this.natureListeners.size()];
        this.natureListeners.toArray(listeners);
        OrmNatureEvent ormNatureEvent = new OrmNatureEvent(this, activeProject);
        int x = listeners.length - 1;
        while (x >= 0) {
            listeners[x].projectActivated(ormNatureEvent);
            --x;
        }
        OrmNatureUtils.fireProjectActivated(this, activeProject);
    }

    public void fireProjectDeactivated(OrmProject activeProject) {
        OrmNatureListener[] listeners = new OrmNatureListener[this.natureListeners.size()];
        this.natureListeners.toArray(listeners);
        OrmNatureEvent ormNatureEvent = new OrmNatureEvent(this, activeProject);
        int x = listeners.length - 1;
        while (x >= 0) {
            listeners[x].projectDeactivated(ormNatureEvent);
            --x;
        }
        OrmNatureUtils.fireProjectDeactivated(this, activeProject);
    }
}

