/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.hibernate.internal.ui.config;

import java.io.File;
import java.io.IOException;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jsr220orm.core.nature.PersistenceProperties;
import org.eclipse.jsr220orm.generic.Utils;
import org.eclipse.jsr220orm.hibernate.HibernatePlugin;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class HibernateConfigComposite extends Composite {

    private Group gClassPath = null;
    private Button rAdd = null;
    private Button rNoAdd = null;
    private Label lHelp = null;
    private Label lHibernate = null;
    private Text tHibernate = null;
    private Button bHibernate = null;
//    private Label lAnnotations = null;
    private Label lEntitymanager = null;
//    private Text tAnnotations = null;
//    private Button bAnnotations = null;
    private Text tEntitymanager = null;
    private Button bEntitymanager = null;
    private IProject project;
    
    public HibernateConfigComposite(Composite parent, int style) {
        super(parent, style);
        initialize();
    }

    private void initialize() {
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
        gridData3.grabExcessHorizontalSpace = true;
        lHelp = new Label(this, SWT.WRAP);
        lHelp.setText("The Hibernate jar files can be added to you project classpath automaticaly or you can add them yourself.");
        lHelp.setLayoutData(gridData3);
        rAdd = new Button(this, SWT.RADIO);
        rAdd.setText("Add the Hibernate jar files to my project classpath");
        rAdd.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
            public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
                setAddClasspath(rAdd.getSelection());
            }
        });
        GridLayout gridLayout = new GridLayout();
        this.setLayout(gridLayout);
        this.setSize(new org.eclipse.swt.graphics.Point(448,320));
        rNoAdd = new Button(this, SWT.RADIO);
        rNoAdd.setText("No thanks, I'll set up my own classpath");
        rNoAdd.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
            public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
                setAddClasspath(!rNoAdd.getSelection());
            }
        });
        createGroup1();
    }

    private void setAddClasspath(boolean add){
        tHibernate.setEnabled(add);
        bHibernate.setEnabled(add);
//        tAnnotations.setEnabled(add);
//        bAnnotations.setEnabled(add);
        tEntitymanager.setEnabled(add);
        bEntitymanager.setEnabled(add);
    }
    
    /**
     * This method initializes group1	
     *
     */
    private void createGroup1() {
        GridData gridData4 = new GridData();
        gridData4.widthHint = 140;
        GridData gridData31 = new GridData();
        gridData31.widthHint = 140;
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
        gridData2.grabExcessHorizontalSpace = true;
        GridData gridData1 = new GridData();
        gridData1.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
        gridData1.grabExcessHorizontalSpace = true;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.numColumns = 3;
        GridData gridData6 = new GridData();
        gridData6.horizontalSpan = 4;
        gridData6.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
        gridData6.grabExcessHorizontalSpace = true;
        gClassPath = new Group(this, SWT.NONE);
        gClassPath.setText("Classpath");
        gClassPath.setLayout(gridLayout1);
        gClassPath.setLayoutData(gridData6);
        lHibernate = new Label(gClassPath, SWT.WRAP);
        lHibernate.setText("Hibernate 3.1 home");
        tHibernate = new Text(gClassPath, SWT.BORDER);
        tHibernate.setLayoutData(gridData);
        bHibernate = new Button(gClassPath, SWT.NONE);
        bHibernate.setText("Browse...");
        bHibernate.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
            public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
                chooseDir(tHibernate);
            }
        });
//        lAnnotations = new Label(gClassPath, SWT.WRAP);
//        lAnnotations.setText("Hibernate annotations home");
//        lAnnotations.setLayoutData(gridData4);
//        tAnnotations = new Text(gClassPath, SWT.BORDER);
//        tAnnotations.setLayoutData(gridData1);
//        bAnnotations = new Button(gClassPath, SWT.NONE);
//        bAnnotations.setText("Browse...");
//        bAnnotations
//                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
//                    public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
//                        chooseDir(tAnnotations);
//                    }
//                });
        lEntitymanager = new Label(gClassPath, SWT.WRAP);
        lEntitymanager.setText("Hibernate entitymanager home");
        lEntitymanager.setLayoutData(gridData31);
        tEntitymanager = new Text(gClassPath, SWT.BORDER);
        tEntitymanager.setLayoutData(gridData2);
        bEntitymanager = new Button(gClassPath, SWT.NONE);
        bEntitymanager.setText("Browse...");
        bEntitymanager
                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
                    public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
                        chooseDir(tEntitymanager);
                    }
                });
    }

    protected void chooseDir(Text text) {
        DirectoryDialog dialog = new DirectoryDialog(getShell(), SWT.SINGLE);
        String dirName = dialog.open();
        if(dirName != null){
            text.setText(dirName);
        }
    }

    public void setIProject(IProject project) throws CoreException, IOException{
        this.project = project;
        PersistenceProperties props = new PersistenceProperties(project);
        String addHibernatePath = props.getProperty("classpath.variable.name");
        boolean doAdd = "hibernatePath".equals(addHibernatePath);
        rAdd.setSelection(doAdd);
        rNoAdd.setSelection(!doAdd);
        setAddClasspath(doAdd);
        String hibernatePath = props.getProperty("hibernate.path");
        setText(tHibernate, hibernatePath);
//        String annotationsPath = props.getProperty("hibernate.annotations.path");
//        setText(tAnnotations, annotationsPath);
        String entitymanagerPath = props.getProperty("hibernate.entitymanager.path");
        setText(tEntitymanager, entitymanagerPath);
    }
    
    private void setText(Text text, String string) {
        if(string == null){
            string = "";
        }
        text.setText(string);
    }

    public boolean saveChanges() {
        PersistenceProperties props;
        try {
            props = new PersistenceProperties(project);
            props.setProperty("hibernate.path", tHibernate.getText());
//            props.setProperty("hibernate.annotations.path", tAnnotations.getText());
            props.setProperty("hibernate.entitymanager.path", tEntitymanager.getText());
            props.setProperty("classpath.variable.name", rAdd.getSelection() ? "hibernatePath" : null);
        } catch (Exception e) {
            HibernatePlugin.logException(e);
            return false;
        }
        return true;
    }

    public String canFinish() {
        if(rAdd.getSelection()){
            String hibernatePath = tHibernate.getText();
            String ret = isPathOK(hibernatePath, lHibernate.getText());
            if(ret != null){
                return ret;
            }
//            String annotationsPath = tAnnotations.getText();
//            ret = isPathOK(annotationsPath, lAnnotations.getText());
//            if(ret != null){
//                return ret;
//            }
            String entitymanagerPath = tEntitymanager.getText();
            ret = isPathOK(entitymanagerPath, lEntitymanager.getText());
            if(ret != null){
                return ret;
            }
        }else{
            try {
                Utils.removeCpVarFrom(JavaCore.create(project), "hibernatePath");
            } catch (JavaModelException e) {
                // Do Nothing
            }
        }
        return null;
    }

    private String isPathOK(String path, String name){
        if(path == null || path.trim().length() == 0){
            return "Please supply "+name;
        }
        File file = new File(path);
        if(!file.exists()){
            return path+" does not exist.";
        }
        return null;
    }
}  //  @jve:decl-index=0:visual-constraint="10,10"
