/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.metadata;

/**
 * Base class for persistent types. These include simple Java types like int and
 * String as well as persistent entities.
 * 
 * @model
 * @generated
 */
public interface TypeMetaData extends MetadataElement{

	/**
	 * Return the EntityModel that we belong to. It is bidirectional and its
	 * opposite is '{@link org.eclipse.jsr220orm.metadata.EntityModel#getTypeList <em>Type List</em>}'.
	 * 
	 * @model opposite="typeList"
	 * @generated
	 */
	EntityModel getEntityModel();

	/**
	 * @generated
	 */
	void setEntityModel(EntityModel value);

	/**
	 * Get the fully qualified name of our Java class e.g. int,
	 * java.lang.Integer, com.acme.erp.model.Account.
	 * 
	 * @see #getCls()
	 * 
	 * @model
	 * @generated
	 */
	String getClassName();

	/**
	 * @generated
	 */
	void setClassName(String value);

	/**
	 * Our Java class.
	 * 
	 * @see #getClassName()
	 * 
	 * @model
	 * @generated
	 */
	Class getCls();

	void setCls(Class value);

	/**
	 * Get a short name for this type (e.g. String for java.lang.String).
	 * 
	 * @model kind="operation"
	 */
	String getShortName();

} // TypeMetaData
