/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

/**
 * <copyright>
 * </copyright>
 *
 * $Id: CollectionTypeMetaDataImpl.java,v 1.13 2005/09/13 14:16:31 dtinker Exp $
 */
package org.eclipse.jsr220orm.metadata.impl;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.jsr220orm.metadata.CollectionTypeMetaData;
import org.eclipse.jsr220orm.metadata.EntityModel;
import org.eclipse.jsr220orm.metadata.MetadataPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Collection Type Meta Data</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * </p>
 *
 * @generated
 */
public class CollectionTypeMetaDataImpl extends TypeMetaDataImpl implements CollectionTypeMetaData {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CollectionTypeMetaDataImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return MetadataPackage.eINSTANCE.getCollectionTypeMetaData();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case MetadataPackage.COLLECTION_TYPE_META_DATA__ENTITY_MODEL:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, MetadataPackage.COLLECTION_TYPE_META_DATA__ENTITY_MODEL, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case MetadataPackage.COLLECTION_TYPE_META_DATA__ENTITY_MODEL:
					return eBasicSetContainer(null, MetadataPackage.COLLECTION_TYPE_META_DATA__ENTITY_MODEL, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case MetadataPackage.COLLECTION_TYPE_META_DATA__ENTITY_MODEL:
					return eContainer.eInverseRemove(this, MetadataPackage.ENTITY_MODEL__TYPE_LIST, EntityModel.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return eContainer.eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.COLLECTION_TYPE_META_DATA__ENTITY_MODEL:
				return getEntityModel();
			case MetadataPackage.COLLECTION_TYPE_META_DATA__CLASS_NAME:
				return getClassName();
			case MetadataPackage.COLLECTION_TYPE_META_DATA__CLS:
				return getCls();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.COLLECTION_TYPE_META_DATA__ENTITY_MODEL:
				setEntityModel((EntityModel)newValue);
				return;
			case MetadataPackage.COLLECTION_TYPE_META_DATA__CLASS_NAME:
				setClassName((String)newValue);
				return;
			case MetadataPackage.COLLECTION_TYPE_META_DATA__CLS:
				setCls((Class)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.COLLECTION_TYPE_META_DATA__ENTITY_MODEL:
				setEntityModel((EntityModel)null);
				return;
			case MetadataPackage.COLLECTION_TYPE_META_DATA__CLASS_NAME:
				setClassName(CLASS_NAME_EDEFAULT);
				return;
			case MetadataPackage.COLLECTION_TYPE_META_DATA__CLS:
				setCls(CLS_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.COLLECTION_TYPE_META_DATA__ENTITY_MODEL:
				return getEntityModel() != null;
			case MetadataPackage.COLLECTION_TYPE_META_DATA__CLASS_NAME:
				return CLASS_NAME_EDEFAULT == null ? className != null : !CLASS_NAME_EDEFAULT.equals(className);
			case MetadataPackage.COLLECTION_TYPE_META_DATA__CLS:
				return CLS_EDEFAULT == null ? cls != null : !CLS_EDEFAULT.equals(cls);
		}
		return eDynamicIsSet(eFeature);
	}

} //CollectionTypeMetaDataImpl
