/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

/**
 * <copyright>
 * </copyright>
 *
 * $Id: JdoEntityImpl.java,v 1.14 2005/09/13 14:16:31 dtinker Exp $
 */
package org.eclipse.jsr220orm.metadata.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.metadata.EntityModel;
import org.eclipse.jsr220orm.metadata.JdoEntity;
import org.eclipse.jsr220orm.metadata.Join;
import org.eclipse.jsr220orm.metadata.MetadataPackage;
import org.eclipse.jsr220orm.metadata.OrmColumn;
import org.eclipse.jsr220orm.metadata.OrmTable;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Jdo Entity</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.JdoEntityImpl#getIdentityType <em>Identity Type</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class JdoEntityImpl extends EntityMetaDataImpl implements JdoEntity {
	/**
	 * The default value of the '{@link #getIdentityType() <em>Identity Type</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getIdentityType()
	 * @generated
	 * @ordered
	 */
	protected static final int IDENTITY_TYPE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getIdentityType() <em>Identity Type</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getIdentityType()
	 * @generated
	 * @ordered
	 */
	protected int identityType = IDENTITY_TYPE_EDEFAULT;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected JdoEntityImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return MetadataPackage.eINSTANCE.getJdoEntity();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public int getIdentityType() {
		return identityType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setIdentityType(int newIdentityType) {
		int oldIdentityType = identityType;
		identityType = newIdentityType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.JDO_ENTITY__IDENTITY_TYPE, oldIdentityType, identityType));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case MetadataPackage.JDO_ENTITY__ENTITY_MODEL:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, MetadataPackage.JDO_ENTITY__ENTITY_MODEL, msgs);
				case MetadataPackage.JDO_ENTITY__SUPER_ENTITY:
					if (superEntity != null)
						msgs = ((InternalEObject)superEntity).eInverseRemove(this, MetadataPackage.ENTITY_META_DATA__SUB_ENTITY_LIST, EntityMetaData.class, msgs);
					return basicSetSuperEntity((EntityMetaData)otherEnd, msgs);
				case MetadataPackage.JDO_ENTITY__SUB_ENTITY_LIST:
					return ((InternalEList)getSubEntityList()).basicAdd(otherEnd, msgs);
				case MetadataPackage.JDO_ENTITY__ATTRIBUTE_LIST:
					return ((InternalEList)getAttributeList()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case MetadataPackage.JDO_ENTITY__ENTITY_MODEL:
					return eBasicSetContainer(null, MetadataPackage.JDO_ENTITY__ENTITY_MODEL, msgs);
				case MetadataPackage.JDO_ENTITY__SUPER_ENTITY:
					return basicSetSuperEntity(null, msgs);
				case MetadataPackage.JDO_ENTITY__SUB_ENTITY_LIST:
					return ((InternalEList)getSubEntityList()).basicRemove(otherEnd, msgs);
				case MetadataPackage.JDO_ENTITY__ATTRIBUTE_LIST:
					return ((InternalEList)getAttributeList()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case MetadataPackage.JDO_ENTITY__ENTITY_MODEL:
					return eContainer.eInverseRemove(this, MetadataPackage.ENTITY_MODEL__TYPE_LIST, EntityModel.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return eContainer.eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.JDO_ENTITY__ENTITY_MODEL:
				return getEntityModel();
			case MetadataPackage.JDO_ENTITY__CLASS_NAME:
				return getClassName();
			case MetadataPackage.JDO_ENTITY__CLS:
				return getCls();
			case MetadataPackage.JDO_ENTITY__ENTITY_TYPE:
				return new Integer(getEntityType());
			case MetadataPackage.JDO_ENTITY__SCHEMA_NAME:
				return getSchemaName();
			case MetadataPackage.JDO_ENTITY__SUPER_ENTITY:
				if (resolve) return getSuperEntity();
				return basicGetSuperEntity();
			case MetadataPackage.JDO_ENTITY__SUB_ENTITY_LIST:
				return getSubEntityList();
			case MetadataPackage.JDO_ENTITY__ATTRIBUTE_LIST:
				return getAttributeList();
			case MetadataPackage.JDO_ENTITY__PRIMARY_KEY_LIST:
				return getPrimaryKeyList();
			case MetadataPackage.JDO_ENTITY__VERSION_LIST:
				return getVersionList();
			case MetadataPackage.JDO_ENTITY__ID_GENERATOR_TYPE:
				return new Integer(getIdGeneratorType());
			case MetadataPackage.JDO_ENTITY__ID_GENERATOR_NAME:
				return getIdGeneratorName();
			case MetadataPackage.JDO_ENTITY__ID_CLASS:
				return getIdClass();
			case MetadataPackage.JDO_ENTITY__TABLE:
				if (resolve) return getTable();
				return basicGetTable();
			case MetadataPackage.JDO_ENTITY__SECONDARY_TABLE_JOIN_LIST:
				return getSecondaryTableJoinList();
			case MetadataPackage.JDO_ENTITY__ACCESS_TYPE:
				return new Integer(getAccessType());
			case MetadataPackage.JDO_ENTITY__INHERITANCE:
				return new Integer(getInheritance());
			case MetadataPackage.JDO_ENTITY__INHERITANCE_SPECIFIED:
				return isInheritanceSpecified() ? Boolean.TRUE : Boolean.FALSE;
			case MetadataPackage.JDO_ENTITY__DISCRIMINATOR_TYPE:
				return new Integer(getDiscriminatorType());
			case MetadataPackage.JDO_ENTITY__DISCRIMINATOR_VALUE:
				return getDiscriminatorValue();
			case MetadataPackage.JDO_ENTITY__DISCRIMINATOR_COLUMN:
				if (resolve) return getDiscriminatorColumn();
				return basicGetDiscriminatorColumn();
			case MetadataPackage.JDO_ENTITY__SUPER_JOIN:
				if (resolve) return getSuperJoin();
				return basicGetSuperJoin();
			case MetadataPackage.JDO_ENTITY__IDENTITY_TYPE:
				return new Integer(getIdentityType());
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.JDO_ENTITY__ENTITY_MODEL:
				setEntityModel((EntityModel)newValue);
				return;
			case MetadataPackage.JDO_ENTITY__CLASS_NAME:
				setClassName((String)newValue);
				return;
			case MetadataPackage.JDO_ENTITY__CLS:
				setCls((Class)newValue);
				return;
			case MetadataPackage.JDO_ENTITY__ENTITY_TYPE:
				setEntityType(((Integer)newValue).intValue());
				return;
			case MetadataPackage.JDO_ENTITY__SCHEMA_NAME:
				setSchemaName((String)newValue);
				return;
			case MetadataPackage.JDO_ENTITY__SUPER_ENTITY:
				setSuperEntity((EntityMetaData)newValue);
				return;
			case MetadataPackage.JDO_ENTITY__SUB_ENTITY_LIST:
				getSubEntityList().clear();
				getSubEntityList().addAll((Collection)newValue);
				return;
			case MetadataPackage.JDO_ENTITY__ATTRIBUTE_LIST:
				getAttributeList().clear();
				getAttributeList().addAll((Collection)newValue);
				return;
			case MetadataPackage.JDO_ENTITY__PRIMARY_KEY_LIST:
				getPrimaryKeyList().clear();
				getPrimaryKeyList().addAll((Collection)newValue);
				return;
			case MetadataPackage.JDO_ENTITY__VERSION_LIST:
				getVersionList().clear();
				getVersionList().addAll((Collection)newValue);
				return;
			case MetadataPackage.JDO_ENTITY__ID_GENERATOR_TYPE:
				setIdGeneratorType(((Integer)newValue).intValue());
				return;
			case MetadataPackage.JDO_ENTITY__ID_GENERATOR_NAME:
				setIdGeneratorName((String)newValue);
				return;
			case MetadataPackage.JDO_ENTITY__ID_CLASS:
				setIdClass((String)newValue);
				return;
			case MetadataPackage.JDO_ENTITY__TABLE:
				setTable((OrmTable)newValue);
				return;
			case MetadataPackage.JDO_ENTITY__SECONDARY_TABLE_JOIN_LIST:
				getSecondaryTableJoinList().clear();
				getSecondaryTableJoinList().addAll((Collection)newValue);
				return;
			case MetadataPackage.JDO_ENTITY__ACCESS_TYPE:
				setAccessType(((Integer)newValue).intValue());
				return;
			case MetadataPackage.JDO_ENTITY__INHERITANCE:
				setInheritance(((Integer)newValue).intValue());
				return;
			case MetadataPackage.JDO_ENTITY__INHERITANCE_SPECIFIED:
				setInheritanceSpecified(((Boolean)newValue).booleanValue());
				return;
			case MetadataPackage.JDO_ENTITY__DISCRIMINATOR_TYPE:
				setDiscriminatorType(((Integer)newValue).intValue());
				return;
			case MetadataPackage.JDO_ENTITY__DISCRIMINATOR_VALUE:
				setDiscriminatorValue((String)newValue);
				return;
			case MetadataPackage.JDO_ENTITY__DISCRIMINATOR_COLUMN:
				setDiscriminatorColumn((OrmColumn)newValue);
				return;
			case MetadataPackage.JDO_ENTITY__SUPER_JOIN:
				setSuperJoin((Join)newValue);
				return;
			case MetadataPackage.JDO_ENTITY__IDENTITY_TYPE:
				setIdentityType(((Integer)newValue).intValue());
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.JDO_ENTITY__ENTITY_MODEL:
				setEntityModel((EntityModel)null);
				return;
			case MetadataPackage.JDO_ENTITY__CLASS_NAME:
				setClassName(CLASS_NAME_EDEFAULT);
				return;
			case MetadataPackage.JDO_ENTITY__CLS:
				setCls(CLS_EDEFAULT);
				return;
			case MetadataPackage.JDO_ENTITY__ENTITY_TYPE:
				setEntityType(ENTITY_TYPE_EDEFAULT);
				return;
			case MetadataPackage.JDO_ENTITY__SCHEMA_NAME:
				setSchemaName(SCHEMA_NAME_EDEFAULT);
				return;
			case MetadataPackage.JDO_ENTITY__SUPER_ENTITY:
				setSuperEntity((EntityMetaData)null);
				return;
			case MetadataPackage.JDO_ENTITY__SUB_ENTITY_LIST:
				getSubEntityList().clear();
				return;
			case MetadataPackage.JDO_ENTITY__ATTRIBUTE_LIST:
				getAttributeList().clear();
				return;
			case MetadataPackage.JDO_ENTITY__PRIMARY_KEY_LIST:
				getPrimaryKeyList().clear();
				return;
			case MetadataPackage.JDO_ENTITY__VERSION_LIST:
				getVersionList().clear();
				return;
			case MetadataPackage.JDO_ENTITY__ID_GENERATOR_TYPE:
				setIdGeneratorType(ID_GENERATOR_TYPE_EDEFAULT);
				return;
			case MetadataPackage.JDO_ENTITY__ID_GENERATOR_NAME:
				setIdGeneratorName(ID_GENERATOR_NAME_EDEFAULT);
				return;
			case MetadataPackage.JDO_ENTITY__ID_CLASS:
				setIdClass(ID_CLASS_EDEFAULT);
				return;
			case MetadataPackage.JDO_ENTITY__TABLE:
				setTable((OrmTable)null);
				return;
			case MetadataPackage.JDO_ENTITY__SECONDARY_TABLE_JOIN_LIST:
				getSecondaryTableJoinList().clear();
				return;
			case MetadataPackage.JDO_ENTITY__ACCESS_TYPE:
				setAccessType(ACCESS_TYPE_EDEFAULT);
				return;
			case MetadataPackage.JDO_ENTITY__INHERITANCE:
				setInheritance(INHERITANCE_EDEFAULT);
				return;
			case MetadataPackage.JDO_ENTITY__INHERITANCE_SPECIFIED:
				setInheritanceSpecified(INHERITANCE_SPECIFIED_EDEFAULT);
				return;
			case MetadataPackage.JDO_ENTITY__DISCRIMINATOR_TYPE:
				setDiscriminatorType(DISCRIMINATOR_TYPE_EDEFAULT);
				return;
			case MetadataPackage.JDO_ENTITY__DISCRIMINATOR_VALUE:
				setDiscriminatorValue(DISCRIMINATOR_VALUE_EDEFAULT);
				return;
			case MetadataPackage.JDO_ENTITY__DISCRIMINATOR_COLUMN:
				setDiscriminatorColumn((OrmColumn)null);
				return;
			case MetadataPackage.JDO_ENTITY__SUPER_JOIN:
				setSuperJoin((Join)null);
				return;
			case MetadataPackage.JDO_ENTITY__IDENTITY_TYPE:
				setIdentityType(IDENTITY_TYPE_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.JDO_ENTITY__ENTITY_MODEL:
				return getEntityModel() != null;
			case MetadataPackage.JDO_ENTITY__CLASS_NAME:
				return CLASS_NAME_EDEFAULT == null ? className != null : !CLASS_NAME_EDEFAULT.equals(className);
			case MetadataPackage.JDO_ENTITY__CLS:
				return CLS_EDEFAULT == null ? cls != null : !CLS_EDEFAULT.equals(cls);
			case MetadataPackage.JDO_ENTITY__ENTITY_TYPE:
				return entityType != ENTITY_TYPE_EDEFAULT;
			case MetadataPackage.JDO_ENTITY__SCHEMA_NAME:
				return SCHEMA_NAME_EDEFAULT == null ? schemaName != null : !SCHEMA_NAME_EDEFAULT.equals(schemaName);
			case MetadataPackage.JDO_ENTITY__SUPER_ENTITY:
				return superEntity != null;
			case MetadataPackage.JDO_ENTITY__SUB_ENTITY_LIST:
				return subEntityList != null && !subEntityList.isEmpty();
			case MetadataPackage.JDO_ENTITY__ATTRIBUTE_LIST:
				return attributeList != null && !attributeList.isEmpty();
			case MetadataPackage.JDO_ENTITY__PRIMARY_KEY_LIST:
				return primaryKeyList != null && !primaryKeyList.isEmpty();
			case MetadataPackage.JDO_ENTITY__VERSION_LIST:
				return versionList != null && !versionList.isEmpty();
			case MetadataPackage.JDO_ENTITY__ID_GENERATOR_TYPE:
				return idGeneratorType != ID_GENERATOR_TYPE_EDEFAULT;
			case MetadataPackage.JDO_ENTITY__ID_GENERATOR_NAME:
				return ID_GENERATOR_NAME_EDEFAULT == null ? idGeneratorName != null : !ID_GENERATOR_NAME_EDEFAULT.equals(idGeneratorName);
			case MetadataPackage.JDO_ENTITY__ID_CLASS:
				return ID_CLASS_EDEFAULT == null ? idClass != null : !ID_CLASS_EDEFAULT.equals(idClass);
			case MetadataPackage.JDO_ENTITY__TABLE:
				return table != null;
			case MetadataPackage.JDO_ENTITY__SECONDARY_TABLE_JOIN_LIST:
				return secondaryTableJoinList != null && !secondaryTableJoinList.isEmpty();
			case MetadataPackage.JDO_ENTITY__ACCESS_TYPE:
				return accessType != ACCESS_TYPE_EDEFAULT;
			case MetadataPackage.JDO_ENTITY__INHERITANCE:
				return inheritance != INHERITANCE_EDEFAULT;
			case MetadataPackage.JDO_ENTITY__INHERITANCE_SPECIFIED:
				return inheritanceSpecified != INHERITANCE_SPECIFIED_EDEFAULT;
			case MetadataPackage.JDO_ENTITY__DISCRIMINATOR_TYPE:
				return discriminatorType != DISCRIMINATOR_TYPE_EDEFAULT;
			case MetadataPackage.JDO_ENTITY__DISCRIMINATOR_VALUE:
				return DISCRIMINATOR_VALUE_EDEFAULT == null ? discriminatorValue != null : !DISCRIMINATOR_VALUE_EDEFAULT.equals(discriminatorValue);
			case MetadataPackage.JDO_ENTITY__DISCRIMINATOR_COLUMN:
				return discriminatorColumn != null;
			case MetadataPackage.JDO_ENTITY__SUPER_JOIN:
				return superJoin != null;
			case MetadataPackage.JDO_ENTITY__IDENTITY_TYPE:
				return identityType != IDENTITY_TYPE_EDEFAULT;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (identityType: ");
		result.append(identityType);
		result.append(')');
		return result.toString();
	}

} // JdoEntityImpl
