/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

/**
 * <copyright>
 * </copyright>
 *
 * $Id: JoinImpl.java,v 1.13 2005/09/13 14:16:31 dtinker Exp $
 */
package org.eclipse.jsr220orm.metadata.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jsr220orm.metadata.Join;
import org.eclipse.jsr220orm.metadata.JoinPair;
import org.eclipse.jsr220orm.metadata.MetadataElement;
import org.eclipse.jsr220orm.metadata.MetadataPackage;
import org.eclipse.jsr220orm.metadata.OrmColumn;
import org.eclipse.jsr220orm.metadata.OrmTable;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Join</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.JoinImpl#getPairList <em>Pair List</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.JoinImpl#getComment <em>Comment</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class JoinImpl extends MetadataElementImpl implements Join {
	/**
	 * The cached value of the '{@link #getPairList() <em>Pair List</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPairList()
	 * @generated
	 * @ordered
	 */
	protected EList pairList = null;

	/**
	 * The default value of the '{@link #getComment() <em>Comment</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getComment()
	 * @generated
	 * @ordered
	 */
	protected static final String COMMENT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getComment() <em>Comment</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getComment()
	 * @generated
	 * @ordered
	 */
	protected String comment = COMMENT_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JoinImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return MetadataPackage.eINSTANCE.getJoin();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getPairList() {
		if (pairList == null) {
			pairList = new EObjectWithInverseResolvingEList(JoinPair.class, this, MetadataPackage.JOIN__PAIR_LIST, MetadataPackage.JOIN_PAIR__JOIN);
		}
		return pairList;
	}

	public OrmTable getSrcTable() {
		if (pairList == null || pairList.isEmpty()) {
			return null;
		}
		OrmColumn src = ((JoinPair)pairList.get(0)).getSrc();
		return src == null ? null : src.getTable();
	}

	public OrmTable getDestTable() {
		if (pairList == null || pairList.isEmpty()) {
			return null;
		}
		OrmColumn dest = ((JoinPair)pairList.get(0)).getDest();
		return dest == null ? null : dest.getTable();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getComment() {
		return comment;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setComment(String newComment) {
		String oldComment = comment;
		comment = newComment;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.JOIN__COMMENT, oldComment, comment));
	}

	public JoinPair findPairForDest(OrmColumn dest) {
		if (pairList == null) {
			return null;
		}
		int n = pairList.size();
		for (int i = 0; i < n; i++) {
			JoinPair p = (JoinPair)pairList.get(i);
			if (p.getDest() == dest) {
				return p;
			}
		}
		return null;
	}
	
	public JoinPair findPairForSrc(OrmColumn src) {
		if (pairList == null) {
			return null;
		}
		int n = pairList.size();
		for (int i = 0; i < n; i++) {
			JoinPair p = (JoinPair)pairList.get(i);
			if (p.getSrc() == src) {
				return p;
			}
		}
		return null;
	}

	public JoinPair findPairForSrc(String srcName) {
		if (pairList == null) {
			return null;
		}
		int n = pairList.size();
		for (int i = 0; i < n; i++) {
			JoinPair p = (JoinPair)pairList.get(i);
			if (srcName.equals(p.getSrc().getName())) {
				return p;
			}
		}
		return null;
	}
	
	public EList getSrcColumns() {
		int n = pairList == null ? 0 : pairList.size();
		BasicEList ans = new BasicEList(n);
		for (int i = 0; i < n; i++) {
			JoinPair p = (JoinPair)pairList.get(i);
			OrmColumn src = p.getSrc();
			if (src != null) {
				ans.add(src);
			}
		}
		return ans;
	}

	public EList getDestColumns() {
		int n = pairList == null ? 0 : pairList.size();
		BasicEList ans = new BasicEList(n);
		for (int i = 0; i < n; i++) {
			JoinPair p = (JoinPair)pairList.get(i);
			OrmColumn dest = p.getDest();
			if (dest != null) {
				ans.add(dest);
			}
		}
		return ans;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case MetadataPackage.JOIN__PAIR_LIST:
					return ((InternalEList)getPairList()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case MetadataPackage.JOIN__PAIR_LIST:
					return ((InternalEList)getPairList()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.JOIN__PAIR_LIST:
				return getPairList();
			case MetadataPackage.JOIN__COMMENT:
				return getComment();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.JOIN__PAIR_LIST:
				getPairList().clear();
				getPairList().addAll((Collection)newValue);
				return;
			case MetadataPackage.JOIN__COMMENT:
				setComment((String)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.JOIN__PAIR_LIST:
				getPairList().clear();
				return;
			case MetadataPackage.JOIN__COMMENT:
				setComment(COMMENT_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.JOIN__PAIR_LIST:
				return pairList != null && !pairList.isEmpty();
			case MetadataPackage.JOIN__COMMENT:
				return COMMENT_EDEFAULT == null ? comment != null : !COMMENT_EDEFAULT.equals(comment);
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (comment: ");
		result.append(comment);
		result.append(')');
		return result.toString();
	}

	public MetadataElement getParentElement() {
		return getSrcTable();
	}

	public void delete() {
		if (pairList != null) {
			// must do this in reverse order as each JoinPair will remove
			// itself from our list in its delete()
			for (int i = pairList.size() - 1; i >= 0; i--) {
				JoinPair p = (JoinPair)pairList.get(i);
				p.delete();
			}
		}
		super.delete();
	}

} //JoinImpl
