/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

/**
 * <copyright>
 * </copyright>
 *
 * $Id: MapAttributeImpl.java,v 1.14 2005/09/13 14:16:31 dtinker Exp $
 */
package org.eclipse.jsr220orm.metadata.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jsr220orm.metadata.AttributeMetaData;
import org.eclipse.jsr220orm.metadata.EmbeddedAttribute;
import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.metadata.MapAttribute;
import org.eclipse.jsr220orm.metadata.MetadataPackage;
import org.eclipse.jsr220orm.metadata.TypeMetaData;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Map Attribute</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.MapAttributeImpl#getKeyType <em>Key Type</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.MapAttributeImpl#getValueType <em>Value Type</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class MapAttributeImpl extends AttributeMetaDataImpl implements
		MapAttribute {
	/**
	 * The cached value of the '{@link #getKeyType() <em>Key Type</em>}' reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getKeyType()
	 * @generated
	 * @ordered
	 */
	protected TypeMetaData keyType = null;

	/**
	 * The cached value of the '{@link #getValueType() <em>Value Type</em>}' reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getValueType()
	 * @generated
	 * @ordered
	 */
	protected TypeMetaData valueType = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected MapAttributeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return MetadataPackage.eINSTANCE.getMapAttribute();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public TypeMetaData getKeyType() {
		if (keyType != null && keyType.eIsProxy()) {
			TypeMetaData oldKeyType = keyType;
			keyType = (TypeMetaData)eResolveProxy((InternalEObject)keyType);
			if (keyType != oldKeyType) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, MetadataPackage.MAP_ATTRIBUTE__KEY_TYPE, oldKeyType, keyType));
			}
		}
		return keyType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public TypeMetaData basicGetKeyType() {
		return keyType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setKeyType(TypeMetaData newKeyType) {
		TypeMetaData oldKeyType = keyType;
		keyType = newKeyType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.MAP_ATTRIBUTE__KEY_TYPE, oldKeyType, keyType));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public TypeMetaData getValueType() {
		if (valueType != null && valueType.eIsProxy()) {
			TypeMetaData oldValueType = valueType;
			valueType = (TypeMetaData)eResolveProxy((InternalEObject)valueType);
			if (valueType != oldValueType) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, MetadataPackage.MAP_ATTRIBUTE__VALUE_TYPE, oldValueType, valueType));
			}
		}
		return valueType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public TypeMetaData basicGetValueType() {
		return valueType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setValueType(TypeMetaData newValueType) {
		TypeMetaData oldValueType = valueType;
		valueType = newValueType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.MAP_ATTRIBUTE__VALUE_TYPE, oldValueType, valueType));
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case MetadataPackage.MAP_ATTRIBUTE__ENTITY_META_DATA:
					if (entityMetaData != null)
						msgs = ((InternalEObject)entityMetaData).eInverseRemove(this, MetadataPackage.ENTITY_META_DATA__ATTRIBUTE_LIST, EntityMetaData.class, msgs);
					return basicSetEntityMetaData((EntityMetaData)otherEnd, msgs);
				case MetadataPackage.MAP_ATTRIBUTE__EMBEDDED_IN:
					if (embeddedIn != null)
						msgs = ((InternalEObject)embeddedIn).eInverseRemove(this, MetadataPackage.EMBEDDED_ATTRIBUTE__ATTRIBUTE_LIST, EmbeddedAttribute.class, msgs);
					return basicSetEmbeddedIn((EmbeddedAttribute)otherEnd, msgs);
				case MetadataPackage.MAP_ATTRIBUTE__MAPPED_BY:
					if (mappedBy != null)
						msgs = ((InternalEObject)mappedBy).eInverseRemove(this, MetadataPackage.ATTRIBUTE_META_DATA__INVERSE_LIST, AttributeMetaData.class, msgs);
					return basicSetMappedBy((AttributeMetaData)otherEnd, msgs);
				case MetadataPackage.MAP_ATTRIBUTE__INVERSE_LIST:
					return ((InternalEList)getInverseList()).basicAdd(otherEnd, msgs);
				case MetadataPackage.MAP_ATTRIBUTE__OVERRIDE_OF:
					if (overrideOf != null)
						msgs = ((InternalEObject)overrideOf).eInverseRemove(this, MetadataPackage.ATTRIBUTE_META_DATA__OVERRIDE_LIST, AttributeMetaData.class, msgs);
					return basicSetOverrideOf((AttributeMetaData)otherEnd, msgs);
				case MetadataPackage.MAP_ATTRIBUTE__OVERRIDE_LIST:
					return ((InternalEList)getOverrideList()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case MetadataPackage.MAP_ATTRIBUTE__ENTITY_META_DATA:
					return basicSetEntityMetaData(null, msgs);
				case MetadataPackage.MAP_ATTRIBUTE__EMBEDDED_IN:
					return basicSetEmbeddedIn(null, msgs);
				case MetadataPackage.MAP_ATTRIBUTE__MAPPED_BY:
					return basicSetMappedBy(null, msgs);
				case MetadataPackage.MAP_ATTRIBUTE__INVERSE_LIST:
					return ((InternalEList)getInverseList()).basicRemove(otherEnd, msgs);
				case MetadataPackage.MAP_ATTRIBUTE__OVERRIDE_OF:
					return basicSetOverrideOf(null, msgs);
				case MetadataPackage.MAP_ATTRIBUTE__OVERRIDE_LIST:
					return ((InternalEList)getOverrideList()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.MAP_ATTRIBUTE__ENTITY_META_DATA:
				if (resolve) return getEntityMetaData();
				return basicGetEntityMetaData();
			case MetadataPackage.MAP_ATTRIBUTE__EMBEDDED_IN:
				if (resolve) return getEmbeddedIn();
				return basicGetEmbeddedIn();
			case MetadataPackage.MAP_ATTRIBUTE__NAME:
				return getName();
			case MetadataPackage.MAP_ATTRIBUTE__JAVA_TYPE:
				if (resolve) return getJavaType();
				return basicGetJavaType();
			case MetadataPackage.MAP_ATTRIBUTE__FETCH_TYPE:
				return new Integer(getFetchType());
			case MetadataPackage.MAP_ATTRIBUTE__OPTIONAL:
				return isOptional() ? Boolean.TRUE : Boolean.FALSE;
			case MetadataPackage.MAP_ATTRIBUTE__GETTER_METHOD_NAME:
				return getGetterMethodName();
			case MetadataPackage.MAP_ATTRIBUTE__SETTER_METHOD_NAME:
				return getSetterMethodName();
			case MetadataPackage.MAP_ATTRIBUTE__MAPPED_BY:
				if (resolve) return getMappedBy();
				return basicGetMappedBy();
			case MetadataPackage.MAP_ATTRIBUTE__INVERSE_LIST:
				return getInverseList();
			case MetadataPackage.MAP_ATTRIBUTE__OVERRIDE_OF:
				if (resolve) return getOverrideOf();
				return basicGetOverrideOf();
			case MetadataPackage.MAP_ATTRIBUTE__OVERRIDE_LIST:
				return getOverrideList();
			case MetadataPackage.MAP_ATTRIBUTE__KEY_TYPE:
				if (resolve) return getKeyType();
				return basicGetKeyType();
			case MetadataPackage.MAP_ATTRIBUTE__VALUE_TYPE:
				if (resolve) return getValueType();
				return basicGetValueType();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.MAP_ATTRIBUTE__ENTITY_META_DATA:
				setEntityMetaData((EntityMetaData)newValue);
				return;
			case MetadataPackage.MAP_ATTRIBUTE__EMBEDDED_IN:
				setEmbeddedIn((EmbeddedAttribute)newValue);
				return;
			case MetadataPackage.MAP_ATTRIBUTE__NAME:
				setName((String)newValue);
				return;
			case MetadataPackage.MAP_ATTRIBUTE__JAVA_TYPE:
				setJavaType((TypeMetaData)newValue);
				return;
			case MetadataPackage.MAP_ATTRIBUTE__FETCH_TYPE:
				setFetchType(((Integer)newValue).intValue());
				return;
			case MetadataPackage.MAP_ATTRIBUTE__OPTIONAL:
				setOptional(((Boolean)newValue).booleanValue());
				return;
			case MetadataPackage.MAP_ATTRIBUTE__GETTER_METHOD_NAME:
				setGetterMethodName((String)newValue);
				return;
			case MetadataPackage.MAP_ATTRIBUTE__SETTER_METHOD_NAME:
				setSetterMethodName((String)newValue);
				return;
			case MetadataPackage.MAP_ATTRIBUTE__MAPPED_BY:
				setMappedBy((AttributeMetaData)newValue);
				return;
			case MetadataPackage.MAP_ATTRIBUTE__INVERSE_LIST:
				getInverseList().clear();
				getInverseList().addAll((Collection)newValue);
				return;
			case MetadataPackage.MAP_ATTRIBUTE__OVERRIDE_OF:
				setOverrideOf((AttributeMetaData)newValue);
				return;
			case MetadataPackage.MAP_ATTRIBUTE__OVERRIDE_LIST:
				getOverrideList().clear();
				getOverrideList().addAll((Collection)newValue);
				return;
			case MetadataPackage.MAP_ATTRIBUTE__KEY_TYPE:
				setKeyType((TypeMetaData)newValue);
				return;
			case MetadataPackage.MAP_ATTRIBUTE__VALUE_TYPE:
				setValueType((TypeMetaData)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.MAP_ATTRIBUTE__ENTITY_META_DATA:
				setEntityMetaData((EntityMetaData)null);
				return;
			case MetadataPackage.MAP_ATTRIBUTE__EMBEDDED_IN:
				setEmbeddedIn((EmbeddedAttribute)null);
				return;
			case MetadataPackage.MAP_ATTRIBUTE__NAME:
				setName(NAME_EDEFAULT);
				return;
			case MetadataPackage.MAP_ATTRIBUTE__JAVA_TYPE:
				setJavaType((TypeMetaData)null);
				return;
			case MetadataPackage.MAP_ATTRIBUTE__FETCH_TYPE:
				setFetchType(FETCH_TYPE_EDEFAULT);
				return;
			case MetadataPackage.MAP_ATTRIBUTE__OPTIONAL:
				setOptional(OPTIONAL_EDEFAULT);
				return;
			case MetadataPackage.MAP_ATTRIBUTE__GETTER_METHOD_NAME:
				setGetterMethodName(GETTER_METHOD_NAME_EDEFAULT);
				return;
			case MetadataPackage.MAP_ATTRIBUTE__SETTER_METHOD_NAME:
				setSetterMethodName(SETTER_METHOD_NAME_EDEFAULT);
				return;
			case MetadataPackage.MAP_ATTRIBUTE__MAPPED_BY:
				setMappedBy((AttributeMetaData)null);
				return;
			case MetadataPackage.MAP_ATTRIBUTE__INVERSE_LIST:
				getInverseList().clear();
				return;
			case MetadataPackage.MAP_ATTRIBUTE__OVERRIDE_OF:
				setOverrideOf((AttributeMetaData)null);
				return;
			case MetadataPackage.MAP_ATTRIBUTE__OVERRIDE_LIST:
				getOverrideList().clear();
				return;
			case MetadataPackage.MAP_ATTRIBUTE__KEY_TYPE:
				setKeyType((TypeMetaData)null);
				return;
			case MetadataPackage.MAP_ATTRIBUTE__VALUE_TYPE:
				setValueType((TypeMetaData)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.MAP_ATTRIBUTE__ENTITY_META_DATA:
				return entityMetaData != null;
			case MetadataPackage.MAP_ATTRIBUTE__EMBEDDED_IN:
				return embeddedIn != null;
			case MetadataPackage.MAP_ATTRIBUTE__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case MetadataPackage.MAP_ATTRIBUTE__JAVA_TYPE:
				return javaType != null;
			case MetadataPackage.MAP_ATTRIBUTE__FETCH_TYPE:
				return fetchType != FETCH_TYPE_EDEFAULT;
			case MetadataPackage.MAP_ATTRIBUTE__OPTIONAL:
				return optional != OPTIONAL_EDEFAULT;
			case MetadataPackage.MAP_ATTRIBUTE__GETTER_METHOD_NAME:
				return GETTER_METHOD_NAME_EDEFAULT == null ? getterMethodName != null : !GETTER_METHOD_NAME_EDEFAULT.equals(getterMethodName);
			case MetadataPackage.MAP_ATTRIBUTE__SETTER_METHOD_NAME:
				return SETTER_METHOD_NAME_EDEFAULT == null ? setterMethodName != null : !SETTER_METHOD_NAME_EDEFAULT.equals(setterMethodName);
			case MetadataPackage.MAP_ATTRIBUTE__MAPPED_BY:
				return mappedBy != null;
			case MetadataPackage.MAP_ATTRIBUTE__INVERSE_LIST:
				return inverseList != null && !inverseList.isEmpty();
			case MetadataPackage.MAP_ATTRIBUTE__OVERRIDE_OF:
				return overrideOf != null;
			case MetadataPackage.MAP_ATTRIBUTE__OVERRIDE_LIST:
				return overrideList != null && !overrideList.isEmpty();
			case MetadataPackage.MAP_ATTRIBUTE__KEY_TYPE:
				return keyType != null;
			case MetadataPackage.MAP_ATTRIBUTE__VALUE_TYPE:
				return valueType != null;
		}
		return eDynamicIsSet(eFeature);
	}

    public void getTopLevelSqlObjects(HashSet sqlObjects) {
    }

    public List getColumns() {
        ArrayList cols = new ArrayList(6);
        return cols;
    }
} // MapAttributeImpl
