/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

/**
 * <copyright>
 * </copyright>
 *
 * $Id: OrmColumnImpl.java,v 1.14 2005/09/13 14:16:31 dtinker Exp $
 */
package org.eclipse.jsr220orm.metadata.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jsr220orm.metadata.JoinPair;
import org.eclipse.jsr220orm.metadata.MetadataElement;
import org.eclipse.jsr220orm.metadata.MetadataFactory;
import org.eclipse.jsr220orm.metadata.MetadataPackage;
import org.eclipse.jsr220orm.metadata.OrmColumn;
import org.eclipse.jsr220orm.metadata.OrmTable;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Orm Column</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.OrmColumnImpl#getTable <em>Table</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.OrmColumnImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.OrmColumnImpl#getJdbcType <em>Jdbc Type</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.OrmColumnImpl#isNullable <em>Nullable</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.OrmColumnImpl#isInsertable <em>Insertable</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.OrmColumnImpl#isUpdatable <em>Updatable</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.OrmColumnImpl#getLength <em>Length</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.OrmColumnImpl#getScale <em>Scale</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.OrmColumnImpl#getColumnDefinition <em>Column Definition</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.OrmColumnImpl#isColumnDefinitionSpecified <em>Column Definition Specified</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.OrmColumnImpl#getOriginalColumnDefinition <em>Original Column Definition</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.OrmColumnImpl#getSrcJoinPairs <em>Src Join Pairs</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.OrmColumnImpl#getDestJoinPairs <em>Dest Join Pairs</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.OrmColumnImpl#getDatabaseType <em>Database Type</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.OrmColumnImpl#getComment <em>Comment</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.OrmColumnImpl#getRelativePositionInTable <em>Relative Position In Table</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.OrmColumnImpl#isIdentity <em>Identity</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class OrmColumnImpl extends MetadataElementImpl implements OrmColumn {
	/**
	 * The cached value of the '{@link #getTable() <em>Table</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTable()
	 * @generated
	 * @ordered
	 */
	protected OrmTable table = null;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getJdbcType() <em>Jdbc Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getJdbcType()
	 * @generated
	 * @ordered
	 */
	protected static final int JDBC_TYPE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getJdbcType() <em>Jdbc Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getJdbcType()
	 * @generated
	 * @ordered
	 */
	protected int jdbcType = JDBC_TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #isNullable() <em>Nullable</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isNullable()
	 * @generated
	 * @ordered
	 */
	protected static final boolean NULLABLE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isNullable() <em>Nullable</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isNullable()
	 * @generated
	 * @ordered
	 */
	protected boolean nullable = NULLABLE_EDEFAULT;

	/**
	 * The default value of the '{@link #isInsertable() <em>Insertable</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isInsertable()
	 * @generated
	 * @ordered
	 */
	protected static final boolean INSERTABLE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isInsertable() <em>Insertable</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isInsertable()
	 * @generated
	 * @ordered
	 */
	protected boolean insertable = INSERTABLE_EDEFAULT;

	/**
	 * The default value of the '{@link #isUpdatable() <em>Updatable</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isUpdatable()
	 * @generated
	 * @ordered
	 */
	protected static final boolean UPDATABLE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isUpdatable() <em>Updatable</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isUpdatable()
	 * @generated
	 * @ordered
	 */
	protected boolean updatable = UPDATABLE_EDEFAULT;

	/**
	 * The default value of the '{@link #getLength() <em>Length</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLength()
	 * @generated
	 * @ordered
	 */
	protected static final int LENGTH_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getLength() <em>Length</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLength()
	 * @generated
	 * @ordered
	 */
	protected int length = LENGTH_EDEFAULT;

	/**
	 * The default value of the '{@link #getScale() <em>Scale</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getScale()
	 * @generated
	 * @ordered
	 */
	protected static final int SCALE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getScale() <em>Scale</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getScale()
	 * @generated
	 * @ordered
	 */
	protected int scale = SCALE_EDEFAULT;

	/**
	 * The default value of the '{@link #getColumnDefinition() <em>Column Definition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getColumnDefinition()
	 * @generated
	 * @ordered
	 */
	protected static final String COLUMN_DEFINITION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getColumnDefinition() <em>Column Definition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getColumnDefinition()
	 * @generated
	 * @ordered
	 */
	protected String columnDefinition = COLUMN_DEFINITION_EDEFAULT;

	/**
	 * The default value of the '{@link #isColumnDefinitionSpecified() <em>Column Definition Specified</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isColumnDefinitionSpecified()
	 * @generated
	 * @ordered
	 */
	protected static final boolean COLUMN_DEFINITION_SPECIFIED_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isColumnDefinitionSpecified() <em>Column Definition Specified</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isColumnDefinitionSpecified()
	 * @generated
	 * @ordered
	 */
	protected boolean columnDefinitionSpecified = COLUMN_DEFINITION_SPECIFIED_EDEFAULT;

	/**
	 * The default value of the '{@link #getOriginalColumnDefinition() <em>Original Column Definition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOriginalColumnDefinition()
	 * @generated
	 * @ordered
	 */
	protected static final String ORIGINAL_COLUMN_DEFINITION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getOriginalColumnDefinition() <em>Original Column Definition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOriginalColumnDefinition()
	 * @generated
	 * @ordered
	 */
	protected String originalColumnDefinition = ORIGINAL_COLUMN_DEFINITION_EDEFAULT;

	/**
	 * The cached value of the '{@link #getSrcJoinPairs() <em>Src Join Pairs</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSrcJoinPairs()
	 * @generated
	 * @ordered
	 */
	protected EList srcJoinPairs = null;

	/**
	 * The cached value of the '{@link #getDestJoinPairs() <em>Dest Join Pairs</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDestJoinPairs()
	 * @generated
	 * @ordered
	 */
	protected EList destJoinPairs = null;

	/**
	 * The default value of the '{@link #getDatabaseType() <em>Database Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDatabaseType()
	 * @generated
	 * @ordered
	 */
	protected static final String DATABASE_TYPE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDatabaseType() <em>Database Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDatabaseType()
	 * @generated
	 * @ordered
	 */
	protected String databaseType = DATABASE_TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getComment() <em>Comment</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #getComment()
	 * @generated
	 * @ordered
	 */
    protected static final String COMMENT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getComment() <em>Comment</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #getComment()
	 * @generated
	 * @ordered
	 */
    protected String comment = COMMENT_EDEFAULT;

	/**
	 * The default value of the '{@link #getRelativePositionInTable() <em>Relative Position In Table</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRelativePositionInTable()
	 * @generated
	 * @ordered
	 */
	protected static final int RELATIVE_POSITION_IN_TABLE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getRelativePositionInTable() <em>Relative Position In Table</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRelativePositionInTable()
	 * @generated
	 * @ordered
	 */
	protected int relativePositionInTable = RELATIVE_POSITION_IN_TABLE_EDEFAULT;

	/**
	 * The default value of the '{@link #isIdentity() <em>Identity</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIdentity()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IDENTITY_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isIdentity() <em>Identity</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIdentity()
	 * @generated
	 * @ordered
	 */
	protected boolean identity = IDENTITY_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OrmColumnImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return MetadataPackage.eINSTANCE.getOrmColumn();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OrmTable getTable() {
		if (table != null && table.eIsProxy()) {
			OrmTable oldTable = table;
			table = (OrmTable)eResolveProxy((InternalEObject)table);
			if (table != oldTable) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, MetadataPackage.ORM_COLUMN__TABLE, oldTable, table));
			}
		}
		return table;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OrmTable basicGetTable() {
		return table;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetTable(OrmTable newTable, NotificationChain msgs) {
		OrmTable oldTable = table;
		table = newTable;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, MetadataPackage.ORM_COLUMN__TABLE, oldTable, newTable);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTable(OrmTable newTable) {
		if (newTable != table) {
			NotificationChain msgs = null;
			if (table != null)
				msgs = ((InternalEObject)table).eInverseRemove(this, MetadataPackage.ORM_TABLE__COLUMN_LIST, OrmTable.class, msgs);
			if (newTable != null)
				msgs = ((InternalEObject)newTable).eInverseAdd(this, MetadataPackage.ORM_TABLE__COLUMN_LIST, OrmTable.class, msgs);
			msgs = basicSetTable(newTable, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ORM_COLUMN__TABLE, newTable, newTable));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ORM_COLUMN__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getJdbcType() {
		return jdbcType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setJdbcType(int newJdbcType) {
		int oldJdbcType = jdbcType;
		jdbcType = newJdbcType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ORM_COLUMN__JDBC_TYPE, oldJdbcType, jdbcType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isNullable() {
		return nullable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setNullable(boolean newNullable) {
		boolean oldNullable = nullable;
		nullable = newNullable;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ORM_COLUMN__NULLABLE, oldNullable, nullable));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isInsertable() {
		return insertable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInsertable(boolean newInsertable) {
		boolean oldInsertable = insertable;
		insertable = newInsertable;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ORM_COLUMN__INSERTABLE, oldInsertable, insertable));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isUpdatable() {
		return updatable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setUpdatable(boolean newUpdatable) {
		boolean oldUpdatable = updatable;
		updatable = newUpdatable;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ORM_COLUMN__UPDATABLE, oldUpdatable, updatable));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getLength() {
		return length;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLength(int newLength) {
		int oldLength = length;
		length = newLength;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ORM_COLUMN__LENGTH, oldLength, length));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getScale() {
		return scale;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setScale(int newScale) {
		int oldScale = scale;
		scale = newScale;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ORM_COLUMN__SCALE, oldScale, scale));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getColumnDefinition() {
		return columnDefinition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setColumnDefinition(String newColumnDefinition) {
		String oldColumnDefinition = columnDefinition;
		columnDefinition = newColumnDefinition;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ORM_COLUMN__COLUMN_DEFINITION, oldColumnDefinition, columnDefinition));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isColumnDefinitionSpecified() {
		return columnDefinitionSpecified;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setColumnDefinitionSpecified(boolean newColumnDefinitionSpecified) {
		boolean oldColumnDefinitionSpecified = columnDefinitionSpecified;
		columnDefinitionSpecified = newColumnDefinitionSpecified;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ORM_COLUMN__COLUMN_DEFINITION_SPECIFIED, oldColumnDefinitionSpecified, columnDefinitionSpecified));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getSrcJoinPairs() {
		if (srcJoinPairs == null) {
			srcJoinPairs = new EObjectWithInverseResolvingEList(JoinPair.class, this, MetadataPackage.ORM_COLUMN__SRC_JOIN_PAIRS, MetadataPackage.JOIN_PAIR__SRC);
		}
		return srcJoinPairs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getDestJoinPairs() {
		if (destJoinPairs == null) {
			destJoinPairs = new EObjectWithInverseResolvingEList(JoinPair.class, this, MetadataPackage.ORM_COLUMN__DEST_JOIN_PAIRS, MetadataPackage.JOIN_PAIR__DEST);
		}
		return destJoinPairs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDatabaseType() {
		return databaseType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDatabaseType(String newDatabaseType) {
		String oldDatabaseType = databaseType;
		databaseType = newDatabaseType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ORM_COLUMN__DATABASE_TYPE, oldDatabaseType, databaseType));
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public String getComment() {
		return comment;
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public void setComment(String newComment) {
		String oldComment = comment;
		comment = newComment;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ORM_COLUMN__COMMENT, oldComment, comment));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getOriginalColumnDefinition() {
		return originalColumnDefinition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOriginalColumnDefinition(String newOriginalColumnDefinition) {
		String oldOriginalColumnDefinition = originalColumnDefinition;
		originalColumnDefinition = newOriginalColumnDefinition;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ORM_COLUMN__ORIGINAL_COLUMN_DEFINITION, oldOriginalColumnDefinition, originalColumnDefinition));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getRelativePositionInTable() {
		return relativePositionInTable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRelativePositionInTable(int newRelativePositionInTable) {
		int oldRelativePositionInTable = relativePositionInTable;
		relativePositionInTable = newRelativePositionInTable;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ORM_COLUMN__RELATIVE_POSITION_IN_TABLE, oldRelativePositionInTable, relativePositionInTable));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isIdentity() {
		return identity;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIdentity(boolean newIdentity) {
		boolean oldIdentity = identity;
		identity = newIdentity;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ORM_COLUMN__IDENTITY, oldIdentity, identity));
	}

	public boolean isPrimaryKey() {
		return table != null && table.getPrimaryKeyList().contains(this);
	}

	public OrmColumn copyTo(OrmColumn c) {
		// don't put table and JoinPair lists in here
		c.setColumnDefinition(columnDefinition);
		c.setComment(comment);
		c.setDatabaseType(databaseType);
		c.setIdentity(identity);
		c.setInsertable(insertable);
		c.setJdbcType(jdbcType);
		c.setLength(length);
		c.setName(name);
		c.setNullable(nullable);
		c.setOriginalColumnDefinition(originalColumnDefinition);
		c.setRelativePositionInTable(relativePositionInTable);
		c.setScale(scale);
		c.setUpdatable(updatable);
		return c;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case MetadataPackage.ORM_COLUMN__TABLE:
					if (table != null)
						msgs = ((InternalEObject)table).eInverseRemove(this, MetadataPackage.ORM_TABLE__COLUMN_LIST, OrmTable.class, msgs);
					return basicSetTable((OrmTable)otherEnd, msgs);
				case MetadataPackage.ORM_COLUMN__SRC_JOIN_PAIRS:
					return ((InternalEList)getSrcJoinPairs()).basicAdd(otherEnd, msgs);
				case MetadataPackage.ORM_COLUMN__DEST_JOIN_PAIRS:
					return ((InternalEList)getDestJoinPairs()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case MetadataPackage.ORM_COLUMN__TABLE:
					return basicSetTable(null, msgs);
				case MetadataPackage.ORM_COLUMN__SRC_JOIN_PAIRS:
					return ((InternalEList)getSrcJoinPairs()).basicRemove(otherEnd, msgs);
				case MetadataPackage.ORM_COLUMN__DEST_JOIN_PAIRS:
					return ((InternalEList)getDestJoinPairs()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.ORM_COLUMN__TABLE:
				if (resolve) return getTable();
				return basicGetTable();
			case MetadataPackage.ORM_COLUMN__NAME:
				return getName();
			case MetadataPackage.ORM_COLUMN__JDBC_TYPE:
				return new Integer(getJdbcType());
			case MetadataPackage.ORM_COLUMN__NULLABLE:
				return isNullable() ? Boolean.TRUE : Boolean.FALSE;
			case MetadataPackage.ORM_COLUMN__INSERTABLE:
				return isInsertable() ? Boolean.TRUE : Boolean.FALSE;
			case MetadataPackage.ORM_COLUMN__UPDATABLE:
				return isUpdatable() ? Boolean.TRUE : Boolean.FALSE;
			case MetadataPackage.ORM_COLUMN__LENGTH:
				return new Integer(getLength());
			case MetadataPackage.ORM_COLUMN__SCALE:
				return new Integer(getScale());
			case MetadataPackage.ORM_COLUMN__COLUMN_DEFINITION:
				return getColumnDefinition();
			case MetadataPackage.ORM_COLUMN__COLUMN_DEFINITION_SPECIFIED:
				return isColumnDefinitionSpecified() ? Boolean.TRUE : Boolean.FALSE;
			case MetadataPackage.ORM_COLUMN__ORIGINAL_COLUMN_DEFINITION:
				return getOriginalColumnDefinition();
			case MetadataPackage.ORM_COLUMN__SRC_JOIN_PAIRS:
				return getSrcJoinPairs();
			case MetadataPackage.ORM_COLUMN__DEST_JOIN_PAIRS:
				return getDestJoinPairs();
			case MetadataPackage.ORM_COLUMN__DATABASE_TYPE:
				return getDatabaseType();
			case MetadataPackage.ORM_COLUMN__COMMENT:
				return getComment();
			case MetadataPackage.ORM_COLUMN__RELATIVE_POSITION_IN_TABLE:
				return new Integer(getRelativePositionInTable());
			case MetadataPackage.ORM_COLUMN__IDENTITY:
				return isIdentity() ? Boolean.TRUE : Boolean.FALSE;
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.ORM_COLUMN__TABLE:
				setTable((OrmTable)newValue);
				return;
			case MetadataPackage.ORM_COLUMN__NAME:
				setName((String)newValue);
				return;
			case MetadataPackage.ORM_COLUMN__JDBC_TYPE:
				setJdbcType(((Integer)newValue).intValue());
				return;
			case MetadataPackage.ORM_COLUMN__NULLABLE:
				setNullable(((Boolean)newValue).booleanValue());
				return;
			case MetadataPackage.ORM_COLUMN__INSERTABLE:
				setInsertable(((Boolean)newValue).booleanValue());
				return;
			case MetadataPackage.ORM_COLUMN__UPDATABLE:
				setUpdatable(((Boolean)newValue).booleanValue());
				return;
			case MetadataPackage.ORM_COLUMN__LENGTH:
				setLength(((Integer)newValue).intValue());
				return;
			case MetadataPackage.ORM_COLUMN__SCALE:
				setScale(((Integer)newValue).intValue());
				return;
			case MetadataPackage.ORM_COLUMN__COLUMN_DEFINITION:
				setColumnDefinition((String)newValue);
				return;
			case MetadataPackage.ORM_COLUMN__COLUMN_DEFINITION_SPECIFIED:
				setColumnDefinitionSpecified(((Boolean)newValue).booleanValue());
				return;
			case MetadataPackage.ORM_COLUMN__ORIGINAL_COLUMN_DEFINITION:
				setOriginalColumnDefinition((String)newValue);
				return;
			case MetadataPackage.ORM_COLUMN__SRC_JOIN_PAIRS:
				getSrcJoinPairs().clear();
				getSrcJoinPairs().addAll((Collection)newValue);
				return;
			case MetadataPackage.ORM_COLUMN__DEST_JOIN_PAIRS:
				getDestJoinPairs().clear();
				getDestJoinPairs().addAll((Collection)newValue);
				return;
			case MetadataPackage.ORM_COLUMN__DATABASE_TYPE:
				setDatabaseType((String)newValue);
				return;
			case MetadataPackage.ORM_COLUMN__COMMENT:
				setComment((String)newValue);
				return;
			case MetadataPackage.ORM_COLUMN__RELATIVE_POSITION_IN_TABLE:
				setRelativePositionInTable(((Integer)newValue).intValue());
				return;
			case MetadataPackage.ORM_COLUMN__IDENTITY:
				setIdentity(((Boolean)newValue).booleanValue());
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.ORM_COLUMN__TABLE:
				setTable((OrmTable)null);
				return;
			case MetadataPackage.ORM_COLUMN__NAME:
				setName(NAME_EDEFAULT);
				return;
			case MetadataPackage.ORM_COLUMN__JDBC_TYPE:
				setJdbcType(JDBC_TYPE_EDEFAULT);
				return;
			case MetadataPackage.ORM_COLUMN__NULLABLE:
				setNullable(NULLABLE_EDEFAULT);
				return;
			case MetadataPackage.ORM_COLUMN__INSERTABLE:
				setInsertable(INSERTABLE_EDEFAULT);
				return;
			case MetadataPackage.ORM_COLUMN__UPDATABLE:
				setUpdatable(UPDATABLE_EDEFAULT);
				return;
			case MetadataPackage.ORM_COLUMN__LENGTH:
				setLength(LENGTH_EDEFAULT);
				return;
			case MetadataPackage.ORM_COLUMN__SCALE:
				setScale(SCALE_EDEFAULT);
				return;
			case MetadataPackage.ORM_COLUMN__COLUMN_DEFINITION:
				setColumnDefinition(COLUMN_DEFINITION_EDEFAULT);
				return;
			case MetadataPackage.ORM_COLUMN__COLUMN_DEFINITION_SPECIFIED:
				setColumnDefinitionSpecified(COLUMN_DEFINITION_SPECIFIED_EDEFAULT);
				return;
			case MetadataPackage.ORM_COLUMN__ORIGINAL_COLUMN_DEFINITION:
				setOriginalColumnDefinition(ORIGINAL_COLUMN_DEFINITION_EDEFAULT);
				return;
			case MetadataPackage.ORM_COLUMN__SRC_JOIN_PAIRS:
				getSrcJoinPairs().clear();
				return;
			case MetadataPackage.ORM_COLUMN__DEST_JOIN_PAIRS:
				getDestJoinPairs().clear();
				return;
			case MetadataPackage.ORM_COLUMN__DATABASE_TYPE:
				setDatabaseType(DATABASE_TYPE_EDEFAULT);
				return;
			case MetadataPackage.ORM_COLUMN__COMMENT:
				setComment(COMMENT_EDEFAULT);
				return;
			case MetadataPackage.ORM_COLUMN__RELATIVE_POSITION_IN_TABLE:
				setRelativePositionInTable(RELATIVE_POSITION_IN_TABLE_EDEFAULT);
				return;
			case MetadataPackage.ORM_COLUMN__IDENTITY:
				setIdentity(IDENTITY_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.ORM_COLUMN__TABLE:
				return table != null;
			case MetadataPackage.ORM_COLUMN__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case MetadataPackage.ORM_COLUMN__JDBC_TYPE:
				return jdbcType != JDBC_TYPE_EDEFAULT;
			case MetadataPackage.ORM_COLUMN__NULLABLE:
				return nullable != NULLABLE_EDEFAULT;
			case MetadataPackage.ORM_COLUMN__INSERTABLE:
				return insertable != INSERTABLE_EDEFAULT;
			case MetadataPackage.ORM_COLUMN__UPDATABLE:
				return updatable != UPDATABLE_EDEFAULT;
			case MetadataPackage.ORM_COLUMN__LENGTH:
				return length != LENGTH_EDEFAULT;
			case MetadataPackage.ORM_COLUMN__SCALE:
				return scale != SCALE_EDEFAULT;
			case MetadataPackage.ORM_COLUMN__COLUMN_DEFINITION:
				return COLUMN_DEFINITION_EDEFAULT == null ? columnDefinition != null : !COLUMN_DEFINITION_EDEFAULT.equals(columnDefinition);
			case MetadataPackage.ORM_COLUMN__COLUMN_DEFINITION_SPECIFIED:
				return columnDefinitionSpecified != COLUMN_DEFINITION_SPECIFIED_EDEFAULT;
			case MetadataPackage.ORM_COLUMN__ORIGINAL_COLUMN_DEFINITION:
				return ORIGINAL_COLUMN_DEFINITION_EDEFAULT == null ? originalColumnDefinition != null : !ORIGINAL_COLUMN_DEFINITION_EDEFAULT.equals(originalColumnDefinition);
			case MetadataPackage.ORM_COLUMN__SRC_JOIN_PAIRS:
				return srcJoinPairs != null && !srcJoinPairs.isEmpty();
			case MetadataPackage.ORM_COLUMN__DEST_JOIN_PAIRS:
				return destJoinPairs != null && !destJoinPairs.isEmpty();
			case MetadataPackage.ORM_COLUMN__DATABASE_TYPE:
				return DATABASE_TYPE_EDEFAULT == null ? databaseType != null : !DATABASE_TYPE_EDEFAULT.equals(databaseType);
			case MetadataPackage.ORM_COLUMN__COMMENT:
				return COMMENT_EDEFAULT == null ? comment != null : !COMMENT_EDEFAULT.equals(comment);
			case MetadataPackage.ORM_COLUMN__RELATIVE_POSITION_IN_TABLE:
				return relativePositionInTable != RELATIVE_POSITION_IN_TABLE_EDEFAULT;
			case MetadataPackage.ORM_COLUMN__IDENTITY:
				return identity != IDENTITY_EDEFAULT;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(", jdbcType: ");
		result.append(jdbcType);
		result.append(", nullable: ");
		result.append(nullable);
		result.append(", insertable: ");
		result.append(insertable);
		result.append(", updatable: ");
		result.append(updatable);
		result.append(", length: ");
		result.append(length);
		result.append(", scale: ");
		result.append(scale);
		result.append(", columnDefinition: ");
		result.append(columnDefinition);
		result.append(", columnDefinitionSpecified: ");
		result.append(columnDefinitionSpecified);
		result.append(", originalColumnDefinition: ");
		result.append(originalColumnDefinition);
		result.append(", databaseType: ");
		result.append(databaseType);
		result.append(", comment: ");
		result.append(comment);
		result.append(", relativePositionInTable: ");
		result.append(relativePositionInTable);
		result.append(", identity: ");
		result.append(identity);
		result.append(')');
		return result.toString();
	}

	public MetadataElement getParentElement() {
		return getTable();
	}

	public void delete() {
		if (srcJoinPairs != null) {
			for (int i = srcJoinPairs.size() - 1; i >= 0; i--) {
				((JoinPair)srcJoinPairs.get(i)).delete();				
			}
		}
		if (destJoinPairs != null) {
			for (int i = destJoinPairs.size() - 1; i >= 0; i--) {
				((JoinPair)destJoinPairs.get(i)).delete();				
			}
		}
		if (isPrimaryKey()) {
			getTable().getPrimaryKeyList().remove(this);
		}
		setTable(null);
		super.delete();
	}

} //OrmColumnImpl
