/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

/**
 * <copyright>
 * </copyright>
 *
 * $Id: SimpleTypeMetaDataImpl.java,v 1.12 2005/09/13 14:16:31 dtinker Exp $
 */
package org.eclipse.jsr220orm.metadata.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jsr220orm.metadata.EntityModel;
import org.eclipse.jsr220orm.metadata.MetadataPackage;
import org.eclipse.jsr220orm.metadata.OrmColumn;
import org.eclipse.jsr220orm.metadata.SimpleTypeMetaData;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Simple Type Meta Data</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.SimpleTypeMetaDataImpl#getColumn <em>Column</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SimpleTypeMetaDataImpl extends TypeMetaDataImpl implements SimpleTypeMetaData {
	/**
	 * The cached value of the '{@link #getColumn() <em>Column</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getColumn()
	 * @generated
	 * @ordered
	 */
	protected OrmColumn column = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SimpleTypeMetaDataImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return MetadataPackage.eINSTANCE.getSimpleTypeMetaData();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OrmColumn getColumn() {
		if (column != null && column.eIsProxy()) {
			OrmColumn oldColumn = column;
			column = (OrmColumn)eResolveProxy((InternalEObject)column);
			if (column != oldColumn) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, MetadataPackage.SIMPLE_TYPE_META_DATA__COLUMN, oldColumn, column));
			}
		}
		return column;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OrmColumn basicGetColumn() {
		return column;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setColumn(OrmColumn newColumn) {
		OrmColumn oldColumn = column;
		column = newColumn;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.SIMPLE_TYPE_META_DATA__COLUMN, oldColumn, column));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case MetadataPackage.SIMPLE_TYPE_META_DATA__ENTITY_MODEL:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, MetadataPackage.SIMPLE_TYPE_META_DATA__ENTITY_MODEL, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case MetadataPackage.SIMPLE_TYPE_META_DATA__ENTITY_MODEL:
					return eBasicSetContainer(null, MetadataPackage.SIMPLE_TYPE_META_DATA__ENTITY_MODEL, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case MetadataPackage.SIMPLE_TYPE_META_DATA__ENTITY_MODEL:
					return eContainer.eInverseRemove(this, MetadataPackage.ENTITY_MODEL__TYPE_LIST, EntityModel.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return eContainer.eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.SIMPLE_TYPE_META_DATA__ENTITY_MODEL:
				return getEntityModel();
			case MetadataPackage.SIMPLE_TYPE_META_DATA__CLASS_NAME:
				return getClassName();
			case MetadataPackage.SIMPLE_TYPE_META_DATA__CLS:
				return getCls();
			case MetadataPackage.SIMPLE_TYPE_META_DATA__COLUMN:
				if (resolve) return getColumn();
				return basicGetColumn();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.SIMPLE_TYPE_META_DATA__ENTITY_MODEL:
				setEntityModel((EntityModel)newValue);
				return;
			case MetadataPackage.SIMPLE_TYPE_META_DATA__CLASS_NAME:
				setClassName((String)newValue);
				return;
			case MetadataPackage.SIMPLE_TYPE_META_DATA__CLS:
				setCls((Class)newValue);
				return;
			case MetadataPackage.SIMPLE_TYPE_META_DATA__COLUMN:
				setColumn((OrmColumn)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.SIMPLE_TYPE_META_DATA__ENTITY_MODEL:
				setEntityModel((EntityModel)null);
				return;
			case MetadataPackage.SIMPLE_TYPE_META_DATA__CLASS_NAME:
				setClassName(CLASS_NAME_EDEFAULT);
				return;
			case MetadataPackage.SIMPLE_TYPE_META_DATA__CLS:
				setCls(CLS_EDEFAULT);
				return;
			case MetadataPackage.SIMPLE_TYPE_META_DATA__COLUMN:
				setColumn((OrmColumn)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.SIMPLE_TYPE_META_DATA__ENTITY_MODEL:
				return getEntityModel() != null;
			case MetadataPackage.SIMPLE_TYPE_META_DATA__CLASS_NAME:
				return CLASS_NAME_EDEFAULT == null ? className != null : !CLASS_NAME_EDEFAULT.equals(className);
			case MetadataPackage.SIMPLE_TYPE_META_DATA__CLS:
				return CLS_EDEFAULT == null ? cls != null : !CLS_EDEFAULT.equals(cls);
			case MetadataPackage.SIMPLE_TYPE_META_DATA__COLUMN:
				return column != null;
		}
		return eDynamicIsSet(eFeature);
	}

} //SimpleTypeMetaDataImpl
