/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.adapters;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jsr220orm.core.nature.OrmNature;
import org.eclipse.jsr220orm.metadata.EntityModel;
import org.eclipse.jsr220orm.metadata.TypeMetaData;
import org.eclipse.ui.IActionFilter;

public class ActionFilterAdapterFactory implements IAdapterFactory, IActionFilter {

    
    private ICompilationUnit unit;

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        unit = (ICompilationUnit)adaptableObject;
        return this;
    }

    public Class[] getAdapterList() {
        return new Class[]{IActionFilter.class};
    }

    public boolean testAttribute(Object target, String name, String value) {
        if(!"isPersistent".equals(name) && !"canBePersistent".equals(name)){
            return false;
        }
        IJavaProject javaProject = (IJavaProject) unit.getAncestor(IJavaElement.JAVA_PROJECT); 
        IProject project = javaProject.getProject(); 
        try{
            if(project.hasNature(OrmNature.ID)){
                OrmNature nature = (OrmNature) project.getNature(OrmNature.ID);
                String fullyQualifiedName = unit.findPrimaryType().getFullyQualifiedName();
                EntityModel model = nature.getActiveOrmProject().getModel();
                TypeMetaData tmd = model.findTypeByClassName(fullyQualifiedName);
                if(tmd == null){
                    if("canBePersistent".equals(name)){
                        return "true".equals(value);
                    }
                    if("isPersistent".equals(name)){
                        return !"true".equals(value);
                    }
                }
            }
        }catch(Exception x){
        }
        if("canBePersistent".equals(name)){
            return !"true".equals(value);
        }
        if("isPersistent".equals(name)){
            return "true".equals(value);
        }
        return false;
    }

}
