/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.binding;

import java.util.Collection;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.jsr220orm.core.IEntityModelManager;
import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.metadata.MetadataPackage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Widget;

public class EntUseDiscriminatorBinding extends EmfAbstractBinding implements SelectionListener{
    private Button button;
    private Runnable lastTask;
    /* (non-Javadoc)
     * @see org.eclipse.jsr220orm.ui.internal.binding.IEmfWidgetBinding#bind(org.eclipse.emf.common.notify.AdapterFactory, org.eclipse.swt.widgets.Widget, int)
     */
    public void bind(AdapterFactory adapterFactory, Widget widget) {
        super.bind(adapterFactory, widget, MetadataPackage.ENTITY_META_DATA__DISCRIMINATOR_COLUMN);
        this.button = (Button) widget;
    }

    protected void installListeners() {
        super.installListeners();
        button.addSelectionListener(this);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        button.removeSelectionListener(this);
    }

    protected void setValueFromModel(IItemLabelProvider labelProvider, Object value) {
        EntityMetaData entity = (EntityMetaData) getTarget();
        IEntityModelManager emm = (IEntityModelManager) entity.adapt(IEntityModelManager.class);
        button.setSelection(entity.getDiscriminatorColumn() != null);
        if (emm != null) {
        	button.setEnabled(emm.isUseDiscriminatorColumnEnabled(entity));
        }
    }

    protected void setChoicesFromModel(IItemLabelProvider provider, Collection choices) {
    }

    public void widgetSelected(SelectionEvent e) {
        EntityMetaData entity = (EntityMetaData) getTarget();
        IEntityModelManager emm = (IEntityModelManager) entity.adapt(IEntityModelManager.class);
        emm.setUseDiscriminatorColumn(entity, button.getSelection());
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}
