/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.diagram.er.figure;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class DropShadowBorder extends AbstractBorder {

    protected Insets insets = new Insets(1, 1, 5, 5);

    private static final Color 
            highlight = ColorConstants.menuBackgroundSelected,
            dropshadow = Display.getCurrent().getSystemColor(SWT.COLOR_WIDGET_NORMAL_SHADOW);

    /**
     * Returns the space used by the border for the figure provided as input. In
     * this border all sides always have equal width.
     * 
     * @param figure
     *            Figure for which this is the border.
     * @return Insets for this border.
     */
    public Insets getInsets(IFigure figure) {
        return insets;
    }

    public boolean isOpaque() {
        return false;
    }

    public void paint(IFigure figure, Graphics g, Insets insets) {
        Rectangle r = getPaintRectangle(figure, insets);
        r.width -= 5;
        r.height -= 5;

        g.setLineWidth(1);
        g.setForegroundColor(ColorConstants.black);
        g.drawRoundRectangle(r,9,9);

        g.setForegroundColor(dropshadow);
        g.drawLine(r.right()-2, r.bottom(), r.right()+1, r.bottom());
        g.drawLine(r.right(), r.bottom()-2, r.right(), r.bottom()+1);
        r.translate(1,1);
        int pos = 4;
        int length = 2;
        g.drawLine(r.x+pos, r.bottom(), r.right()+length, r.bottom());
        g.drawLine(r.right(), r.y+pos, r.right(), r.bottom()+length);
        r.translate(1,1);
//        g.setAlpha(200);
        pos--;
        length--;
        g.setForegroundColor(new Color(null, dropshadow.getRed()+25, dropshadow.getGreen()+25, dropshadow.getBlue()+25));
        g.drawLine(r.x+pos, r.bottom(), r.right()+length, r.bottom());
        g.drawLine(r.right(), r.y+pos, r.right(), r.bottom()+length);
//        g.setAlpha(80);
        pos++;
        length -= 2;
        g.setForegroundColor(new Color(null, dropshadow.getRed()+50, dropshadow.getGreen()+50, dropshadow.getBlue()+50));
        g.drawLine(r.x+pos, r.bottom()+1, r.right()+length, r.bottom()+1);
        g.drawLine(r.right()+1, r.y+pos, r.right()+1, r.bottom()+length);
//        r.translate(2,2);
//        length -= 4;
//        g.drawLine(r.x+pos, r.bottom(), r.right()+length, r.bottom());
//        g.drawLine(r.right(), r.y+pos, r.right(), r.bottom()+length);
    }
}
