/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.diagram.er.figure;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;

public class EmptyBorder implements Border {

    private  Insets insets ;
    
    public static final EmptyBorder INSTANCE = new EmptyBorder(1,1,1,1);
    
    public EmptyBorder(int top, int left, int bottom, int right){
        insets = new Insets(top,left,bottom,right);
    }
    
    public Insets getInsets(IFigure figure) {
        return insets;
    }

    public Dimension getPreferredSize(IFigure figure) {
        return null;
    }

    public boolean isOpaque() {
        return false;
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
    }

}
