/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

/*
 * Created on Jul 13, 2004
 */
package org.eclipse.jsr220orm.ui.internal.diagram.er.layout;

import java.util.List;
import java.util.Map;

import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jsr220orm.ui.internal.diagram.er.part.ColumnListEditPart;

/**
 * Uses the DirectedGraphLayoutVisitor to automatically lay out figures on diagram
 * @author Phil Zoio
 */
public class GraphLayoutManager extends AbstractLayout
{

	private ColumnListEditPart diagram;
	private Map figureToBoundsMap;
	private Map partsToNodeMap;

	public GraphLayoutManager(ColumnListEditPart diagram)
	{
		this.diagram = diagram;
	}

	
	protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint)
	{		
		container.validate();
		List children = container.getChildren();
		Rectangle result = new Rectangle().setLocation(container.getClientArea().getLocation());
		for (int i = 0; i < children.size(); i++)
			result.union(((IFigure) children.get(i)).getBounds());
		result.resize(container.getInsets().getWidth(), container.getInsets().getHeight());
		return result.getSize();		
	}

	
	public void layout(IFigure container)
	{
		new DirectedGraphLayoutVisitor().layoutDiagram(diagram);
	}
	
}