/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.diagram.er.part;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.jsr220orm.metadata.JoinPair;
import org.eclipse.jsr220orm.metadata.MetadataPackage;
import org.eclipse.jsr220orm.metadata.OrmColumn;
import org.eclipse.jsr220orm.ui.internal.diagram.er.ColumnConnectionAnchor;
import org.eclipse.jsr220orm.ui.internal.diagram.er.edit.OrmColumnDragPolicy;
import org.eclipse.jsr220orm.ui.internal.diagram.er.figure.ColumnFigure;

/**
 * @author dirk
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ColumnEditPart extends MetadataEditPart implements NodeEditPart{
  
    private Set colSet;

    /**
     * @param object
     */
    public ColumnEditPart(Set colSet, Object model) {
        this.colSet = colSet;
        setModel(model);
    }

    public IFigure createFigure() {
        TableEditPart tableEditPart = (TableEditPart) getParent();
        return new ColumnFigure(tableEditPart.getOrmCols(), tableEditPart.getRdbCols(), 
                tableEditPart.isConnected());
    }
    
    protected void createEditPolicies() {
        installEditPolicy(EditPolicy.COMPONENT_ROLE, new OrmColumnDragPolicy());
    }

    protected void refreshVisuals() {
        refreshVisuals(getFigure());
    }
        
    public void refreshVisuals(IFigure figure) {
        OrmColumn c = (OrmColumn)getModel();
        ColumnFigure cf = (ColumnFigure)figure;
        cf.setPrimaryKey(c.isPrimaryKey());
        cf.setName(c.getName());
        cf.setType(c.getDatabaseType());
        cf.setToolTipText(c.getComment());
    }

    public void setSelected(int value)
    {
        super.setSelected(value);
        ColumnFigure figure = (ColumnFigure) getFigure();
        if (value != EditPart.SELECTED_NONE)
            figure.setSelected(true);
        else
            figure.setSelected(false);
    }
   
    protected List getModelSourceConnections() {
        OrmColumn column = (OrmColumn)getModel();
        ArrayList joinList = new ArrayList(column.getSrcJoinPairs());
        for(Iterator pairs = joinList.iterator(); pairs.hasNext();){
            JoinPair pair = (JoinPair)pairs.next();
            if(!colSet.contains(pair.getSrc()) || !colSet.contains(pair.getDest())){
                pairs.remove();
            }
        }
        return joinList;
    }
    
    protected List getModelTargetConnections() {
        OrmColumn column = (OrmColumn)getModel();
        ArrayList joinList = new ArrayList(column.getDestJoinPairs());
        for(Iterator pairs = joinList.iterator(); pairs.hasNext();){
            JoinPair pair = (JoinPair)pairs.next();
            if(!colSet.contains(pair.getSrc()) || !colSet.contains(pair.getDest())){
                pairs.remove();
            }
        }
        return joinList;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        JoinPair joinPair = (JoinPair)connection.getModel();
        return new ColumnConnectionAnchor(getFigure());
    }
    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ColumnConnectionAnchor(getFigure());
    }
    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new ColumnConnectionAnchor(getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new ColumnConnectionAnchor(getFigure());
    }

    public void notifyChanged(Notification notification) {
        if(notification.getEventType() == Notification.REMOVING_ADAPTER){
            return;
        }
        if(notification.getFeatureID(OrmColumn.class) == MetadataPackage.ORM_COLUMN__NAME){
            try{
                getParent().refresh();
            }catch(Exception x){
                //Do nothing, parent may have been remove because of change
            }
        }
        super.notifyChanged(notification);
    }

}