/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.diagram.er.part;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RequestConstants;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

/**
 * @author dirk
 * 
 */
public class DotDotDotColumnEditPart extends AbstractGraphicalEditPart {

    /**
     * @param object
     */
    public DotDotDotColumnEditPart(Object model) {
        setModel(model);
    }

    protected IFigure createFigure() {
        return new Label("...");
    }

    protected void createEditPolicies() {
    }

    public void setSelected(int value) {
        if(value != SELECTED_NONE){
            addCols();
        }
    }

    /**
     * @see org.eclipse.gef.EditPart#performRequest(org.eclipse.gef.Request)
     */
    public void performRequest(Request request) {
        if (request.getType() == RequestConstants.REQ_DIRECT_EDIT
                || request.getType() == RequestConstants.REQ_OPEN) {
            addCols();
        }
    }

    private void addCols() {
        EditPart parent = getParent();
        if (parent instanceof TableEditPart) {
            TableEditPart editPart = (TableEditPart) parent;
            editPart.expandDots();
        }
    }
}