/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.mapping;

import org.eclipse.jsr220orm.metadata.AttributeMetaData;
import org.eclipse.jsr220orm.metadata.MetadataElement;
import org.eclipse.jsr220orm.ui.mapping.MappingUIProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AttributeMappingUIProvider implements MappingUIProvider {

    AttributeBook attributeBook;

	public Control getControl(MetadataElement element, Composite parent, FormToolkit toolkit) {
		if (attributeBook == null) {
			attributeBook = new AttributeBook();
            attributeBook.createPartControl(parent, toolkit);
		}
		attributeBook.setAttributeMetaData((AttributeMetaData) element);
		return attributeBook.getControl();
	}

}
