/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.perspective;

import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jsr220orm.ui.internal.views.LiveErView;
import org.eclipse.jsr220orm.ui.internal.views.MappingView;
import org.eclipse.jsr220orm.ui.internal.views.PersistenceOutline;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.progress.IProgressConstants;

public class ORMPerspectiveFactory implements IPerspectiveFactory {
	public static final String ID = "org.eclipse.jsr220orm.ui.internal.perspective";

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IPerspectiveFactory#createInitialLayout(org.eclipse.ui.IPageLayout)
	 */
	public void createInitialLayout(IPageLayout layout) {
//		layout.addPerspectiveShortcut("org.eclipse.ui.resourcePerspective");
//		layout.addPerspectiveShortcut("org.eclipse.jsr220orm.ui.internal.perspective");
////        layout.addActionSet(IDebugUIConstants.LAUNCH_ACTION_SET);
//        layout.addActionSet(JavaUI.ID_ACTION_SET);
//        layout.addActionSet(JavaUI.ID_ELEMENT_CREATION_ACTION_SET);
//        layout.addActionSet(IPageLayout.ID_NAVIGATE_ACTION_SET);
//
//		String editorArea = layout.getEditorArea();
//
//		IFolderLayout leftTop = layout.createFolder("leftTop", IPageLayout.LEFT,
//				(float) 0.30, editorArea);
//        leftTop.addView(JavaUI.ID_PACKAGES);
//        leftTop.addPlaceholder(IPageLayout.ID_RES_NAV);
//
//        IFolderLayout leftBottom = layout.createFolder("leftBottom", IPageLayout.BOTTOM,
//                (float) 0.5, "leftTop");
//        leftBottom.addView(MappingView.ID_VIEW);
//        leftBottom.addView(IPageLayout.ID_PROP_SHEET);
//
//        IFolderLayout bottom = layout.createFolder(
//                "bottom", IPageLayout.BOTTOM, (float) 0.6, editorArea); //$NON-NLS-1$
//        bottom.addView(LiveErView.ID_VIEW);
//        bottom.addView("org.eclipse.pde.runtime.LogView");
//        bottom.addView(IPageLayout.ID_PROBLEM_VIEW);
//
//        IFolderLayout rightFolder = layout.createFolder("right", IPageLayout.RIGHT,
//                (float) 0.7, editorArea);
//        rightFolder.addView(IPageLayout.ID_OUTLINE);
        String editorArea = layout.getEditorArea();
        
        IFolderLayout leftTop= layout.createFolder("leftTop", IPageLayout.LEFT, (float)0.3, editorArea); //$NON-NLS-1$
        leftTop.addView(JavaUI.ID_PACKAGES);
        leftTop.addView(JavaUI.ID_TYPE_HIERARCHY);
        leftTop.addPlaceholder(IPageLayout.ID_RES_NAV);
        IFolderLayout leftBottom = layout.createFolder("leftBottom", IPageLayout.BOTTOM, (float) 0.4, "leftTop");
        leftBottom.addView(MappingView.ID_VIEW);
        
        IFolderLayout outputfolder= layout.createFolder("bottom", IPageLayout.BOTTOM, (float)0.55, editorArea); //$NON-NLS-1$
        outputfolder.addView(LiveErView.ID_VIEW);
        outputfolder.addView(IPageLayout.ID_PROBLEM_VIEW);
        outputfolder.addView(JavaUI.ID_JAVADOC_VIEW);
        outputfolder.addView(JavaUI.ID_SOURCE_VIEW);
        outputfolder.addView("org.eclipse.wst.rdb.server.ui.navigator.serverExplorer");
        outputfolder.addPlaceholder(IPageLayout.ID_BOOKMARKS);
        outputfolder.addPlaceholder(IProgressConstants.PROGRESS_VIEW_ID);
        
        IFolderLayout outlinefolder= layout.createFolder("right", IPageLayout.RIGHT, (float)0.6, editorArea); //$NON-NLS-1$
        outlinefolder.addView(PersistenceOutline.ID);
        outlinefolder.addView(IPageLayout.ID_OUTLINE);
        
        layout.addActionSet(JavaUI.ID_ACTION_SET);
        layout.addActionSet(JavaUI.ID_ELEMENT_CREATION_ACTION_SET);
        layout.addActionSet(IPageLayout.ID_NAVIGATE_ACTION_SET);
        
        // views - java
        layout.addShowViewShortcut(JavaUI.ID_PACKAGES);
        layout.addShowViewShortcut(JavaUI.ID_TYPE_HIERARCHY);
        layout.addShowViewShortcut(JavaUI.ID_SOURCE_VIEW);
        layout.addShowViewShortcut(JavaUI.ID_JAVADOC_VIEW);

        // views - standard workbench
        layout.addShowViewShortcut(IPageLayout.ID_OUTLINE);
        layout.addShowViewShortcut(IPageLayout.ID_PROBLEM_VIEW);
        layout.addShowViewShortcut(IPageLayout.ID_RES_NAV);
                
        // new actions - Java project creation wizard
        layout.addNewWizardShortcut("org.eclipse.jdt.ui.wizards.NewPackageCreationWizard"); //$NON-NLS-1$
        layout.addNewWizardShortcut("org.eclipse.jdt.ui.wizards.NewClassCreationWizard"); //$NON-NLS-1$
        layout.addNewWizardShortcut("org.eclipse.jdt.ui.wizards.NewInterfaceCreationWizard"); //$NON-NLS-1$
        layout.addNewWizardShortcut("org.eclipse.jdt.ui.wizards.NewEnumCreationWizard"); //$NON-NLS-1$
        layout.addNewWizardShortcut("org.eclipse.jdt.ui.wizards.NewAnnotationCreationWizard"); //$NON-NLS-1$
        layout.addNewWizardShortcut("org.eclipse.jdt.ui.wizards.NewSourceFolderCreationWizard");     //$NON-NLS-1$
        layout.addNewWizardShortcut("org.eclipse.jdt.ui.wizards.NewSnippetFileCreationWizard"); //$NON-NLS-1$
        layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.folder");//$NON-NLS-1$
        layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.file");//$NON-NLS-1$
        layout.addNewWizardShortcut("org.eclipse.ui.editors.wizards.UntitledTextFileWizard");//$NON-NLS-1$
	}

}
