/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.tests.adapters.java;

import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.dali.core.DaliPlugin;
import org.eclipse.dali.core.tests.projects.MappedSuperclassTestProject;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.dali.internal.utility.ClassTools;
import org.eclipse.dali.orm.AttributeOverride;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.PersistenceFile;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.adapters.java.JavaAttributeOverrideModelAdapter;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;

public class JavaAttributeOverrideColumnModelAdapterTests
extends TestCase {
    private MappedSuperclassTestProject project;
    private PersistentType employeePersistentType;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.core.tests.adapters.java.JavaAttributeOverrideColumnModelAdapterTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public JavaAttributeOverrideColumnModelAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.project = new MappedSuperclassTestProject();
        this.project.setPersistenceNature();
        PersistenceFile employeePersistenceFile = DaliPlugin.getPersistenceFile((IFile)((IFile)this.project.getEmployeeType().getCompilationUnit().getResource()));
        this.employeePersistentType = (PersistentType)employeePersistenceFile.getPersistentTypes().get(0);
    }

    protected void tearDown() throws Exception {
        this.employeePersistentType = null;
        this.project.dispose();
        super.tearDown();
    }

    public void testSetTableNameInPersistenceModelUpdatesJava() {
        Entity employeeEntity = (Entity)this.employeePersistentType.getTypeMapping();
        AttributeOverride nameOverride = (AttributeOverride)employeeEntity.getAttributeOverrides().get(1);
        JavaAttributeOverrideModelAdapter attributeOverrideModelAdapter = (JavaAttributeOverrideModelAdapter)nameOverride.getModelAdapter();
        Member member = (Member)ClassTools.getFieldValue((Object)attributeOverrideModelAdapter, (String)"member");
        JavaAttributeOverrideColumnModelAdapterTests.assertFalse((boolean)member.containsAnnotation("AttributeOverride"));
        nameOverride.getColumn().setSpecifiedTableName("SALARY");
        NormalAnnotation annotation = (NormalAnnotation)member.getAnnotation("AttributeOverride");
        JavaAttributeOverrideColumnModelAdapterTests.assertNotNull((Object)annotation);
        JavaAttributeOverrideColumnModelAdapterTests.assertEquals((String)"Annotation should have 2 annotation elements: name and column", (int)2, (int)((List)annotation.getStructuralProperty((StructuralPropertyDescriptor)NormalAnnotation.VALUES_PROPERTY)).size());
        MemberValuePair nameValuePair = ASTTools.memberValuePair((NormalAnnotation)annotation, (String)"name");
        JavaAttributeOverrideColumnModelAdapterTests.assertEquals((String)"name", (String)((StringLiteral)nameValuePair.getValue()).getLiteralValue());
        MemberValuePair columnValuePair = ASTTools.memberValuePair((NormalAnnotation)annotation, (String)"column");
        NormalAnnotation columnAnnotation = (NormalAnnotation)columnValuePair.getValue();
        JavaAttributeOverrideColumnModelAdapterTests.assertEquals((String)"SALARY", (String)((StringLiteral)ASTTools.memberValuePair((NormalAnnotation)columnAnnotation, (String)"table").getValue()).getLiteralValue());
        JavaAttributeOverrideColumnModelAdapterTests.assertNull((String)"name annotation element should not have been specified", (Object)ASTTools.memberValuePair((NormalAnnotation)columnAnnotation, (String)"name"));
        nameOverride.getColumn().setSpecifiedTableName("SALARY2");
        annotation = (NormalAnnotation)member.getAnnotation("AttributeOverride");
        columnValuePair = ASTTools.memberValuePair((NormalAnnotation)annotation, (String)"column");
        columnAnnotation = (NormalAnnotation)columnValuePair.getValue();
        JavaAttributeOverrideColumnModelAdapterTests.assertEquals((String)"SALARY2", (String)((StringLiteral)ASTTools.memberValuePair((NormalAnnotation)columnAnnotation, (String)"table").getValue()).getLiteralValue());
        nameOverride.getColumn().setSpecifiedTableName(null);
        JavaAttributeOverrideColumnModelAdapterTests.assertFalse((boolean)member.containsAnnotation("AttributeOverride"));
        nameOverride.getColumn().setSpecifiedTableName("SALARY");
        nameOverride.getColumn().setSpecifiedName("MY_SALARY");
        nameOverride.getColumn().setSpecifiedTableName(null);
        annotation = (NormalAnnotation)member.getAnnotation("AttributeOverride");
        JavaAttributeOverrideColumnModelAdapterTests.assertNotNull((String)"Should contain the AttributeOverride annotation", (Object)annotation);
        columnValuePair = ASTTools.memberValuePair((NormalAnnotation)annotation, (String)"column");
        columnAnnotation = (NormalAnnotation)columnValuePair.getValue();
        JavaAttributeOverrideColumnModelAdapterTests.assertEquals((String)"MY_SALARY", (String)((StringLiteral)ASTTools.memberValuePair((NormalAnnotation)columnAnnotation, (String)"name").getValue()).getLiteralValue());
        nameOverride.getColumn().setSpecifiedName(null);
        JavaAttributeOverrideColumnModelAdapterTests.assertFalse((boolean)member.containsAnnotation("AttributeOverride"));
        nameOverride.getColumn().setSpecifiedTableName("SALARY");
        nameOverride.getColumn().setSpecifiedName("MY_SALARY");
        nameOverride.getColumn().setSpecifiedName(null);
        annotation = (NormalAnnotation)member.getAnnotation("AttributeOverride");
        JavaAttributeOverrideColumnModelAdapterTests.assertNotNull((String)"Should contain the AttributeOverride annotation", (Object)annotation);
        columnValuePair = ASTTools.memberValuePair((NormalAnnotation)annotation, (String)"column");
        columnAnnotation = (NormalAnnotation)columnValuePair.getValue();
        JavaAttributeOverrideColumnModelAdapterTests.assertEquals((String)"SALARY", (String)((StringLiteral)ASTTools.memberValuePair((NormalAnnotation)columnAnnotation, (String)"table").getValue()).getLiteralValue());
        nameOverride.getColumn().setSpecifiedTableName(null);
        JavaAttributeOverrideColumnModelAdapterTests.assertFalse((boolean)member.containsAnnotation("AttributeOverride"));
    }
}

