/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.tests.adapters.java;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.dali.core.DaliPlugin;
import org.eclipse.dali.core.tests.projects.SimpleTestProject;
import org.eclipse.dali.core.util.jdt.JDTTools;
import org.eclipse.dali.internal.utility.ClassTools;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.FetchTypeDefaultEager;
import org.eclipse.dali.orm.NullTypeMapping;
import org.eclipse.dali.orm.OneToOneMapping;
import org.eclipse.dali.orm.PersistenceFile;
import org.eclipse.dali.orm.PersistentAttribute;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.adapters.java.Attribute;
import org.eclipse.dali.orm.adapters.java.EnumAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.JavaOneToOneMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaPersistentAttributeModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaPersistentTypeModelAdapter;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.QualifiedName;

public class JavaOneToOneMappingModelAdapterTests
extends TestCase {
    private SimpleTestProject project;
    private PersistentType testClassType;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.core.tests.adapters.java.JavaOneToOneMappingModelAdapterTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public JavaOneToOneMappingModelAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.project = new SimpleTestProject();
        this.project.setPersistenceNature();
        PersistenceFile persistenceFile = DaliPlugin.getPersistenceFile((IFile)((IFile)this.project.getTestClassType().getCompilationUnit().getResource()));
        this.testClassType = (PersistentType)persistenceFile.getPersistentTypes().get(0);
        this.testClassType.setTypeMappingKey((TypeMapping.Key)Entity.Key.INSTANCE);
    }

    protected void tearDown() throws Exception {
        this.testClassType.setTypeMappingKey((TypeMapping.Key)NullTypeMapping.Key.INSTANCE);
        this.testClassType = null;
        this.project.dispose();
        super.tearDown();
    }

    public void testFetchTypeSourceUpdatesFromPersistenceModelChanges() throws JavaModelException {
        IField field = this.project.getTestClassField();
        IType type = this.project.getTestClassType();
        PersistentAttribute persAttribute = JavaPersistentTypeModelAdapter.persistentAttributeFor((PersistentType)this.testClassType, (IMember)field);
        JavaPersistentAttributeModelAdapter mappingModelAdapter = (JavaPersistentAttributeModelAdapter)persAttribute.getModelAdapter();
        Attribute attribute = (Attribute)ClassTools.getFieldValue((Object)mappingModelAdapter, (String)"attribute");
        persAttribute.setAttributeMappingKey("oneToOne", false);
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persAttribute.getAttributeMapping();
        oneToOneMapping.setFetchType(FetchTypeDefaultEager.EAGER_LITERAL);
        CompilationUnit astRoot = JDTTools.createASTRoot((IMember)type);
        JavaOneToOneMappingModelAdapterTests.assertTrue((boolean)attribute.containsAnnotationElement("OneToOne", "fetch", astRoot));
        NormalAnnotation annotation = (NormalAnnotation)mappingModelAdapter.getAnnotation("OneToOne", astRoot);
        MemberValuePair valuePair = (MemberValuePair)annotation.values().get(0);
        QualifiedName qualifiedName = (QualifiedName)valuePair.getValue();
        JavaOneToOneMappingModelAdapterTests.assertTrue((boolean)qualifiedName.getFullyQualifiedName().equals("FetchType.EAGER"));
        JavaOneToOneMappingModelAdapterTests.assertTrue((String)"javax.persistence.FetchType import was not added", (boolean)type.getCompilationUnit().getImport("javax.persistence.FetchType").exists());
        oneToOneMapping.setFetchType(FetchTypeDefaultEager.LAZY_LITERAL);
        astRoot = JDTTools.createASTRoot((IMember)type);
        JavaOneToOneMappingModelAdapterTests.assertTrue((boolean)attribute.containsAnnotationElement("OneToOne", "fetch", astRoot));
        annotation = (NormalAnnotation)mappingModelAdapter.getAnnotation("OneToOne", astRoot);
        valuePair = (MemberValuePair)annotation.values().get(0);
        qualifiedName = (QualifiedName)valuePair.getValue();
        JavaOneToOneMappingModelAdapterTests.assertTrue((boolean)qualifiedName.getFullyQualifiedName().equals("FetchType.LAZY"));
        oneToOneMapping.setFetchType(FetchTypeDefaultEager.DEFAULT_LITERAL);
        astRoot = JDTTools.createASTRoot((IMember)type);
        JavaOneToOneMappingModelAdapterTests.assertTrue((boolean)attribute.containsAnnotation("OneToOne", astRoot));
        JavaOneToOneMappingModelAdapterTests.assertFalse((boolean)attribute.containsAnnotationElement("OneToOne", "fetch", astRoot));
    }

    public void testFetchTypeComboBoxUpdatesFromSourceChanges() throws JavaModelException {
        IField field = this.project.getTestClassField();
        PersistentAttribute persistentAttribute = JavaPersistentTypeModelAdapter.persistentAttributeFor((PersistentType)this.testClassType, (IMember)field);
        persistentAttribute.setAttributeMappingKey("oneToOne", false);
        OneToOneMapping oneMapping = (OneToOneMapping)persistentAttribute.getAttributeMapping();
        JavaOneToOneMappingModelAdapter typeModelAdapter = (JavaOneToOneMappingModelAdapter)persistentAttribute.getAttributeMapping().getModelAdapter();
        EnumAnnotationElementAdapter enumAdapter = (EnumAnnotationElementAdapter)ClassTools.getFieldValue((Object)typeModelAdapter, (String)"fetchTypeAdapter");
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassTools.invokeMethod((Object)enumAdapter, (String)"setJavaValue", (Class)clazz, (Object)"EAGER");
        JavaOneToOneMappingModelAdapterTests.assertEquals((Object)FetchTypeDefaultEager.EAGER_LITERAL, (Object)oneMapping.getFetchType());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassTools.invokeMethod((Object)enumAdapter, (String)"setJavaValue", (Class)clazz2, (Object)"LAZY");
        JavaOneToOneMappingModelAdapterTests.assertEquals((Object)FetchTypeDefaultEager.LAZY_LITERAL, (Object)oneMapping.getFetchType());
        typeModelAdapter.removeAnnotationElementNamed("OneToOne", "fetch");
        JavaOneToOneMappingModelAdapterTests.assertEquals((Object)FetchTypeDefaultEager.DEFAULT_LITERAL, (Object)oneMapping.getFetchType());
    }
}

