/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.tests.model;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dali.core.tests.junitx.TestCase;
import org.eclipse.dali.core.tests.projects.TestDaliProject;
import org.eclipse.dali.internal.utility.ClassTools;
import org.eclipse.dali.orm.PersistenceFolder;
import org.eclipse.dali.orm.PersistenceProject;

public class PersistenceProjectTests
extends TestCase {
    private TestDaliProject project;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.core.tests.model.PersistenceProjectTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public PersistenceProjectTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.project = new TestDaliProject(true);
        this.project.createFolder("empty");
        this.project.createFile((IContainer)this.project.createFolder("non-src"), "NonSourceType.java", "public class NonSourceType {}");
        this.project.createFile((IContainer)this.project.createFolder("src"), "SourceType.java", "public class SourceType {}");
        this.project.setPersistenceNature();
        PersistenceProject persistenceProject = (PersistenceProject)this.project.getProject().getNature("org.eclipse.dali.core.persistenceNature");
        while (!this.projectIsConstructed(persistenceProject)) {
            Thread.sleep(500L);
            this.waitForJobs();
        }
    }

    private boolean projectIsConstructed(PersistenceProject pp) {
        Boolean constructed = (Boolean)ClassTools.invokeMethod((Object)pp, (String)"isConstructed");
        return constructed;
    }

    protected void tearDown() throws Exception {
        this.project.dispose();
        super.tearDown();
    }

    public void testProjectConstruction() throws CoreException {
        PersistenceProjectTests.assertTrue((boolean)this.project.getProject().hasNature("org.eclipse.dali.core.persistenceNature"));
        PersistenceProject pProject = this.project.getPersistenceProject();
        PersistenceProjectTests.assertTrue((!pProject.getPersistenceResources().isEmpty() ? 1 : 0) != 0);
        PersistenceProjectTests.assertEquals((int)2, (int)pProject.getPersistenceResources().size());
        PersistenceProjectTests.assertNotNull((Object)pProject.getPersistenceFile((IPath)new Path("non-src/NonSourceType.java")));
        PersistenceProjectTests.assertNotNull((Object)pProject.getPersistenceFile((IPath)new Path("src/SourceType.java")));
        this.project.closeProject();
        this.project.openProject();
        pProject = this.project.getPersistenceProject();
        PersistenceProjectTests.assertTrue((!pProject.getPersistenceResources().isEmpty() ? 1 : 0) != 0);
        PersistenceProjectTests.assertEquals((int)2, (int)pProject.getPersistenceResources().size());
        PersistenceProjectTests.assertNotNull((Object)pProject.getPersistenceFile((IPath)new Path("non-src/NonSourceType.java")));
        PersistenceProjectTests.assertNotNull((Object)pProject.getPersistenceFile((IPath)new Path("src/SourceType.java")));
    }

    public void testProjectUpdate() throws CoreException {
        PersistenceProject pProject = this.project.getPersistenceProject();
        PersistenceFolder pFolder = pProject.getPersistenceFolder((IPath)new Path("src"));
        PersistenceProjectTests.assertEquals((int)1, (int)pFolder.getPersistenceResources().size());
        IFile newFile = this.project.createFile((IContainer)this.project.createFolder("src"), "SourceType2.java", "public class SourceType2 {}");
        PersistenceProjectTests.assertEquals((int)2, (int)pFolder.getPersistenceResources().size());
        PersistenceProjectTests.assertNotNull((Object)pProject.getPersistenceFile((IPath)new Path("src/SourceType2.java")));
        newFile.delete(true, null);
        PersistenceProjectTests.assertEquals((int)1, (int)pFolder.getPersistenceResources().size());
        this.project.closeProject();
        this.project.openProject();
        pProject = this.project.getPersistenceProject();
        pFolder = pProject.getPersistenceFolder((IPath)new Path("src"));
        PersistenceProjectTests.assertEquals((int)1, (int)pFolder.getPersistenceResources().size());
        newFile = this.project.createFile((IContainer)this.project.createFolder("src"), "SourceType2.java", "public class SourceType2 {}");
        PersistenceProjectTests.assertEquals((int)2, (int)pFolder.getPersistenceResources().size());
        PersistenceProjectTests.assertNotNull((Object)pProject.getPersistenceFile((IPath)new Path("src/SourceType2.java")));
        newFile.delete(true, null);
        PersistenceProjectTests.assertEquals((int)1, (int)pFolder.getPersistenceResources().size());
    }
}

