/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.dali.internal.utility.ClassTools;
import org.eclipse.dali.orm.AccessType;
import org.eclipse.dali.orm.AttributeMapping;
import org.eclipse.dali.orm.Embeddable;
import org.eclipse.dali.orm.EmbeddedIdMapping;
import org.eclipse.dali.orm.OrmFactory;
import org.eclipse.dali.orm.PersistentAttribute;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.adapters.IEmbeddedIdMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaAttributeMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaPersistentAttributeModelAdapter;
import org.eclipse.dali.orm.adapters.java.MethodAttribute;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaEmbeddedIdMappingModelAdapter
extends JavaAttributeMappingModelAdapter
implements IEmbeddedIdMappingModelAdapter {
    public static final String ANNOTATION_NAME = "EmbeddedId";

    protected AttributeMapping buildAttributeMapping(boolean isDefault) {
        return OrmFactory.eINSTANCE.createEmbeddedIdMapping(this);
    }

    public String attributeMappingName() {
        return ANNOTATION_NAME;
    }

    public void updatePersModel(CompilationUnit astRoot) {
    }

    public boolean idClassIsEmbeddable() {
        String attributeClassName = this.getAttributeClassName();
        if (attributeClassName == null) {
            return true;
        }
        PersistentType persistentType = this.getEmbeddedId().getPersistenceFile().resolvePersistentType(attributeClassName);
        if (persistentType == null) {
            return true;
        }
        return persistentType.getTypeMappingKey() == Embeddable.Key.INSTANCE;
    }

    public boolean idClassIsPublic() {
        String attributeClassName = this.getAttributeClassName();
        if (attributeClassName == null) {
            return true;
        }
        try {
            return Flags.isPublic((int)this.getTypeNamed(attributeClassName).getFlags());
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean idClassIsSerializable() {
        String[] superInterfaceSignatures = null;
        String attributeClassName = this.getAttributeClassName();
        if (attributeClassName == null) {
            return true;
        }
        try {
            superInterfaceSignatures = this.getTypeNamed(attributeClassName).getSuperInterfaceTypeSignatures();
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
        int i = 0;
        while (i < superInterfaceSignatures.length) {
            String simpleName = Signature.getSignatureSimpleName((String)superInterfaceSignatures[i]);
            simpleName.toString();
            if (simpleName.equals("Serializable")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private EmbeddedIdMapping getEmbeddedId() {
        return (EmbeddedIdMapping)this.getAttributeMapping();
    }

    private boolean idClassAccessTypeIsProperty() {
        String attributeClassName = this.getAttributeClassName();
        if (attributeClassName == null) {
            return false;
        }
        PersistentType persistentType = this.getEmbeddedId().getPersistenceFile().resolvePersistentType(attributeClassName);
        if (persistentType == null) {
            return false;
        }
        return persistentType.getAccessType() == AccessType.PROPERTY_LITERAL;
    }

    public void addProblemsTo(List problems) {
        super.addProblemsTo(problems);
        this.addIdClassNotEmbeddableProblem(problems);
        this.addIdClassNotPublicProblem(problems);
        this.addIdClassNotSerializableProblem(problems);
        this.addIdClassMissingMethodsProblem(problems);
        if (this.idClassAccessTypeIsProperty()) {
            this.addIdClassPropertiesNotPublicProblem(problems);
        }
    }

    private void addIdClassNotSerializableProblem(List problems) {
        if (!this.idClassIsSerializable()) {
            problems.add(this.buildProblem("Primary key class is not serializable", this.getTextRange()));
        }
    }

    private void addIdClassNotPublicProblem(List problems) {
        if (!this.idClassIsPublic()) {
            problems.add(this.buildProblem("Primary key class is not public", this.getTextRange()));
        }
    }

    private void addIdClassNotEmbeddableProblem(List problems) {
        if (!this.idClassIsEmbeddable()) {
            problems.add(this.buildProblem("Primary key class is not Embeddable", this.getTextRange()));
        }
    }

    private void addIdClassPropertiesNotPublicProblem(List problems) {
        if (!this.idClassPropertiesIsPublicOrProtected()) {
            problems.add(this.buildProblem("Properties of the primary key class not public or protected", this.getTextRange()));
        }
    }

    private boolean idClassPropertiesIsPublicOrProtected() {
        String idClassName = this.getAttributeClassName();
        IType idClass = this.getTypeNamed(idClassName);
        PersistentType persistentType = this.getEmbeddedId().getPersistenceFile().resolvePersistentType(idClassName);
        Iterator i = persistentType.getAllPersistentAttributes().iterator();
        while (i.hasNext()) {
            PersistentAttribute attribute = (PersistentAttribute)i.next();
            MethodAttribute methodAttribute = (MethodAttribute)((JavaPersistentAttributeModelAdapter)attribute.getModelAdapter()).getAttribute();
            IMethod method = idClass.getMethod(methodAttribute.getMethodName(), new String[0]);
            try {
                if (!Flags.isPrivate((int)method.getFlags()) && !Flags.isPackageDefault((int)method.getFlags())) continue;
                return false;
            }
            catch (JavaModelException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    private void addIdClassMissingMethodsProblem(List problems) {
        String attributeClassName = this.getAttributeClassName();
        if (attributeClassName == null) {
            return;
        }
        IType idClass = this.getTypeNamed(attributeClassName);
        String constructorName = ClassTools.shortNameForClassNamed((String)idClass.getFullyQualifiedName());
        if (!idClass.getMethod(constructorName = ClassTools.nestedNameForClassNamed((String)constructorName), new String[0]).exists()) {
            problems.add(this.buildProblem("Primary key class does not have a no-argument constructor", this.getTextRange()));
        }
        if (!idClass.getMethod("hashCode", new String[0]).exists()) {
            problems.add(this.buildProblem("Primary key class does not define hashCode()", this.getTextRange()));
        }
        if (!idClass.getMethod("equals", new String[]{"QObject;"}).exists()) {
            problems.add(this.buildProblem("Primary key class does not define equals(Object)", this.getTextRange()));
        }
    }
}

