/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.dali.core.util.jdt.AnnotationEditFormatter;
import org.eclipse.dali.core.util.jdt.JDTTools;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public abstract class Member {
    private final IMember jdtMember;

    Member(IMember jdtMember) {
        this.jdtMember = jdtMember;
    }

    public IMember getJDTMember() {
        return this.jdtMember;
    }

    public String getName() {
        return this.getJDTMember().getElementName();
    }

    public CompilationUnit createASTRoot() {
        return JDTTools.createASTRoot(this.getJDTMember());
    }

    BodyDeclaration bodyDeclaration() {
        return this.bodyDeclaration(this.createASTRoot());
    }

    abstract BodyDeclaration bodyDeclaration(CompilationUnit var1);

    public boolean containsAnyAnnotation(String[] annotationNames) {
        return this.containsAnyAnnotation(annotationNames, this.createASTRoot());
    }

    public boolean containsAnyAnnotation(String[] annotationNames, CompilationUnit astRoot) {
        return this.containsAnyAnnotation(annotationNames, this.bodyDeclaration(astRoot));
    }

    public boolean containsAnyAnnotation(String[] annotationNames, BodyDeclaration bodyDeclaration) {
        return ASTTools.containsAnyAnnotation(bodyDeclaration, annotationNames);
    }

    public boolean containsAnnotation(String annotationName) {
        return this.getAnnotation(annotationName) != null;
    }

    public boolean containsAnnotation(String annotationName, CompilationUnit astRoot) {
        return this.getAnnotation(annotationName, astRoot) != null;
    }

    public boolean containsAnnotation(String annotationName, BodyDeclaration bodyDeclaration) {
        return this.getAnnotation(annotationName, bodyDeclaration) != null;
    }

    public Annotation getAnnotation(String annotationName) {
        return this.getAnnotation(annotationName, this.createASTRoot());
    }

    public Annotation getAnnotation(String annotationName, CompilationUnit astRoot) {
        return this.getAnnotation(annotationName, this.bodyDeclaration(astRoot));
    }

    public Annotation getAnnotation(String annotationName, BodyDeclaration bodyDeclaration) {
        return ASTTools.annotation(bodyDeclaration, annotationName);
    }

    public void addAnnotation(final String annotationName) {
        if (this.containsAnnotation(annotationName)) {
            throw new IllegalStateException("annotation already exists: " + annotationName);
        }
        this.editAnnotation(new IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                ASTTools.addAnnotation(bodyDeclaration, annotationName);
            }
        });
        JDTTools.addImport(this.getJDTMember().getCompilationUnit(), "javax.persistence." + annotationName);
    }

    public void removeAnnotation(final String annotationName) {
        this.editAnnotation(new IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                Member.this.removeAnnotation(annotationName, bodyDeclaration);
            }
        });
    }

    public void removeAnnotation(String annotationName, BodyDeclaration bodyDeclaration) {
        if (!this.containsAnnotation(annotationName, bodyDeclaration)) {
            throw new IllegalStateException("annotation does not exist: " + annotationName);
        }
        ASTTools.removeAnnotation(bodyDeclaration, annotationName);
    }

    public void replaceAnnotation(final String oldAnnotationName, final String newAnnotationName) {
        this.editAnnotation(new IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                Annotation oldAnnotation = ASTTools.annotation(bodyDeclaration, oldAnnotationName);
                MarkerAnnotation newAnnotation = ASTTools.newMarkerAnnotation(bodyDeclaration.getAST(), newAnnotationName);
                ASTTools.replaceAnnotation(bodyDeclaration, oldAnnotation, (Annotation)newAnnotation);
            }
        });
        JDTTools.addImport(this.getJDTMember().getCompilationUnit(), "javax.persistence." + newAnnotationName);
    }

    public boolean containsAnnotationElement(String annotationName, String elementName) {
        return this.containsAnnotationElement(annotationName, elementName, this.createASTRoot());
    }

    public boolean containsAnnotationElement(String annotationName, String elementName, CompilationUnit astRoot) {
        return this.containsAnnotationElement(annotationName, elementName, this.bodyDeclaration(astRoot));
    }

    public boolean containsAnnotationElement(String annotationName, String elementName, BodyDeclaration bodyDeclaration) {
        return ASTTools.containsAnnotationElement(bodyDeclaration, annotationName, elementName);
    }

    public Expression getAnnotationElement(String annotationName, String elementName) {
        return this.getAnnotationElement(annotationName, elementName, this.createASTRoot());
    }

    public Expression getAnnotationElement(String annotationName, String elementName, CompilationUnit astRoot) {
        return this.getAnnotationElement(annotationName, elementName, this.bodyDeclaration(astRoot));
    }

    public Expression getAnnotationElement(String annotationName, String elementName, BodyDeclaration bodyDeclaration) {
        return ASTTools.annotationElement(bodyDeclaration, annotationName, elementName);
    }

    public String getAnnotationElementStringValue(String annotationName, String elementName) {
        return this.getAnnotationElementStringValue(annotationName, elementName, this.createASTRoot());
    }

    public String getAnnotationElementStringValue(String annotationName, String elementName, CompilationUnit astRoot) {
        return this.getAnnotationElementStringValue(annotationName, elementName, this.bodyDeclaration(astRoot));
    }

    public String getAnnotationElementStringValue(String annotationName, String elementName, BodyDeclaration bodyDeclaration) {
        return ASTTools.annotationElementStringValue(bodyDeclaration, annotationName, elementName);
    }

    public MemberValuePair getMemberValuePair(String annotationName, String elementName) {
        return this.getMemberValuePair(annotationName, elementName, this.createASTRoot());
    }

    public MemberValuePair getMemberValuePair(String annotationName, String elementName, CompilationUnit astRoot) {
        return this.getMemberValuePair(annotationName, elementName, this.bodyDeclaration(astRoot));
    }

    public MemberValuePair getMemberValuePair(String annotationName, String elementName, BodyDeclaration bodyDeclaration) {
        return ASTTools.memberValuePair(bodyDeclaration, annotationName, elementName);
    }

    public void removeAnnotationElement(final String annotationName, final String elementName) {
        if (!this.containsAnnotationElement(annotationName, elementName)) {
            throw new IllegalStateException("annotation element does not exist: " + annotationName + "(" + elementName + ")");
        }
        this.editAnnotation(new IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                ASTTools.removeAnnotationElement(bodyDeclaration, annotationName, elementName);
            }
        });
    }

    public void editAnnotation(IAnnotationEditor annotationEditor) {
        Document doc;
        ICompilationUnit compilationUnit = this.getJDTMember().getCompilationUnit();
        boolean hasTextEditor = true;
        ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(compilationUnit.getResource().getFullPath());
        if (!compilationUnit.isWorkingCopy()) {
            try {
                compilationUnit.becomeWorkingCopy(null, null);
            }
            catch (JavaModelException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (buffer == null) {
            String source;
            hasTextEditor = false;
            try {
                source = compilationUnit.getBuffer().getContents();
            }
            catch (JavaModelException e) {
                throw new RuntimeException(e);
            }
            doc = new Document(source);
        } else {
            doc = (Document)buffer.getDocument();
        }
        CompilationUnit astRoot = this.createASTRoot();
        astRoot.recordModifications();
        annotationEditor.edit(this.bodyDeclaration(astRoot));
        TextEdit edits = astRoot.rewrite((IDocument)doc, compilationUnit.getJavaProject().getOptions(true));
        try {
            AnnotationEditFormatter formatter = new AnnotationEditFormatter((IDocument)doc);
            formatter.apply(edits);
        }
        catch (MalformedTreeException ex) {
            throw new RuntimeException(ex);
        }
        catch (BadLocationException ex) {
            throw new RuntimeException(ex);
        }
        if (!hasTextEditor) {
            String newSource = doc.get();
            try {
                compilationUnit.getBuffer().setContents(newSource);
                compilationUnit.commitWorkingCopy(true, null);
                compilationUnit.discardWorkingCopy();
            }
            catch (JavaModelException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public ITextRange getTextRange(String annotationName) {
        Annotation annotation = this.getAnnotation(annotationName);
        if (annotation == null) {
            return null;
        }
        return ASTTools.textRange((ASTNode)annotation);
    }

    public static interface IAnnotationEditor {
        public void edit(BodyDeclaration var1);
    }
}

