/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.impl;

import java.util.List;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.db.Schema;
import org.eclipse.dali.db.Sequence;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.SequenceGenerator;
import org.eclipse.dali.orm.adapters.ISequenceGeneratorModelAdapter;
import org.eclipse.dali.orm.impl.GeneratorImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class SequenceGeneratorImpl
extends GeneratorImpl
implements SequenceGenerator {
    protected static final String DEFAULT_SEQUENCE_NAME_EDEFAULT = null;
    protected String defaultSequenceName = DEFAULT_SEQUENCE_NAME_EDEFAULT;
    protected static final String SPECIFIED_SEQUENCE_NAME_EDEFAULT = null;
    protected String specifiedSequenceName = SPECIFIED_SEQUENCE_NAME_EDEFAULT;
    protected static final String SEQUENCE_NAME_EDEFAULT = null;

    protected SequenceGeneratorImpl() {
    }

    protected SequenceGeneratorImpl(ISequenceGeneratorModelAdapter modelAdapter) {
        super(modelAdapter);
    }

    protected EClass eStaticClass() {
        return OrmPackage.Literals.SEQUENCE_GENERATOR;
    }

    public String getDefaultSequenceName() {
        return this.defaultSequenceName;
    }

    public void setDefaultSequenceName(String newDefaultSequenceName) {
        String oldDefaultSequenceName = this.defaultSequenceName;
        this.defaultSequenceName = newDefaultSequenceName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldDefaultSequenceName, (Object)this.defaultSequenceName));
        }
    }

    public String getSpecifiedSequenceName() {
        return this.specifiedSequenceName;
    }

    public void setSpecifiedSequenceNameGen(String newSpecifiedSequenceName) {
        String oldSpecifiedSequenceName = this.specifiedSequenceName;
        this.specifiedSequenceName = newSpecifiedSequenceName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldSpecifiedSequenceName, (Object)this.specifiedSequenceName));
        }
    }

    public void setSpecifiedSequenceName(String newSpecifiedSequenceName) {
        this.setSpecifiedSequenceNameGen(newSpecifiedSequenceName);
        ((ISequenceGeneratorModelAdapter)this.getModelAdapter()).specifiedSequenceNameChanged();
    }

    public String getSequenceName() {
        return this.getSpecifiedSequenceName() == null ? this.getDefaultSequenceName() : this.getSpecifiedSequenceName();
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                return this.getDefaultSequenceName();
            }
            case 9: {
                return this.getSpecifiedSequenceName();
            }
            case 10: {
                return this.getSequenceName();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.setDefaultSequenceName((String)newValue);
                return;
            }
            case 9: {
                this.setSpecifiedSequenceName((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.setDefaultSequenceName(DEFAULT_SEQUENCE_NAME_EDEFAULT);
                return;
            }
            case 9: {
                this.setSpecifiedSequenceName(SPECIFIED_SEQUENCE_NAME_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return DEFAULT_SEQUENCE_NAME_EDEFAULT == null ? this.defaultSequenceName != null : !DEFAULT_SEQUENCE_NAME_EDEFAULT.equals(this.defaultSequenceName);
            }
            case 9: {
                return SPECIFIED_SEQUENCE_NAME_EDEFAULT == null ? this.specifiedSequenceName != null : !SPECIFIED_SEQUENCE_NAME_EDEFAULT.equals(this.specifiedSequenceName);
            }
            case 10: {
                return SEQUENCE_NAME_EDEFAULT == null ? this.getSequenceName() != null : !SEQUENCE_NAME_EDEFAULT.equals(this.getSequenceName());
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (defaultSequenceName: ");
        result.append(this.defaultSequenceName);
        result.append(", specifiedSequenceName: ");
        result.append(this.specifiedSequenceName);
        result.append(')');
        return result.toString();
    }

    public Sequence getSequence() {
        Schema schema = this.getPersistenceProject().getSchema();
        return schema == null ? null : schema.sequenceNamed(this.getSequenceName());
    }

    public void addProblemsTo(List problems) {
        super.addProblemsTo(problems);
        this.addUnresolvedSequenceGeneratorProblemTo(problems);
    }

    private void addUnresolvedSequenceGeneratorProblemTo(List problems) {
        Sequence sequence;
        if (this.getSequenceName() == null) {
            return;
        }
        if (this.getPersistenceProject().getConnection().isConnected() && (sequence = this.getSequence()) == null) {
            problems.add(this.buildProblem("The sequence " + this.getSequenceName() + " cannot be found on the database", this.sequenceNameTextRange()));
        }
    }

    private ITextRange sequenceNameTextRange() {
        ITextRange textRange = ((ISequenceGeneratorModelAdapter)this.getModelAdapter()).sequenceNameTextRange();
        if (textRange == null) {
            return this.getTextRange();
        }
        return textRange;
    }
}

