/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.db;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.text.Collator;
import org.eclipse.dali.db.ConnectionListener;
import org.eclipse.dali.db.Database;
import org.eclipse.dali.db.NullConnection;
import org.eclipse.dali.db.RDBConnectionInfoWrapper;
import org.eclipse.dali.db.Schema;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.internal.utility.StringTools;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;

public abstract class Connection
implements Comparable {
    static Connection createConnection(ConnectionInfo rdbConnectionInfo) {
        return rdbConnectionInfo == null ? NullConnection.instance() : new RDBConnectionInfoWrapper(rdbConnectionInfo);
    }

    Connection() {
    }

    public abstract void connect(String var1, String var2) throws Exception;

    public abstract void connect() throws Exception;

    public abstract void disconnect() throws SQLException;

    public abstract void saveConnectionInfo() throws FileNotFoundException, IOException;

    public abstract void dispose();

    public abstract void connected(java.sql.Connection var1);

    public abstract void disconnected(java.sql.Connection var1);

    abstract boolean wraps(ConnectionInfo var1);

    public abstract String getName();

    public abstract String getUserName();

    public abstract String getDatabaseProduct();

    public abstract String getDatabaseName();

    public abstract String getDatabaseVersion();

    public abstract Database getDatabase();

    abstract void schemaChanged(Schema var1, Database var2, int var3);

    abstract void tableChanged(Table var1, Schema var2, Database var3, int var4);

    public boolean isConnected() {
        return this.getDatabase().isConnected();
    }

    protected abstract boolean isOnLine();

    protected abstract boolean isOffLine();

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.getName());
    }

    public abstract void addConnectionListener(ConnectionListener var1);

    public abstract void removeConnectionListener(ConnectionListener var1);

    public int compareTo(Object o) {
        return Collator.getInstance().compare(this.getName(), ((Connection)o).getName());
    }
}

