/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dali.db.Connection;
import org.eclipse.dali.db.ConnectionListener;
import org.eclipse.dali.db.Database;
import org.eclipse.dali.db.Schema;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.internal.utility.StringTools;
import org.eclipse.dali.orm.Column;
import org.eclipse.dali.orm.Insertable;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.PersistenceProject;
import org.eclipse.dali.orm.Table;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.Updatable;
import org.eclipse.dali.orm.adapters.IColumnModelAdapter;
import org.eclipse.dali.orm.provider.ColumnItemProvider;
import org.eclipse.dali.orm.provider.EntityItemProvider;
import org.eclipse.dali.orm.provider.OrmItemProviderAdapterFactory;
import org.eclipse.dali.orm.provider.TableItemProvider;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class ColumnComposite
extends Composite
implements IPersistenceComposite {
    Column column;
    private TypeMapping typeMapping;
    private ColumnItemProvider columnItemProvider;
    private EntityItemProvider entityItemProvider;
    private TableItemProvider tableItemProvider;
    private Connection connection;
    private INotifyChangedListener columnListener;
    private INotifyChangedListener entityListener;
    private INotifyChangedListener tableListener;
    EditingDomain editingDomain;
    Combo columnCombo;
    Combo tableCombo;
    ComboViewer insertableComboViewer;
    ComboViewer updatableComboViewer;
    boolean populating;
    private ConnectionListener connectionListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public ColumnComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory, String columnHelpContextId) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.columnItemProvider = (ColumnItemProvider)adapterFactory.createColumnAdapter();
        this.entityItemProvider = (EntityItemProvider)adapterFactory.createEntityAdapter();
        this.tableItemProvider = (TableItemProvider)adapterFactory.createTableAdapter();
        this.connectionListener = this.buildConnectionListener();
        this.initializeLayout(columnHelpContextId);
    }

    private void initializeLayout(String columnHelpContextId) {
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        Group columnGroup = new Group((Composite)this, 16);
        columnGroup.setText(DaliUiMessages.ColumnComposite_columnSection);
        columnGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        columnGroup.setLayoutData((Object)gridData);
        Label columnLabel = new Label((Composite)columnGroup, 16384);
        columnLabel.setText(DaliUiMessages.ColumnComposite_column);
        this.columnCombo = this.buildColumnCombo((Composite)columnGroup);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.columnCombo.setLayoutData((Object)gridData);
        helpSystem.setHelp((Control)this.columnCombo, columnHelpContextId);
        Label tableNameLabel = new Label((Composite)columnGroup, 16384);
        tableNameLabel.setText(DaliUiMessages.ColumnComposite_tableName);
        this.tableCombo = this.buildTableCombo((Composite)columnGroup);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.tableCombo.setLayoutData((Object)gridData);
        helpSystem.setHelp((Control)this.tableCombo, "org.eclipse.dali.ui.mapping_columnTable");
        Label insertableLabel = new Label((Composite)columnGroup, 16384);
        insertableLabel.setText(DaliUiMessages.ColumnComposite_insertable);
        this.insertableComboViewer = this.buildInsertableComboViewer((Composite)columnGroup);
        this.insertableComboViewer.getCombo().setLayoutData((Object)new GridData(768));
        helpSystem.setHelp((Control)this.insertableComboViewer.getCombo(), "org.eclipse.dali.ui.mapping_columnInsertable");
        Label updatableLabel = new Label((Composite)columnGroup, 16384);
        updatableLabel.setText(DaliUiMessages.ColumnComposite_updatable);
        this.updatableComboViewer = this.buildUpdatableComboViewer((Composite)columnGroup);
        this.updatableComboViewer.getCombo().setLayoutData((Object)new GridData(768));
        helpSystem.setHelp((Control)this.updatableComboViewer.getCombo(), "org.eclipse.dali.ui.mapping_columnUpdatable");
    }

    private Combo buildColumnCombo(Composite parent) {
        Combo combo = new Combo(parent, 2052);
        combo.add(DaliUiMessages.ColumnComposite_defaultEmpty);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ColumnComposite.this.columnComboModified(e);
            }
        });
        return combo;
    }

    protected void columnComboModified(ModifyEvent e) {
        if (this.populating) {
            return;
        }
        Combo combo = (Combo)e.getSource();
        String columnText = combo.getText();
        if (columnText.equals("")) {
            columnText = null;
            if (this.column.getSpecifiedName() == null || this.column.getSpecifiedName().equals("")) {
                return;
            }
        }
        if (columnText != null && combo.getItemCount() > 0 && columnText.equals(combo.getItem(0))) {
            columnText = null;
        }
        if (this.column.getSpecifiedName() == null || !this.stringsAreEqual(this.column.getSpecifiedName(), columnText)) {
            this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)this.column, (Object)OrmPackage.eINSTANCE.getColumn_SpecifiedName(), (Object)columnText));
        }
    }

    private Combo buildTableCombo(Composite parent) {
        final Combo combo = new Combo(parent, 2052);
        combo.add(DaliUiMessages.ColumnComposite_defaultEmpty);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ColumnComposite.this.tableColumnModified(combo, e);
            }
        });
        return combo;
    }

    protected void tableColumnModified(Combo combo, ModifyEvent e) {
        if (this.populating) {
            return;
        }
        String newTableName = ((Combo)e.getSource()).getText();
        if (newTableName.equals("")) {
            newTableName = null;
            if (this.column.getSpecifiedTableName() == null || this.column.getSpecifiedTableName().equals("")) {
                return;
            }
        }
        if (newTableName != null && combo.getItemCount() > 0 && newTableName.equals(combo.getItem(0))) {
            newTableName = null;
        }
        if (this.column.getSpecifiedTableName() == null || !this.stringsAreEqual(this.column.getSpecifiedTableName(), newTableName)) {
            this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)this.column, (Object)OrmPackage.eINSTANCE.getColumn_SpecifiedTableName(), (Object)newTableName));
        }
    }

    private ComboViewer buildInsertableComboViewer(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.add(Insertable.VALUES.toArray());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ColumnComposite.this.insertableSelectionChanged(event.getSelection());
            }
        });
        return viewer;
    }

    void insertableSelectionChanged(ISelection selection) {
        if (this.populating) {
            return;
        }
        if (selection instanceof IStructuredSelection) {
            Insertable insertable = (Insertable)((IStructuredSelection)selection).getFirstElement();
            if (this.column.getInsertable() != insertable) {
                this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)this.column, (Object)OrmPackage.eINSTANCE.getColumn_Insertable(), (Object)insertable));
            }
        }
    }

    private ComboViewer buildUpdatableComboViewer(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.add(Updatable.VALUES.toArray());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ColumnComposite.this.updatableSelectionChanged(event.getSelection());
            }
        });
        return viewer;
    }

    void updatableSelectionChanged(ISelection selection) {
        if (this.populating) {
            return;
        }
        if (selection instanceof IStructuredSelection) {
            Updatable updatable = (Updatable)((IStructuredSelection)selection).getFirstElement();
            if (this.column.getUpdatable() != updatable) {
                this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)this.column, (Object)OrmPackage.eINSTANCE.getColumn_Updatable(), (Object)updatable));
            }
        }
    }

    private INotifyChangedListener getColumnListener() {
        if (this.columnListener == null) {
            this.columnListener = this.buildColumnListener();
        }
        return this.columnListener;
    }

    private INotifyChangedListener buildColumnListener() {
        return new INotifyChangedListener(){

            public void notifyChanged(Notification notification) {
                ColumnComposite.this.columnChanged(notification);
            }
        };
    }

    void columnChanged(Notification notification) {
        if (this.populating || notification.getNotifier() != this.column) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.orm.Column");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        switch (notification.getFeatureID((Class)clazz)) {
            case 1: {
                final String columnName = (String)notification.getNewValue();
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        ColumnComposite.this.populating = true;
                        if (ColumnComposite.this.columnCombo.getText() == null || !ColumnComposite.this.columnCombo.getText().equals(columnName)) {
                            if (columnName == null) {
                                ColumnComposite.this.columnCombo.select(0);
                            } else {
                                ColumnComposite.this.columnCombo.setText(columnName);
                            }
                        }
                        ColumnComposite.this.populating = false;
                    }
                });
                break;
            }
            case 0: {
                final String defaultColumnName = (String)notification.getNewValue();
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        ColumnComposite.this.populating = true;
                        int selectionIndex = ColumnComposite.this.columnCombo.getSelectionIndex();
                        ColumnComposite.this.columnCombo.setItem(0, NLS.bind((String)DaliUiMessages.ColumnComposite_defaultWithOneParam, (Object)defaultColumnName));
                        if (selectionIndex == 0) {
                            ColumnComposite.this.columnCombo.select(0);
                        }
                        ColumnComposite.this.populating = false;
                    }
                });
                break;
            }
            case 8: 
            case 9: {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        ColumnComposite.this.populating = true;
                        ColumnComposite.this.populateColumnCombo();
                        ColumnComposite.this.populateTableSelectionAndDefault();
                        ColumnComposite.this.populating = false;
                    }
                });
                break;
            }
            case 5: {
                final Insertable insertable = (Insertable)notification.getNewValue();
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        ColumnComposite.this.insertableChanged(insertable);
                    }
                });
                break;
            }
            case 6: {
                final Updatable updatable = (Updatable)notification.getNewValue();
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        ColumnComposite.this.updatableChanged(updatable);
                    }
                });
            }
        }
    }

    private INotifyChangedListener getEntityListener() {
        if (this.entityListener == null) {
            this.entityListener = this.buildEntityListener();
        }
        return this.entityListener;
    }

    private INotifyChangedListener buildEntityListener() {
        return new INotifyChangedListener(){

            public void notifyChanged(Notification notification) {
                ColumnComposite.this.entityChanged(notification);
            }
        };
    }

    void entityChanged(Notification notification) {
        if (this.populating) {
            return;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.dali.orm.Entity");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        switch (notification.getFeatureID((Class)clazz)) {
            case 4: {
                Table oldTable = (Table)notification.getOldValue();
                Table newTable = (Table)notification.getNewValue();
                if (oldTable != null) {
                    oldTable.eAdapters().remove((Object)this.tableItemProvider);
                }
                if (newTable != null) {
                    newTable.eAdapters().add((Object)this.tableItemProvider);
                }
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        ColumnComposite.this.populating = true;
                        ColumnComposite.this.populateTableComboChoices();
                        ColumnComposite.this.populating = false;
                    }
                });
                break;
            }
            case 5: {
                switch (notification.getEventType()) {
                    case 3: {
                        ((Table)notification.getNewValue()).eAdapters().add((Object)this.tableItemProvider);
                        break;
                    }
                    case 5: {
                        Iterator stream = ((List)notification.getNewValue()).iterator();
                        while (stream.hasNext()) {
                            ((Table)stream.next()).eAdapters().add((Object)this.tableItemProvider);
                        }
                        break;
                    }
                    case 4: {
                        ((Table)notification.getOldValue()).eAdapters().remove((Object)this.tableItemProvider);
                        break;
                    }
                    case 6: {
                        Iterator stream = ((List)notification.getOldValue()).iterator();
                        while (stream.hasNext()) {
                            ((Table)stream.next()).eAdapters().remove((Object)this.tableItemProvider);
                        }
                        break;
                    }
                }
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        ColumnComposite.this.populating = true;
                        ColumnComposite.this.populateTableComboChoices();
                        ColumnComposite.this.populating = false;
                    }
                });
            }
        }
    }

    private INotifyChangedListener getTableListener() {
        if (this.tableListener == null) {
            this.tableListener = this.buildTableListener();
        }
        return this.tableListener;
    }

    private INotifyChangedListener buildTableListener() {
        return new INotifyChangedListener(){

            public void notifyChanged(Notification notification) {
                ColumnComposite.this.tableChanged(notification);
            }
        };
    }

    void tableChanged(Notification notification) {
        if (this.populating) {
            return;
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.dali.orm.Table");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        switch (notification.getFeatureID((Class)clazz)) {
            case 0: 
            case 1: {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        ColumnComposite.this.populating = true;
                        ColumnComposite.this.populateTableComboChoices();
                        ColumnComposite.this.populating = false;
                    }
                });
            }
        }
    }

    private ConnectionListener buildConnectionListener() {
        return new ConnectionListener(){

            public void connectionInfoRenamed(String previousName, Connection connection) {
            }

            public void connected(Connection connection) {
            }

            public void disconnected(Connection connection) {
            }

            public void sharedConnectionAdded(Connection connection) {
            }

            public void sharedConnectionRemove(Connection connection) {
            }

            public void schemaChanged(Schema schema) {
                ColumnComposite.this.populateColumnCombo();
            }

            public void tableChanged(org.eclipse.dali.db.Table table) {
                if (table.getName().equalsIgnoreCase(ColumnComposite.this.column.getTableName())) {
                    ColumnComposite.this.populateColumnCombo();
                }
            }

            public void databaseAdded(Connection connection, Database database) {
                ColumnComposite.this.populateColumnCombo();
            }

            public void databaseRemove(Connection connection, Database database) {
                ColumnComposite.this.populateColumnCombo();
            }

            public void onSQLException(Connection connection, SQLException exception) {
            }
        };
    }

    void insertableChanged(Insertable insertable) {
        if (((IStructuredSelection)this.insertableComboViewer.getSelection()).getFirstElement() != insertable) {
            this.insertableComboViewer.setSelection((ISelection)new StructuredSelection((Object)insertable));
        }
    }

    void updatableChanged(Updatable updatable) {
        if (((IStructuredSelection)this.updatableComboViewer.getSelection()).getFirstElement() != updatable) {
            this.updatableComboViewer.setSelection((ISelection)new StructuredSelection((Object)updatable));
        }
    }

    public void populate(EObject model) {
        Updatable updatable;
        this.populating = true;
        this.disengageListeners();
        this.column = (Column)model;
        if (this.column == null) {
            this.typeMapping = null;
            this.insertableComboViewer.setSelection(null);
            this.updatableComboViewer.setSelection(null);
            this.tableCombo.setText("");
            this.columnCombo.setText("");
            this.populating = false;
            return;
        }
        this.engageListeners();
        this.populateColumnCombo();
        this.populateTableCombo();
        Insertable insertable = this.column.getInsertable();
        if (insertable != ((IStructuredSelection)this.insertableComboViewer.getSelection()).getFirstElement()) {
            this.insertableComboViewer.setSelection((ISelection)new StructuredSelection((Object)insertable));
        }
        if ((updatable = this.column.getUpdatable()) != ((IStructuredSelection)this.updatableComboViewer.getSelection()).getFirstElement()) {
            this.updatableComboViewer.setSelection((ISelection)new StructuredSelection((Object)updatable));
        }
        this.populating = false;
    }

    private void engageListeners() {
        this.columnItemProvider.addListener(this.getColumnListener());
        this.column.eAdapters().add((Object)this.columnItemProvider);
        this.entityItemProvider.addListener(this.getEntityListener());
        this.typeMapping = ((IColumnModelAdapter)this.column.getModelAdapter()).getOwner().getTypeMapping();
        this.typeMapping.eAdapters().add((Object)this.entityItemProvider);
        this.tableItemProvider.addListener(this.getTableListener());
        this.addConnectionListener();
    }

    private void disengageListeners() {
        if (this.column != null) {
            this.removeConnectionListener();
            this.column.eAdapters().remove((Object)this.columnItemProvider);
            this.columnItemProvider.removeListener(this.getColumnListener());
            this.typeMapping.eAdapters().remove((Object)this.entityItemProvider);
            this.entityItemProvider.removeListener(this.getEntityListener());
            this.tableItemProvider.removeListener(this.getTableListener());
        }
    }

    private org.eclipse.dali.db.Table getDbTable() {
        return ((IColumnModelAdapter)this.column.getModelAdapter()).getOwner().getTableNamed(this.column.getTableName());
    }

    void populateColumnCombo() {
        String columnName = this.column.getSpecifiedName();
        String defaultColumnName = this.column.getDefaultName();
        this.columnCombo.setItem(0, NLS.bind((String)DaliUiMessages.ColumnComposite_defaultWithOneParam, (Object)defaultColumnName));
        PersistenceProject persistenceProject = this.column.getPersistenceProject();
        Connection connection = persistenceProject.getConnection();
        if (connection.isConnected()) {
            this.columnCombo.remove(1, this.columnCombo.getItemCount() - 1);
            org.eclipse.dali.db.Table table = this.getDbTable();
            if (table != null) {
                Iterator i = CollectionTools.sort((List)CollectionTools.list((Iterator)table.columnNames())).iterator();
                while (i.hasNext()) {
                    this.columnCombo.add((String)i.next());
                }
            }
        } else {
            this.columnCombo.remove(1, this.columnCombo.getItemCount() - 1);
        }
        if (columnName != null) {
            if (!this.columnCombo.getText().equals(columnName)) {
                this.columnCombo.setText(columnName);
            }
        } else if (!this.columnCombo.getText().equals(NLS.bind((String)DaliUiMessages.ColumnComposite_defaultWithOneParam, (Object)defaultColumnName))) {
            this.columnCombo.select(0);
        }
    }

    private Iterator associatedTableNames() {
        return ((IColumnModelAdapter)this.column.getModelAdapter()).getOwner().getTypeMapping().associatedTableNamesIncludingInherited();
    }

    private void populateTableCombo() {
        this.populateTableComboChoices();
        this.populateTableSelectionAndDefault();
    }

    void populateTableSelectionAndDefault() {
        String specifiedTableName = this.column.getSpecifiedTableName();
        String defaultTableName = this.column.getDefaultTableName();
        this.tableCombo.setItem(0, NLS.bind((String)DaliUiMessages.ColumnComposite_defaultWithOneParam, (Object)defaultTableName));
        if (specifiedTableName != null) {
            if (!this.stringsAreEqual(this.tableCombo.getText(), specifiedTableName)) {
                this.tableCombo.setText(specifiedTableName);
            }
        } else if (!this.stringsAreEqual(this.tableCombo.getText(), NLS.bind((String)DaliUiMessages.ColumnComposite_defaultWithOneParam, (Object)defaultTableName))) {
            this.tableCombo.select(0);
        }
    }

    void populateTableComboChoices() {
        String initialText = this.tableCombo.getText();
        this.tableCombo.remove(1, this.tableCombo.getItemCount() - 1);
        Iterator tables = this.associatedTableNames();
        while (tables.hasNext()) {
            String table = (String)tables.next();
            this.tableCombo.add(table);
        }
        if (!this.tableCombo.getText().equals(initialText)) {
            this.columnCombo.setText(initialText);
        }
    }

    private void addConnectionListener() {
        this.connection = this.column.getPersistenceProject().getConnection();
        this.connection.addConnectionListener(this.connectionListener);
    }

    private void removeConnectionListener() {
        this.connection.removeConnectionListener(this.connectionListener);
        this.connection = null;
    }

    boolean stringsAreEqual(String string1, String string2) {
        if (this.ignoreCase()) {
            return StringTools.stringsAreEqualIgnoreCase((String)string1, (String)string2);
        }
        return string1.equals(string2);
    }

    private boolean ignoreCase() {
        return true;
    }

    protected void enableWidgets(boolean enabled) {
        this.columnCombo.setEnabled(enabled);
        this.tableCombo.setEnabled(enabled);
        this.insertableComboViewer.getCombo().setEnabled(enabled);
        this.updatableComboViewer.getCombo().setEnabled(enabled);
    }

    public void dispose() {
        this.disengageListeners();
        super.dispose();
    }
}

