/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dali.core.DaliPlugin;
import org.eclipse.dali.orm.adapters.java.Type;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.PersistenceUiPlugin;
import org.eclipse.dali.ui.wizards.ConfigureJPAProjectWizard;
import org.eclipse.dali.ui.wizards.NewElementWizard;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;

public class NewEntityCreationWizard
extends NewElementWizard {
    private NewClassWizardPage firstPage;

    public NewEntityCreationWizard() {
        this.setDialogSettings(PersistenceUiPlugin.getPlugin().getDialogSettings());
        this.setWindowTitle(DaliUiMessages.NewEntityCreationWizard_createNewEntity);
    }

    public void addPages() {
        super.addPages();
        this.firstPage = new NewClassWizardPage();
        this.addPage((IWizardPage)this.firstPage);
        this.firstPage.init(this.getSelection());
    }

    protected boolean canRunForked() {
        return !this.firstPage.isEnclosingTypeSelected();
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.firstPage.createType(monitor);
        IType newType = this.firstPage.getCreatedType();
        Type jdtType = new Type(newType);
        jdtType.addAnnotation("Entity");
    }

    public boolean performFinish() {
        this.warnAboutTypeCommentDeprecation();
        boolean res = super.performFinish();
        if (res) {
            IResource resource;
            IType newType = this.firstPage.getCreatedType();
            IJavaProject javaProject = newType.getJavaProject();
            if (!DaliPlugin.projectHasPersistenceNature((IJavaProject)javaProject)) {
                ConfigureJPAProjectWizard wizard = new ConfigureJPAProjectWizard(javaProject);
                WizardDialog dialog = new WizardDialog(PersistenceUiPlugin.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                dialog.create();
                dialog.open();
            }
            if ((resource = this.firstPage.getModifiedResource()) != null) {
                this.selectAndReveal(resource);
                this.openResource((IFile)resource);
            }
        }
        return res;
    }
}

